/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataSourceFilterAttribute {
    DIRECT_QUICKSIGHT_VIEWER_OR_OWNER("DIRECT_QUICKSIGHT_VIEWER_OR_OWNER"),
    DIRECT_QUICKSIGHT_OWNER("DIRECT_QUICKSIGHT_OWNER"),
    DIRECT_QUICKSIGHT_SOLE_OWNER("DIRECT_QUICKSIGHT_SOLE_OWNER"),
    DATASOURCE_NAME("DATASOURCE_NAME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataSourceFilterAttribute> VALUE_MAP;
    private final String value;

    private DataSourceFilterAttribute(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataSourceFilterAttribute fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataSourceFilterAttribute> knownValues() {
        EnumSet<DataSourceFilterAttribute> knownValues = EnumSet.allOf(DataSourceFilterAttribute.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataSourceFilterAttribute.class, DataSourceFilterAttribute::toString);
    }
}

