/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.Group;
import software.amazon.awssdk.services.quicksight.model.ListUserGroupsRequest;
import software.amazon.awssdk.services.quicksight.model.ListUserGroupsResponse;

public class ListUserGroupsIterable
implements SdkIterable<ListUserGroupsResponse> {
    private final QuickSightClient client;
    private final ListUserGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUserGroupsIterable(QuickSightClient client, ListUserGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListUserGroupsResponseFetcher();
    }

    public Iterator<ListUserGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Group> groupList() {
        Function<ListUserGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.groupList() != null) {
                return response.groupList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListUserGroupsResponseFetcher
    implements SyncPageFetcher<ListUserGroupsResponse> {
        private ListUserGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListUserGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListUserGroupsResponse nextPage(ListUserGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListUserGroupsIterable.this.client.listUserGroups(ListUserGroupsIterable.this.firstRequest);
            }
            return ListUserGroupsIterable.this.client.listUserGroups((ListUserGroupsRequest)((Object)ListUserGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

