/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.DashboardVersionSummary;
import software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsResponse;

public class ListDashboardVersionsIterable
implements SdkIterable<ListDashboardVersionsResponse> {
    private final QuickSightClient client;
    private final ListDashboardVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDashboardVersionsIterable(QuickSightClient client, ListDashboardVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDashboardVersionsResponseFetcher();
    }

    public Iterator<ListDashboardVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DashboardVersionSummary> dashboardVersionSummaryList() {
        Function<ListDashboardVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dashboardVersionSummaryList() != null) {
                return response.dashboardVersionSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDashboardVersionsResponseFetcher
    implements SyncPageFetcher<ListDashboardVersionsResponse> {
        private ListDashboardVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDashboardVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDashboardVersionsResponse nextPage(ListDashboardVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListDashboardVersionsIterable.this.client.listDashboardVersions(ListDashboardVersionsIterable.this.firstRequest);
            }
            return ListDashboardVersionsIterable.this.client.listDashboardVersions((ListDashboardVersionsRequest)((Object)ListDashboardVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

