/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueueInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueueInfo> {
    private static final SdkField<String> WAITING_ON_INGESTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WaitingOnIngestion").getter(QueueInfo.getter(QueueInfo::waitingOnIngestion)).setter(QueueInfo.setter(Builder::waitingOnIngestion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitingOnIngestion").build()}).build();
    private static final SdkField<String> QUEUED_INGESTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueuedIngestion").getter(QueueInfo.getter(QueueInfo::queuedIngestion)).setter(QueueInfo.setter(Builder::queuedIngestion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueuedIngestion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WAITING_ON_INGESTION_FIELD, QUEUED_INGESTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String waitingOnIngestion;
    private final String queuedIngestion;

    private QueueInfo(BuilderImpl builder) {
        this.waitingOnIngestion = builder.waitingOnIngestion;
        this.queuedIngestion = builder.queuedIngestion;
    }

    public final String waitingOnIngestion() {
        return this.waitingOnIngestion;
    }

    public final String queuedIngestion() {
        return this.queuedIngestion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.waitingOnIngestion());
        hashCode = 31 * hashCode + Objects.hashCode(this.queuedIngestion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueueInfo)) {
            return false;
        }
        QueueInfo other = (QueueInfo)obj;
        return Objects.equals(this.waitingOnIngestion(), other.waitingOnIngestion()) && Objects.equals(this.queuedIngestion(), other.queuedIngestion());
    }

    public final String toString() {
        return ToString.builder((String)"QueueInfo").add("WaitingOnIngestion", (Object)this.waitingOnIngestion()).add("QueuedIngestion", (Object)this.queuedIngestion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WaitingOnIngestion": {
                return Optional.ofNullable(clazz.cast(this.waitingOnIngestion()));
            }
            case "QueuedIngestion": {
                return Optional.ofNullable(clazz.cast(this.queuedIngestion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueueInfo, T> g) {
        return obj -> g.apply((QueueInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String waitingOnIngestion;
        private String queuedIngestion;

        private BuilderImpl() {
        }

        private BuilderImpl(QueueInfo model) {
            this.waitingOnIngestion(model.waitingOnIngestion);
            this.queuedIngestion(model.queuedIngestion);
        }

        public final String getWaitingOnIngestion() {
            return this.waitingOnIngestion;
        }

        public final void setWaitingOnIngestion(String waitingOnIngestion) {
            this.waitingOnIngestion = waitingOnIngestion;
        }

        @Override
        public final Builder waitingOnIngestion(String waitingOnIngestion) {
            this.waitingOnIngestion = waitingOnIngestion;
            return this;
        }

        public final String getQueuedIngestion() {
            return this.queuedIngestion;
        }

        public final void setQueuedIngestion(String queuedIngestion) {
            this.queuedIngestion = queuedIngestion;
        }

        @Override
        public final Builder queuedIngestion(String queuedIngestion) {
            this.queuedIngestion = queuedIngestion;
            return this;
        }

        public QueueInfo build() {
            return new QueueInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueueInfo> {
        public Builder waitingOnIngestion(String var1);

        public Builder queuedIngestion(String var1);
    }
}

