/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.Icon;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConditionalFormattingCustomIconOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConditionalFormattingCustomIconOptions> {
    private static final SdkField<String> ICON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Icon").getter(ConditionalFormattingCustomIconOptions.getter(ConditionalFormattingCustomIconOptions::iconAsString)).setter(ConditionalFormattingCustomIconOptions.setter(Builder::icon)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Icon").build()}).build();
    private static final SdkField<String> UNICODE_ICON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UnicodeIcon").getter(ConditionalFormattingCustomIconOptions.getter(ConditionalFormattingCustomIconOptions::unicodeIcon)).setter(ConditionalFormattingCustomIconOptions.setter(Builder::unicodeIcon)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnicodeIcon").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ICON_FIELD, UNICODE_ICON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String icon;
    private final String unicodeIcon;

    private ConditionalFormattingCustomIconOptions(BuilderImpl builder) {
        this.icon = builder.icon;
        this.unicodeIcon = builder.unicodeIcon;
    }

    public final Icon icon() {
        return Icon.fromValue(this.icon);
    }

    public final String iconAsString() {
        return this.icon;
    }

    public final String unicodeIcon() {
        return this.unicodeIcon;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iconAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.unicodeIcon());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionalFormattingCustomIconOptions)) {
            return false;
        }
        ConditionalFormattingCustomIconOptions other = (ConditionalFormattingCustomIconOptions)obj;
        return Objects.equals(this.iconAsString(), other.iconAsString()) && Objects.equals(this.unicodeIcon(), other.unicodeIcon());
    }

    public final String toString() {
        return ToString.builder((String)"ConditionalFormattingCustomIconOptions").add("Icon", (Object)this.iconAsString()).add("UnicodeIcon", (Object)this.unicodeIcon()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Icon": {
                return Optional.ofNullable(clazz.cast(this.iconAsString()));
            }
            case "UnicodeIcon": {
                return Optional.ofNullable(clazz.cast(this.unicodeIcon()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConditionalFormattingCustomIconOptions, T> g) {
        return obj -> g.apply((ConditionalFormattingCustomIconOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String icon;
        private String unicodeIcon;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionalFormattingCustomIconOptions model) {
            this.icon(model.icon);
            this.unicodeIcon(model.unicodeIcon);
        }

        public final String getIcon() {
            return this.icon;
        }

        public final void setIcon(String icon) {
            this.icon = icon;
        }

        @Override
        public final Builder icon(String icon) {
            this.icon = icon;
            return this;
        }

        @Override
        public final Builder icon(Icon icon) {
            this.icon(icon == null ? null : icon.toString());
            return this;
        }

        public final String getUnicodeIcon() {
            return this.unicodeIcon;
        }

        public final void setUnicodeIcon(String unicodeIcon) {
            this.unicodeIcon = unicodeIcon;
        }

        @Override
        public final Builder unicodeIcon(String unicodeIcon) {
            this.unicodeIcon = unicodeIcon;
            return this;
        }

        public ConditionalFormattingCustomIconOptions build() {
            return new ConditionalFormattingCustomIconOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConditionalFormattingCustomIconOptions> {
        public Builder icon(String var1);

        public Builder icon(Icon var1);

        public Builder unicodeIcon(String var1);
    }
}

