/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AssetBundleExportFormat;
import software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetBundleExportJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetBundleExportJobSummary> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(AssetBundleExportJobSummary.getter(AssetBundleExportJobSummary::jobStatusAsString)).setter(AssetBundleExportJobSummary.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(AssetBundleExportJobSummary.getter(AssetBundleExportJobSummary::arn)).setter(AssetBundleExportJobSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(AssetBundleExportJobSummary.getter(AssetBundleExportJobSummary::createdTime)).setter(AssetBundleExportJobSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> ASSET_BUNDLE_EXPORT_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssetBundleExportJobId").getter(AssetBundleExportJobSummary.getter(AssetBundleExportJobSummary::assetBundleExportJobId)).setter(AssetBundleExportJobSummary.setter(Builder::assetBundleExportJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetBundleExportJobId").build()}).build();
    private static final SdkField<Boolean> INCLUDE_ALL_DEPENDENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeAllDependencies").getter(AssetBundleExportJobSummary.getter(AssetBundleExportJobSummary::includeAllDependencies)).setter(AssetBundleExportJobSummary.setter(Builder::includeAllDependencies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeAllDependencies").build()}).build();
    private static final SdkField<String> EXPORT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportFormat").getter(AssetBundleExportJobSummary.getter(AssetBundleExportJobSummary::exportFormatAsString)).setter(AssetBundleExportJobSummary.setter(Builder::exportFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportFormat").build()}).build();
    private static final SdkField<Boolean> INCLUDE_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludePermissions").getter(AssetBundleExportJobSummary.getter(AssetBundleExportJobSummary::includePermissions)).setter(AssetBundleExportJobSummary.setter(Builder::includePermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludePermissions").build()}).build();
    private static final SdkField<Boolean> INCLUDE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeTags").getter(AssetBundleExportJobSummary.getter(AssetBundleExportJobSummary::includeTags)).setter(AssetBundleExportJobSummary.setter(Builder::includeTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeTags").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD, ARN_FIELD, CREATED_TIME_FIELD, ASSET_BUNDLE_EXPORT_JOB_ID_FIELD, INCLUDE_ALL_DEPENDENCIES_FIELD, EXPORT_FORMAT_FIELD, INCLUDE_PERMISSIONS_FIELD, INCLUDE_TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobStatus;
    private final String arn;
    private final Instant createdTime;
    private final String assetBundleExportJobId;
    private final Boolean includeAllDependencies;
    private final String exportFormat;
    private final Boolean includePermissions;
    private final Boolean includeTags;

    private AssetBundleExportJobSummary(BuilderImpl builder) {
        this.jobStatus = builder.jobStatus;
        this.arn = builder.arn;
        this.createdTime = builder.createdTime;
        this.assetBundleExportJobId = builder.assetBundleExportJobId;
        this.includeAllDependencies = builder.includeAllDependencies;
        this.exportFormat = builder.exportFormat;
        this.includePermissions = builder.includePermissions;
        this.includeTags = builder.includeTags;
    }

    public final AssetBundleExportJobStatus jobStatus() {
        return AssetBundleExportJobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String assetBundleExportJobId() {
        return this.assetBundleExportJobId;
    }

    public final Boolean includeAllDependencies() {
        return this.includeAllDependencies;
    }

    public final AssetBundleExportFormat exportFormat() {
        return AssetBundleExportFormat.fromValue(this.exportFormat);
    }

    public final String exportFormatAsString() {
        return this.exportFormat;
    }

    public final Boolean includePermissions() {
        return this.includePermissions;
    }

    public final Boolean includeTags() {
        return this.includeTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetBundleExportJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeAllDependencies());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.includePermissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeTags());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleExportJobSummary)) {
            return false;
        }
        AssetBundleExportJobSummary other = (AssetBundleExportJobSummary)obj;
        return Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.assetBundleExportJobId(), other.assetBundleExportJobId()) && Objects.equals(this.includeAllDependencies(), other.includeAllDependencies()) && Objects.equals(this.exportFormatAsString(), other.exportFormatAsString()) && Objects.equals(this.includePermissions(), other.includePermissions()) && Objects.equals(this.includeTags(), other.includeTags());
    }

    public final String toString() {
        return ToString.builder((String)"AssetBundleExportJobSummary").add("JobStatus", (Object)this.jobStatusAsString()).add("Arn", (Object)this.arn()).add("CreatedTime", (Object)this.createdTime()).add("AssetBundleExportJobId", (Object)this.assetBundleExportJobId()).add("IncludeAllDependencies", (Object)this.includeAllDependencies()).add("ExportFormat", (Object)this.exportFormatAsString()).add("IncludePermissions", (Object)this.includePermissions()).add("IncludeTags", (Object)this.includeTags()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "AssetBundleExportJobId": {
                return Optional.ofNullable(clazz.cast(this.assetBundleExportJobId()));
            }
            case "IncludeAllDependencies": {
                return Optional.ofNullable(clazz.cast(this.includeAllDependencies()));
            }
            case "ExportFormat": {
                return Optional.ofNullable(clazz.cast(this.exportFormatAsString()));
            }
            case "IncludePermissions": {
                return Optional.ofNullable(clazz.cast(this.includePermissions()));
            }
            case "IncludeTags": {
                return Optional.ofNullable(clazz.cast(this.includeTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleExportJobSummary, T> g) {
        return obj -> g.apply((AssetBundleExportJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobStatus;
        private String arn;
        private Instant createdTime;
        private String assetBundleExportJobId;
        private Boolean includeAllDependencies;
        private String exportFormat;
        private Boolean includePermissions;
        private Boolean includeTags;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleExportJobSummary model) {
            this.jobStatus(model.jobStatus);
            this.arn(model.arn);
            this.createdTime(model.createdTime);
            this.assetBundleExportJobId(model.assetBundleExportJobId);
            this.includeAllDependencies(model.includeAllDependencies);
            this.exportFormat(model.exportFormat);
            this.includePermissions(model.includePermissions);
            this.includeTags(model.includeTags);
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(AssetBundleExportJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getAssetBundleExportJobId() {
            return this.assetBundleExportJobId;
        }

        public final void setAssetBundleExportJobId(String assetBundleExportJobId) {
            this.assetBundleExportJobId = assetBundleExportJobId;
        }

        @Override
        public final Builder assetBundleExportJobId(String assetBundleExportJobId) {
            this.assetBundleExportJobId = assetBundleExportJobId;
            return this;
        }

        public final Boolean getIncludeAllDependencies() {
            return this.includeAllDependencies;
        }

        public final void setIncludeAllDependencies(Boolean includeAllDependencies) {
            this.includeAllDependencies = includeAllDependencies;
        }

        @Override
        public final Builder includeAllDependencies(Boolean includeAllDependencies) {
            this.includeAllDependencies = includeAllDependencies;
            return this;
        }

        public final String getExportFormat() {
            return this.exportFormat;
        }

        public final void setExportFormat(String exportFormat) {
            this.exportFormat = exportFormat;
        }

        @Override
        public final Builder exportFormat(String exportFormat) {
            this.exportFormat = exportFormat;
            return this;
        }

        @Override
        public final Builder exportFormat(AssetBundleExportFormat exportFormat) {
            this.exportFormat(exportFormat == null ? null : exportFormat.toString());
            return this;
        }

        public final Boolean getIncludePermissions() {
            return this.includePermissions;
        }

        public final void setIncludePermissions(Boolean includePermissions) {
            this.includePermissions = includePermissions;
        }

        @Override
        public final Builder includePermissions(Boolean includePermissions) {
            this.includePermissions = includePermissions;
            return this;
        }

        public final Boolean getIncludeTags() {
            return this.includeTags;
        }

        public final void setIncludeTags(Boolean includeTags) {
            this.includeTags = includeTags;
        }

        @Override
        public final Builder includeTags(Boolean includeTags) {
            this.includeTags = includeTags;
            return this;
        }

        public AssetBundleExportJobSummary build() {
            return new AssetBundleExportJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetBundleExportJobSummary> {
        public Builder jobStatus(String var1);

        public Builder jobStatus(AssetBundleExportJobStatus var1);

        public Builder arn(String var1);

        public Builder createdTime(Instant var1);

        public Builder assetBundleExportJobId(String var1);

        public Builder includeAllDependencies(Boolean var1);

        public Builder exportFormat(String var1);

        public Builder exportFormat(AssetBundleExportFormat var1);

        public Builder includePermissions(Boolean var1);

        public Builder includeTags(Boolean var1);
    }
}

