/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.ColumnIdentifier;
import software.amazon.awssdk.services.quicksight.model.ParameterSelectableValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParameterSelectableValues
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParameterSelectableValues> {
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Values").getter(ParameterSelectableValues.getter(ParameterSelectableValues::values)).setter(ParameterSelectableValues.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ColumnIdentifier> LINK_TO_DATA_SET_COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LinkToDataSetColumn").getter(ParameterSelectableValues.getter(ParameterSelectableValues::linkToDataSetColumn)).setter(ParameterSelectableValues.setter(Builder::linkToDataSetColumn)).constructor(ColumnIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkToDataSetColumn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUES_FIELD, LINK_TO_DATA_SET_COLUMN_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> values;
    private final ColumnIdentifier linkToDataSetColumn;

    private ParameterSelectableValues(BuilderImpl builder) {
        this.values = builder.values;
        this.linkToDataSetColumn = builder.linkToDataSetColumn;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<String> values() {
        return this.values;
    }

    public final ColumnIdentifier linkToDataSetColumn() {
        return this.linkToDataSetColumn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.linkToDataSetColumn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterSelectableValues)) {
            return false;
        }
        ParameterSelectableValues other = (ParameterSelectableValues)obj;
        return this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values()) && Objects.equals(this.linkToDataSetColumn(), other.linkToDataSetColumn());
    }

    public final String toString() {
        return ToString.builder((String)"ParameterSelectableValues").add("Values", this.hasValues() ? this.values() : null).add("LinkToDataSetColumn", (Object)this.linkToDataSetColumn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
            case "LinkToDataSetColumn": {
                return Optional.ofNullable(clazz.cast(this.linkToDataSetColumn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterSelectableValues, T> g) {
        return obj -> g.apply((ParameterSelectableValues)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> values = DefaultSdkAutoConstructList.getInstance();
        private ColumnIdentifier linkToDataSetColumn;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterSelectableValues model) {
            this.values(model.values);
            this.linkToDataSetColumn(model.linkToDataSetColumn);
        }

        public final Collection<String> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        public final void setValues(Collection<String> values) {
            this.values = ParameterSelectableValueListCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ParameterSelectableValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final ColumnIdentifier.Builder getLinkToDataSetColumn() {
            return this.linkToDataSetColumn != null ? this.linkToDataSetColumn.toBuilder() : null;
        }

        public final void setLinkToDataSetColumn(ColumnIdentifier.BuilderImpl linkToDataSetColumn) {
            this.linkToDataSetColumn = linkToDataSetColumn != null ? linkToDataSetColumn.build() : null;
        }

        @Override
        public final Builder linkToDataSetColumn(ColumnIdentifier linkToDataSetColumn) {
            this.linkToDataSetColumn = linkToDataSetColumn;
            return this;
        }

        public ParameterSelectableValues build() {
            return new ParameterSelectableValues(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParameterSelectableValues> {
        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);

        public Builder linkToDataSetColumn(ColumnIdentifier var1);

        default public Builder linkToDataSetColumn(Consumer<ColumnIdentifier.Builder> linkToDataSetColumn) {
            return this.linkToDataSetColumn((ColumnIdentifier)((ColumnIdentifier.Builder)ColumnIdentifier.builder().applyMutation(linkToDataSetColumn)).build());
        }
    }
}

