/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AnchorOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnchorDateConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnchorDateConfiguration> {
    private static final SdkField<String> ANCHOR_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnchorOption").getter(AnchorDateConfiguration.getter(AnchorDateConfiguration::anchorOptionAsString)).setter(AnchorDateConfiguration.setter(Builder::anchorOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnchorOption").build()}).build();
    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterName").getter(AnchorDateConfiguration.getter(AnchorDateConfiguration::parameterName)).setter(AnchorDateConfiguration.setter(Builder::parameterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANCHOR_OPTION_FIELD, PARAMETER_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String anchorOption;
    private final String parameterName;

    private AnchorDateConfiguration(BuilderImpl builder) {
        this.anchorOption = builder.anchorOption;
        this.parameterName = builder.parameterName;
    }

    public final AnchorOption anchorOption() {
        return AnchorOption.fromValue(this.anchorOption);
    }

    public final String anchorOptionAsString() {
        return this.anchorOption;
    }

    public final String parameterName() {
        return this.parameterName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.anchorOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnchorDateConfiguration)) {
            return false;
        }
        AnchorDateConfiguration other = (AnchorDateConfiguration)obj;
        return Objects.equals(this.anchorOptionAsString(), other.anchorOptionAsString()) && Objects.equals(this.parameterName(), other.parameterName());
    }

    public final String toString() {
        return ToString.builder((String)"AnchorDateConfiguration").add("AnchorOption", (Object)this.anchorOptionAsString()).add("ParameterName", (Object)this.parameterName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnchorOption": {
                return Optional.ofNullable(clazz.cast(this.anchorOptionAsString()));
            }
            case "ParameterName": {
                return Optional.ofNullable(clazz.cast(this.parameterName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnchorDateConfiguration, T> g) {
        return obj -> g.apply((AnchorDateConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String anchorOption;
        private String parameterName;

        private BuilderImpl() {
        }

        private BuilderImpl(AnchorDateConfiguration model) {
            this.anchorOption(model.anchorOption);
            this.parameterName(model.parameterName);
        }

        public final String getAnchorOption() {
            return this.anchorOption;
        }

        public final void setAnchorOption(String anchorOption) {
            this.anchorOption = anchorOption;
        }

        @Override
        public final Builder anchorOption(String anchorOption) {
            this.anchorOption = anchorOption;
            return this;
        }

        @Override
        public final Builder anchorOption(AnchorOption anchorOption) {
            this.anchorOption(anchorOption == null ? null : anchorOption.toString());
            return this;
        }

        public final String getParameterName() {
            return this.parameterName;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public AnchorDateConfiguration build() {
            return new AnchorDateConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnchorDateConfiguration> {
        public Builder anchorOption(String var1);

        public Builder anchorOption(AnchorOption var1);

        public Builder parameterName(String var1);
    }
}

