/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTemplateRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdateTemplateRequest.Builder, UpdateTemplateRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(UpdateTemplateRequest::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateId").getter(getter(UpdateTemplateRequest::templateId)).setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TemplateId").build()).build();

    private static final SdkField<TemplateSourceEntity> SOURCE_ENTITY_FIELD = SdkField
            .<TemplateSourceEntity> builder(MarshallingType.SDK_POJO).memberName("SourceEntity")
            .getter(getter(UpdateTemplateRequest::sourceEntity)).setter(setter(Builder::sourceEntity))
            .constructor(TemplateSourceEntity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEntity").build()).build();

    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionDescription").getter(getter(UpdateTemplateRequest::versionDescription))
            .setter(setter(Builder::versionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateTemplateRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<TemplateVersionDefinition> DEFINITION_FIELD = SdkField
            .<TemplateVersionDefinition> builder(MarshallingType.SDK_POJO).memberName("Definition")
            .getter(getter(UpdateTemplateRequest::definition)).setter(setter(Builder::definition))
            .constructor(TemplateVersionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            TEMPLATE_ID_FIELD, SOURCE_ENTITY_FIELD, VERSION_DESCRIPTION_FIELD, NAME_FIELD, DEFINITION_FIELD));

    private final String awsAccountId;

    private final String templateId;

    private final TemplateSourceEntity sourceEntity;

    private final String versionDescription;

    private final String name;

    private final TemplateVersionDefinition definition;

    private UpdateTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.templateId = builder.templateId;
        this.sourceEntity = builder.sourceEntity;
        this.versionDescription = builder.versionDescription;
        this.name = builder.name;
        this.definition = builder.definition;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that contains the template that you're updating.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that contains the template that you're updating.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID for the template.
     * </p>
     * 
     * @return The ID for the template.
     */
    public final String templateId() {
        return templateId;
    }

    /**
     * <p>
     * The entity that you are using as a source when you update the template. In <code>SourceEntity</code>, you specify
     * the type of object you're using as source: <code>SourceTemplate</code> for a template or
     * <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For
     * <code>SourceTemplate</code>, specify the ARN of the source template. For <code>SourceAnalysis</code>, specify the
     * ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services account and
     * any Amazon QuickSight-supported Amazon Web Services Region;.
     * </p>
     * <p>
     * Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or <code>SourceAnalysis</code>
     * to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must
     * match its placeholder.
     * </p>
     * 
     * @return The entity that you are using as a source when you update the template. In <code>SourceEntity</code>, you
     *         specify the type of object you're using as source: <code>SourceTemplate</code> for a template or
     *         <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For
     *         <code>SourceTemplate</code>, specify the ARN of the source template. For <code>SourceAnalysis</code>,
     *         specify the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any Amazon Web
     *         Services account and any Amazon QuickSight-supported Amazon Web Services Region;. </p>
     *         <p>
     *         Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or
     *         <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the original.
     *         The schema in each dataset must match its placeholder.
     */
    public final TemplateSourceEntity sourceEntity() {
        return sourceEntity;
    }

    /**
     * <p>
     * A description of the current template version that is being updated. Every time you call
     * <code>UpdateTemplate</code>, you create a new version of the template. Each version of the template maintains a
     * description of the version in the <code>VersionDescription</code> field.
     * </p>
     * 
     * @return A description of the current template version that is being updated. Every time you call
     *         <code>UpdateTemplate</code>, you create a new version of the template. Each version of the template
     *         maintains a description of the version in the <code>VersionDescription</code> field.
     */
    public final String versionDescription() {
        return versionDescription;
    }

    /**
     * <p>
     * The name for the template.
     * </p>
     * 
     * @return The name for the template.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The definition of a template.
     * </p>
     * <p>
     * A definition is the data model of all features in a Dashboard, Template, or Analysis.
     * </p>
     * 
     * @return The definition of a template.</p>
     *         <p>
     *         A definition is the data model of all features in a Dashboard, Template, or Analysis.
     */
    public final TemplateVersionDefinition definition() {
        return definition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceEntity());
        hashCode = 31 * hashCode + Objects.hashCode(versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTemplateRequest)) {
            return false;
        }
        UpdateTemplateRequest other = (UpdateTemplateRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(templateId(), other.templateId())
                && Objects.equals(sourceEntity(), other.sourceEntity())
                && Objects.equals(versionDescription(), other.versionDescription()) && Objects.equals(name(), other.name())
                && Objects.equals(definition(), other.definition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTemplateRequest").add("AwsAccountId", awsAccountId()).add("TemplateId", templateId())
                .add("SourceEntity", sourceEntity()).add("VersionDescription", versionDescription()).add("Name", name())
                .add("Definition", definition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "TemplateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        case "SourceEntity":
            return Optional.ofNullable(clazz.cast(sourceEntity()));
        case "VersionDescription":
            return Optional.ofNullable(clazz.cast(versionDescription()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Definition":
            return Optional.ofNullable(clazz.cast(definition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTemplateRequest, T> g) {
        return obj -> g.apply((UpdateTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTemplateRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that contains the template that you're updating.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account that contains the template that you're updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID for the template.
         * </p>
         * 
         * @param templateId
         *        The ID for the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        /**
         * <p>
         * The entity that you are using as a source when you update the template. In <code>SourceEntity</code>, you
         * specify the type of object you're using as source: <code>SourceTemplate</code> for a template or
         * <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For
         * <code>SourceTemplate</code>, specify the ARN of the source template. For <code>SourceAnalysis</code>, specify
         * the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services
         * account and any Amazon QuickSight-supported Amazon Web Services Region;.
         * </p>
         * <p>
         * Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or
         * <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the original. The
         * schema in each dataset must match its placeholder.
         * </p>
         * 
         * @param sourceEntity
         *        The entity that you are using as a source when you update the template. In <code>SourceEntity</code>,
         *        you specify the type of object you're using as source: <code>SourceTemplate</code> for a template or
         *        <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For
         *        <code>SourceTemplate</code>, specify the ARN of the source template. For <code>SourceAnalysis</code>,
         *        specify the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any Amazon Web
         *        Services account and any Amazon QuickSight-supported Amazon Web Services Region;. </p>
         *        <p>
         *        Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or
         *        <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the
         *        original. The schema in each dataset must match its placeholder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEntity(TemplateSourceEntity sourceEntity);

        /**
         * <p>
         * The entity that you are using as a source when you update the template. In <code>SourceEntity</code>, you
         * specify the type of object you're using as source: <code>SourceTemplate</code> for a template or
         * <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For
         * <code>SourceTemplate</code>, specify the ARN of the source template. For <code>SourceAnalysis</code>, specify
         * the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services
         * account and any Amazon QuickSight-supported Amazon Web Services Region;.
         * </p>
         * <p>
         * Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or
         * <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the original. The
         * schema in each dataset must match its placeholder.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemplateSourceEntity.Builder} avoiding
         * the need to create one manually via {@link TemplateSourceEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemplateSourceEntity.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceEntity(TemplateSourceEntity)}.
         * 
         * @param sourceEntity
         *        a consumer that will call methods on {@link TemplateSourceEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceEntity(TemplateSourceEntity)
         */
        default Builder sourceEntity(Consumer<TemplateSourceEntity.Builder> sourceEntity) {
            return sourceEntity(TemplateSourceEntity.builder().applyMutation(sourceEntity).build());
        }

        /**
         * <p>
         * A description of the current template version that is being updated. Every time you call
         * <code>UpdateTemplate</code>, you create a new version of the template. Each version of the template maintains
         * a description of the version in the <code>VersionDescription</code> field.
         * </p>
         * 
         * @param versionDescription
         *        A description of the current template version that is being updated. Every time you call
         *        <code>UpdateTemplate</code>, you create a new version of the template. Each version of the template
         *        maintains a description of the version in the <code>VersionDescription</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionDescription(String versionDescription);

        /**
         * <p>
         * The name for the template.
         * </p>
         * 
         * @param name
         *        The name for the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The definition of a template.
         * </p>
         * <p>
         * A definition is the data model of all features in a Dashboard, Template, or Analysis.
         * </p>
         * 
         * @param definition
         *        The definition of a template.</p>
         *        <p>
         *        A definition is the data model of all features in a Dashboard, Template, or Analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(TemplateVersionDefinition definition);

        /**
         * <p>
         * The definition of a template.
         * </p>
         * <p>
         * A definition is the data model of all features in a Dashboard, Template, or Analysis.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemplateVersionDefinition.Builder}
         * avoiding the need to create one manually via {@link TemplateVersionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemplateVersionDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #definition(TemplateVersionDefinition)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link TemplateVersionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(TemplateVersionDefinition)
         */
        default Builder definition(Consumer<TemplateVersionDefinition.Builder> definition) {
            return definition(TemplateVersionDefinition.builder().applyMutation(definition).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String templateId;

        private TemplateSourceEntity sourceEntity;

        private String versionDescription;

        private String name;

        private TemplateVersionDefinition definition;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTemplateRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            templateId(model.templateId);
            sourceEntity(model.sourceEntity);
            versionDescription(model.versionDescription);
            name(model.name);
            definition(model.definition);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getTemplateId() {
            return templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final TemplateSourceEntity.Builder getSourceEntity() {
            return sourceEntity != null ? sourceEntity.toBuilder() : null;
        }

        public final void setSourceEntity(TemplateSourceEntity.BuilderImpl sourceEntity) {
            this.sourceEntity = sourceEntity != null ? sourceEntity.build() : null;
        }

        @Override
        public final Builder sourceEntity(TemplateSourceEntity sourceEntity) {
            this.sourceEntity = sourceEntity;
            return this;
        }

        public final String getVersionDescription() {
            return versionDescription;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final TemplateVersionDefinition.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(TemplateVersionDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(TemplateVersionDefinition definition) {
            this.definition = definition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTemplateRequest build() {
            return new UpdateTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
