/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that represents a relative date filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicRelativeDateFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicRelativeDateFilter.Builder, TopicRelativeDateFilter> {
    private static final SdkField<String> TIME_GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeGranularity").getter(getter(TopicRelativeDateFilter::timeGranularityAsString))
            .setter(setter(Builder::timeGranularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeGranularity").build()).build();

    private static final SdkField<String> RELATIVE_DATE_FILTER_FUNCTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RelativeDateFilterFunction")
            .getter(getter(TopicRelativeDateFilter::relativeDateFilterFunctionAsString))
            .setter(setter(Builder::relativeDateFilterFunction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelativeDateFilterFunction").build())
            .build();

    private static final SdkField<TopicSingularFilterConstant> CONSTANT_FIELD = SdkField
            .<TopicSingularFilterConstant> builder(MarshallingType.SDK_POJO).memberName("Constant")
            .getter(getter(TopicRelativeDateFilter::constant)).setter(setter(Builder::constant))
            .constructor(TopicSingularFilterConstant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Constant").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_GRANULARITY_FIELD,
            RELATIVE_DATE_FILTER_FUNCTION_FIELD, CONSTANT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String timeGranularity;

    private final String relativeDateFilterFunction;

    private final TopicSingularFilterConstant constant;

    private TopicRelativeDateFilter(BuilderImpl builder) {
        this.timeGranularity = builder.timeGranularity;
        this.relativeDateFilterFunction = builder.relativeDateFilterFunction;
        this.constant = builder.constant;
    }

    /**
     * <p>
     * The level of time precision that is used to aggregate <code>DateTime</code> values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeGranularity}
     * will return {@link TopicTimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #timeGranularityAsString}.
     * </p>
     * 
     * @return The level of time precision that is used to aggregate <code>DateTime</code> values.
     * @see TopicTimeGranularity
     */
    public final TopicTimeGranularity timeGranularity() {
        return TopicTimeGranularity.fromValue(timeGranularity);
    }

    /**
     * <p>
     * The level of time precision that is used to aggregate <code>DateTime</code> values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeGranularity}
     * will return {@link TopicTimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #timeGranularityAsString}.
     * </p>
     * 
     * @return The level of time precision that is used to aggregate <code>DateTime</code> values.
     * @see TopicTimeGranularity
     */
    public final String timeGranularityAsString() {
        return timeGranularity;
    }

    /**
     * <p>
     * The function to be used in a relative date filter to determine the range of dates to include in the results.
     * Valid values for this structure are <code>BEFORE</code>, <code>AFTER</code>, and <code>BETWEEN</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #relativeDateFilterFunction} will return {@link TopicRelativeDateFilterFunction#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #relativeDateFilterFunctionAsString}.
     * </p>
     * 
     * @return The function to be used in a relative date filter to determine the range of dates to include in the
     *         results. Valid values for this structure are <code>BEFORE</code>, <code>AFTER</code>, and
     *         <code>BETWEEN</code>.
     * @see TopicRelativeDateFilterFunction
     */
    public final TopicRelativeDateFilterFunction relativeDateFilterFunction() {
        return TopicRelativeDateFilterFunction.fromValue(relativeDateFilterFunction);
    }

    /**
     * <p>
     * The function to be used in a relative date filter to determine the range of dates to include in the results.
     * Valid values for this structure are <code>BEFORE</code>, <code>AFTER</code>, and <code>BETWEEN</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #relativeDateFilterFunction} will return {@link TopicRelativeDateFilterFunction#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #relativeDateFilterFunctionAsString}.
     * </p>
     * 
     * @return The function to be used in a relative date filter to determine the range of dates to include in the
     *         results. Valid values for this structure are <code>BEFORE</code>, <code>AFTER</code>, and
     *         <code>BETWEEN</code>.
     * @see TopicRelativeDateFilterFunction
     */
    public final String relativeDateFilterFunctionAsString() {
        return relativeDateFilterFunction;
    }

    /**
     * <p>
     * The constant used in a relative date filter.
     * </p>
     * 
     * @return The constant used in a relative date filter.
     */
    public final TopicSingularFilterConstant constant() {
        return constant;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeGranularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(relativeDateFilterFunctionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(constant());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRelativeDateFilter)) {
            return false;
        }
        TopicRelativeDateFilter other = (TopicRelativeDateFilter) obj;
        return Objects.equals(timeGranularityAsString(), other.timeGranularityAsString())
                && Objects.equals(relativeDateFilterFunctionAsString(), other.relativeDateFilterFunctionAsString())
                && Objects.equals(constant(), other.constant());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicRelativeDateFilter").add("TimeGranularity", timeGranularityAsString())
                .add("RelativeDateFilterFunction", relativeDateFilterFunctionAsString())
                .add("Constant", constant() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeGranularity":
            return Optional.ofNullable(clazz.cast(timeGranularityAsString()));
        case "RelativeDateFilterFunction":
            return Optional.ofNullable(clazz.cast(relativeDateFilterFunctionAsString()));
        case "Constant":
            return Optional.ofNullable(clazz.cast(constant()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicRelativeDateFilter, T> g) {
        return obj -> g.apply((TopicRelativeDateFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicRelativeDateFilter> {
        /**
         * <p>
         * The level of time precision that is used to aggregate <code>DateTime</code> values.
         * </p>
         * 
         * @param timeGranularity
         *        The level of time precision that is used to aggregate <code>DateTime</code> values.
         * @see TopicTimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicTimeGranularity
         */
        Builder timeGranularity(String timeGranularity);

        /**
         * <p>
         * The level of time precision that is used to aggregate <code>DateTime</code> values.
         * </p>
         * 
         * @param timeGranularity
         *        The level of time precision that is used to aggregate <code>DateTime</code> values.
         * @see TopicTimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicTimeGranularity
         */
        Builder timeGranularity(TopicTimeGranularity timeGranularity);

        /**
         * <p>
         * The function to be used in a relative date filter to determine the range of dates to include in the results.
         * Valid values for this structure are <code>BEFORE</code>, <code>AFTER</code>, and <code>BETWEEN</code>.
         * </p>
         * 
         * @param relativeDateFilterFunction
         *        The function to be used in a relative date filter to determine the range of dates to include in the
         *        results. Valid values for this structure are <code>BEFORE</code>, <code>AFTER</code>, and
         *        <code>BETWEEN</code>.
         * @see TopicRelativeDateFilterFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicRelativeDateFilterFunction
         */
        Builder relativeDateFilterFunction(String relativeDateFilterFunction);

        /**
         * <p>
         * The function to be used in a relative date filter to determine the range of dates to include in the results.
         * Valid values for this structure are <code>BEFORE</code>, <code>AFTER</code>, and <code>BETWEEN</code>.
         * </p>
         * 
         * @param relativeDateFilterFunction
         *        The function to be used in a relative date filter to determine the range of dates to include in the
         *        results. Valid values for this structure are <code>BEFORE</code>, <code>AFTER</code>, and
         *        <code>BETWEEN</code>.
         * @see TopicRelativeDateFilterFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicRelativeDateFilterFunction
         */
        Builder relativeDateFilterFunction(TopicRelativeDateFilterFunction relativeDateFilterFunction);

        /**
         * <p>
         * The constant used in a relative date filter.
         * </p>
         * 
         * @param constant
         *        The constant used in a relative date filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constant(TopicSingularFilterConstant constant);

        /**
         * <p>
         * The constant used in a relative date filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicSingularFilterConstant.Builder}
         * avoiding the need to create one manually via {@link TopicSingularFilterConstant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicSingularFilterConstant.Builder#build()} is called
         * immediately and its result is passed to {@link #constant(TopicSingularFilterConstant)}.
         * 
         * @param constant
         *        a consumer that will call methods on {@link TopicSingularFilterConstant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #constant(TopicSingularFilterConstant)
         */
        default Builder constant(Consumer<TopicSingularFilterConstant.Builder> constant) {
            return constant(TopicSingularFilterConstant.builder().applyMutation(constant).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String timeGranularity;

        private String relativeDateFilterFunction;

        private TopicSingularFilterConstant constant;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRelativeDateFilter model) {
            timeGranularity(model.timeGranularity);
            relativeDateFilterFunction(model.relativeDateFilterFunction);
            constant(model.constant);
        }

        public final String getTimeGranularity() {
            return timeGranularity;
        }

        public final void setTimeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
        }

        @Override
        public final Builder timeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
            return this;
        }

        @Override
        public final Builder timeGranularity(TopicTimeGranularity timeGranularity) {
            this.timeGranularity(timeGranularity == null ? null : timeGranularity.toString());
            return this;
        }

        public final String getRelativeDateFilterFunction() {
            return relativeDateFilterFunction;
        }

        public final void setRelativeDateFilterFunction(String relativeDateFilterFunction) {
            this.relativeDateFilterFunction = relativeDateFilterFunction;
        }

        @Override
        public final Builder relativeDateFilterFunction(String relativeDateFilterFunction) {
            this.relativeDateFilterFunction = relativeDateFilterFunction;
            return this;
        }

        @Override
        public final Builder relativeDateFilterFunction(TopicRelativeDateFilterFunction relativeDateFilterFunction) {
            this.relativeDateFilterFunction(relativeDateFilterFunction == null ? null : relativeDateFilterFunction.toString());
            return this;
        }

        public final TopicSingularFilterConstant.Builder getConstant() {
            return constant != null ? constant.toBuilder() : null;
        }

        public final void setConstant(TopicSingularFilterConstant.BuilderImpl constant) {
            this.constant = constant != null ? constant.build() : null;
        }

        @Override
        public final Builder constant(TopicSingularFilterConstant constant) {
            this.constant = constant;
            return this;
        }

        @Override
        public TopicRelativeDateFilter build() {
            return new TopicRelativeDateFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
