/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartAssetBundleImportJobRequest extends QuickSightRequest implements
        ToCopyableBuilder<StartAssetBundleImportJobRequest.Builder, StartAssetBundleImportJobRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(StartAssetBundleImportJobRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> ASSET_BUNDLE_IMPORT_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssetBundleImportJobId").getter(getter(StartAssetBundleImportJobRequest::assetBundleImportJobId))
            .setter(setter(Builder::assetBundleImportJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetBundleImportJobId").build())
            .build();

    private static final SdkField<AssetBundleImportSource> ASSET_BUNDLE_IMPORT_SOURCE_FIELD = SdkField
            .<AssetBundleImportSource> builder(MarshallingType.SDK_POJO).memberName("AssetBundleImportSource")
            .getter(getter(StartAssetBundleImportJobRequest::assetBundleImportSource))
            .setter(setter(Builder::assetBundleImportSource)).constructor(AssetBundleImportSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetBundleImportSource").build())
            .build();

    private static final SdkField<AssetBundleImportJobOverrideParameters> OVERRIDE_PARAMETERS_FIELD = SdkField
            .<AssetBundleImportJobOverrideParameters> builder(MarshallingType.SDK_POJO).memberName("OverrideParameters")
            .getter(getter(StartAssetBundleImportJobRequest::overrideParameters)).setter(setter(Builder::overrideParameters))
            .constructor(AssetBundleImportJobOverrideParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideParameters").build())
            .build();

    private static final SdkField<String> FAILURE_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureAction").getter(getter(StartAssetBundleImportJobRequest::failureActionAsString))
            .setter(setter(Builder::failureAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            ASSET_BUNDLE_IMPORT_JOB_ID_FIELD, ASSET_BUNDLE_IMPORT_SOURCE_FIELD, OVERRIDE_PARAMETERS_FIELD, FAILURE_ACTION_FIELD));

    private final String awsAccountId;

    private final String assetBundleImportJobId;

    private final AssetBundleImportSource assetBundleImportSource;

    private final AssetBundleImportJobOverrideParameters overrideParameters;

    private final String failureAction;

    private StartAssetBundleImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.assetBundleImportJobId = builder.assetBundleImportJobId;
        this.assetBundleImportSource = builder.assetBundleImportSource;
        this.overrideParameters = builder.overrideParameters;
        this.failureAction = builder.failureAction;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account to import assets into.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account to import assets into.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID of the job. This ID is unique while the job is running. After the job is completed, you can reuse this ID
     * for another job.
     * </p>
     * 
     * @return The ID of the job. This ID is unique while the job is running. After the job is completed, you can reuse
     *         this ID for another job.
     */
    public final String assetBundleImportJobId() {
        return assetBundleImportJobId;
    }

    /**
     * <p>
     * The source of the asset bundle zip file that contains the data that you want to import.
     * </p>
     * 
     * @return The source of the asset bundle zip file that contains the data that you want to import.
     */
    public final AssetBundleImportSource assetBundleImportSource() {
        return assetBundleImportSource;
    }

    /**
     * <p>
     * Optional overrides to be applied to the resource configuration before import.
     * </p>
     * 
     * @return Optional overrides to be applied to the resource configuration before import.
     */
    public final AssetBundleImportJobOverrideParameters overrideParameters() {
        return overrideParameters;
    }

    /**
     * <p>
     * The failure action for the import job.
     * </p>
     * <p>
     * If you choose <code>ROLLBACK</code>, failed import jobs will attempt to undo any asset changes caused by the
     * failed job.
     * </p>
     * <p>
     * If you choose <code>DO_NOTHING</code>, failed import jobs will not attempt to roll back any asset changes caused
     * by the failed job, possibly keeping the Amazon QuickSight account in an inconsistent state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureAction}
     * will return {@link AssetBundleImportFailureAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #failureActionAsString}.
     * </p>
     * 
     * @return The failure action for the import job.</p>
     *         <p>
     *         If you choose <code>ROLLBACK</code>, failed import jobs will attempt to undo any asset changes caused by
     *         the failed job.
     *         </p>
     *         <p>
     *         If you choose <code>DO_NOTHING</code>, failed import jobs will not attempt to roll back any asset changes
     *         caused by the failed job, possibly keeping the Amazon QuickSight account in an inconsistent state.
     * @see AssetBundleImportFailureAction
     */
    public final AssetBundleImportFailureAction failureAction() {
        return AssetBundleImportFailureAction.fromValue(failureAction);
    }

    /**
     * <p>
     * The failure action for the import job.
     * </p>
     * <p>
     * If you choose <code>ROLLBACK</code>, failed import jobs will attempt to undo any asset changes caused by the
     * failed job.
     * </p>
     * <p>
     * If you choose <code>DO_NOTHING</code>, failed import jobs will not attempt to roll back any asset changes caused
     * by the failed job, possibly keeping the Amazon QuickSight account in an inconsistent state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureAction}
     * will return {@link AssetBundleImportFailureAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #failureActionAsString}.
     * </p>
     * 
     * @return The failure action for the import job.</p>
     *         <p>
     *         If you choose <code>ROLLBACK</code>, failed import jobs will attempt to undo any asset changes caused by
     *         the failed job.
     *         </p>
     *         <p>
     *         If you choose <code>DO_NOTHING</code>, failed import jobs will not attempt to roll back any asset changes
     *         caused by the failed job, possibly keeping the Amazon QuickSight account in an inconsistent state.
     * @see AssetBundleImportFailureAction
     */
    public final String failureActionAsString() {
        return failureAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(assetBundleImportJobId());
        hashCode = 31 * hashCode + Objects.hashCode(assetBundleImportSource());
        hashCode = 31 * hashCode + Objects.hashCode(overrideParameters());
        hashCode = 31 * hashCode + Objects.hashCode(failureActionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAssetBundleImportJobRequest)) {
            return false;
        }
        StartAssetBundleImportJobRequest other = (StartAssetBundleImportJobRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(assetBundleImportJobId(), other.assetBundleImportJobId())
                && Objects.equals(assetBundleImportSource(), other.assetBundleImportSource())
                && Objects.equals(overrideParameters(), other.overrideParameters())
                && Objects.equals(failureActionAsString(), other.failureActionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartAssetBundleImportJobRequest").add("AwsAccountId", awsAccountId())
                .add("AssetBundleImportJobId", assetBundleImportJobId())
                .add("AssetBundleImportSource", assetBundleImportSource()).add("OverrideParameters", overrideParameters())
                .add("FailureAction", failureActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "AssetBundleImportJobId":
            return Optional.ofNullable(clazz.cast(assetBundleImportJobId()));
        case "AssetBundleImportSource":
            return Optional.ofNullable(clazz.cast(assetBundleImportSource()));
        case "OverrideParameters":
            return Optional.ofNullable(clazz.cast(overrideParameters()));
        case "FailureAction":
            return Optional.ofNullable(clazz.cast(failureActionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartAssetBundleImportJobRequest, T> g) {
        return obj -> g.apply((StartAssetBundleImportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartAssetBundleImportJobRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account to import assets into.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account to import assets into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID of the job. This ID is unique while the job is running. After the job is completed, you can reuse this
         * ID for another job.
         * </p>
         * 
         * @param assetBundleImportJobId
         *        The ID of the job. This ID is unique while the job is running. After the job is completed, you can
         *        reuse this ID for another job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetBundleImportJobId(String assetBundleImportJobId);

        /**
         * <p>
         * The source of the asset bundle zip file that contains the data that you want to import.
         * </p>
         * 
         * @param assetBundleImportSource
         *        The source of the asset bundle zip file that contains the data that you want to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetBundleImportSource(AssetBundleImportSource assetBundleImportSource);

        /**
         * <p>
         * The source of the asset bundle zip file that contains the data that you want to import.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssetBundleImportSource.Builder} avoiding
         * the need to create one manually via {@link AssetBundleImportSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetBundleImportSource.Builder#build()} is called immediately
         * and its result is passed to {@link #assetBundleImportSource(AssetBundleImportSource)}.
         * 
         * @param assetBundleImportSource
         *        a consumer that will call methods on {@link AssetBundleImportSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetBundleImportSource(AssetBundleImportSource)
         */
        default Builder assetBundleImportSource(Consumer<AssetBundleImportSource.Builder> assetBundleImportSource) {
            return assetBundleImportSource(AssetBundleImportSource.builder().applyMutation(assetBundleImportSource).build());
        }

        /**
         * <p>
         * Optional overrides to be applied to the resource configuration before import.
         * </p>
         * 
         * @param overrideParameters
         *        Optional overrides to be applied to the resource configuration before import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideParameters(AssetBundleImportJobOverrideParameters overrideParameters);

        /**
         * <p>
         * Optional overrides to be applied to the resource configuration before import.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AssetBundleImportJobOverrideParameters.Builder} avoiding the need to create one manually via
         * {@link AssetBundleImportJobOverrideParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetBundleImportJobOverrideParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #overrideParameters(AssetBundleImportJobOverrideParameters)}.
         * 
         * @param overrideParameters
         *        a consumer that will call methods on {@link AssetBundleImportJobOverrideParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrideParameters(AssetBundleImportJobOverrideParameters)
         */
        default Builder overrideParameters(Consumer<AssetBundleImportJobOverrideParameters.Builder> overrideParameters) {
            return overrideParameters(AssetBundleImportJobOverrideParameters.builder().applyMutation(overrideParameters).build());
        }

        /**
         * <p>
         * The failure action for the import job.
         * </p>
         * <p>
         * If you choose <code>ROLLBACK</code>, failed import jobs will attempt to undo any asset changes caused by the
         * failed job.
         * </p>
         * <p>
         * If you choose <code>DO_NOTHING</code>, failed import jobs will not attempt to roll back any asset changes
         * caused by the failed job, possibly keeping the Amazon QuickSight account in an inconsistent state.
         * </p>
         * 
         * @param failureAction
         *        The failure action for the import job.</p>
         *        <p>
         *        If you choose <code>ROLLBACK</code>, failed import jobs will attempt to undo any asset changes caused
         *        by the failed job.
         *        </p>
         *        <p>
         *        If you choose <code>DO_NOTHING</code>, failed import jobs will not attempt to roll back any asset
         *        changes caused by the failed job, possibly keeping the Amazon QuickSight account in an inconsistent
         *        state.
         * @see AssetBundleImportFailureAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetBundleImportFailureAction
         */
        Builder failureAction(String failureAction);

        /**
         * <p>
         * The failure action for the import job.
         * </p>
         * <p>
         * If you choose <code>ROLLBACK</code>, failed import jobs will attempt to undo any asset changes caused by the
         * failed job.
         * </p>
         * <p>
         * If you choose <code>DO_NOTHING</code>, failed import jobs will not attempt to roll back any asset changes
         * caused by the failed job, possibly keeping the Amazon QuickSight account in an inconsistent state.
         * </p>
         * 
         * @param failureAction
         *        The failure action for the import job.</p>
         *        <p>
         *        If you choose <code>ROLLBACK</code>, failed import jobs will attempt to undo any asset changes caused
         *        by the failed job.
         *        </p>
         *        <p>
         *        If you choose <code>DO_NOTHING</code>, failed import jobs will not attempt to roll back any asset
         *        changes caused by the failed job, possibly keeping the Amazon QuickSight account in an inconsistent
         *        state.
         * @see AssetBundleImportFailureAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetBundleImportFailureAction
         */
        Builder failureAction(AssetBundleImportFailureAction failureAction);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String assetBundleImportJobId;

        private AssetBundleImportSource assetBundleImportSource;

        private AssetBundleImportJobOverrideParameters overrideParameters;

        private String failureAction;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAssetBundleImportJobRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            assetBundleImportJobId(model.assetBundleImportJobId);
            assetBundleImportSource(model.assetBundleImportSource);
            overrideParameters(model.overrideParameters);
            failureAction(model.failureAction);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAssetBundleImportJobId() {
            return assetBundleImportJobId;
        }

        public final void setAssetBundleImportJobId(String assetBundleImportJobId) {
            this.assetBundleImportJobId = assetBundleImportJobId;
        }

        @Override
        public final Builder assetBundleImportJobId(String assetBundleImportJobId) {
            this.assetBundleImportJobId = assetBundleImportJobId;
            return this;
        }

        public final AssetBundleImportSource.Builder getAssetBundleImportSource() {
            return assetBundleImportSource != null ? assetBundleImportSource.toBuilder() : null;
        }

        public final void setAssetBundleImportSource(AssetBundleImportSource.BuilderImpl assetBundleImportSource) {
            this.assetBundleImportSource = assetBundleImportSource != null ? assetBundleImportSource.build() : null;
        }

        @Override
        public final Builder assetBundleImportSource(AssetBundleImportSource assetBundleImportSource) {
            this.assetBundleImportSource = assetBundleImportSource;
            return this;
        }

        public final AssetBundleImportJobOverrideParameters.Builder getOverrideParameters() {
            return overrideParameters != null ? overrideParameters.toBuilder() : null;
        }

        public final void setOverrideParameters(AssetBundleImportJobOverrideParameters.BuilderImpl overrideParameters) {
            this.overrideParameters = overrideParameters != null ? overrideParameters.build() : null;
        }

        @Override
        public final Builder overrideParameters(AssetBundleImportJobOverrideParameters overrideParameters) {
            this.overrideParameters = overrideParameters;
            return this;
        }

        public final String getFailureAction() {
            return failureAction;
        }

        public final void setFailureAction(String failureAction) {
            this.failureAction = failureAction;
        }

        @Override
        public final Builder failureAction(String failureAction) {
            this.failureAction = failureAction;
            return this;
        }

        @Override
        public final Builder failureAction(AssetBundleImportFailureAction failureAction) {
            this.failureAction(failureAction == null ? null : failureAction.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAssetBundleImportJobRequest build() {
            return new StartAssetBundleImportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
