/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The tooltip item for the columns that are not part of a field well.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColumnTooltipItem implements SdkPojo, Serializable,
        ToCopyableBuilder<ColumnTooltipItem.Builder, ColumnTooltipItem> {
    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.<ColumnIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("Column").getter(getter(ColumnTooltipItem::column)).setter(setter(Builder::column))
            .constructor(ColumnIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Label")
            .getter(getter(ColumnTooltipItem::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(ColumnTooltipItem::visibilityAsString)).setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final SdkField<AggregationFunction> AGGREGATION_FIELD = SdkField
            .<AggregationFunction> builder(MarshallingType.SDK_POJO).memberName("Aggregation")
            .getter(getter(ColumnTooltipItem::aggregation)).setter(setter(Builder::aggregation))
            .constructor(AggregationFunction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_FIELD, LABEL_FIELD,
            VISIBILITY_FIELD, AGGREGATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final ColumnIdentifier column;

    private final String label;

    private final String visibility;

    private final AggregationFunction aggregation;

    private ColumnTooltipItem(BuilderImpl builder) {
        this.column = builder.column;
        this.label = builder.label;
        this.visibility = builder.visibility;
        this.aggregation = builder.aggregation;
    }

    /**
     * <p>
     * The target column of the tooltip item.
     * </p>
     * 
     * @return The target column of the tooltip item.
     */
    public final ColumnIdentifier column() {
        return column;
    }

    /**
     * <p>
     * The label of the tooltip item.
     * </p>
     * 
     * @return The label of the tooltip item.
     */
    public final String label() {
        return label;
    }

    /**
     * <p>
     * The visibility of the tooltip item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of the tooltip item.
     * @see Visibility
     */
    public final Visibility visibility() {
        return Visibility.fromValue(visibility);
    }

    /**
     * <p>
     * The visibility of the tooltip item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of the tooltip item.
     * @see Visibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    /**
     * <p>
     * The aggregation function of the column tooltip item.
     * </p>
     * 
     * @return The aggregation function of the column tooltip item.
     */
    public final AggregationFunction aggregation() {
        return aggregation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(column());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(aggregation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnTooltipItem)) {
            return false;
        }
        ColumnTooltipItem other = (ColumnTooltipItem) obj;
        return Objects.equals(column(), other.column()) && Objects.equals(label(), other.label())
                && Objects.equals(visibilityAsString(), other.visibilityAsString())
                && Objects.equals(aggregation(), other.aggregation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColumnTooltipItem").add("Column", column()).add("Label", label())
                .add("Visibility", visibilityAsString()).add("Aggregation", aggregation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Column":
            return Optional.ofNullable(clazz.cast(column()));
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        case "Aggregation":
            return Optional.ofNullable(clazz.cast(aggregation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ColumnTooltipItem, T> g) {
        return obj -> g.apply((ColumnTooltipItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColumnTooltipItem> {
        /**
         * <p>
         * The target column of the tooltip item.
         * </p>
         * 
         * @param column
         *        The target column of the tooltip item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder column(ColumnIdentifier column);

        /**
         * <p>
         * The target column of the tooltip item.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnIdentifier.Builder} avoiding the
         * need to create one manually via {@link ColumnIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #column(ColumnIdentifier)}.
         * 
         * @param column
         *        a consumer that will call methods on {@link ColumnIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #column(ColumnIdentifier)
         */
        default Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return column(ColumnIdentifier.builder().applyMutation(column).build());
        }

        /**
         * <p>
         * The label of the tooltip item.
         * </p>
         * 
         * @param label
         *        The label of the tooltip item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * The visibility of the tooltip item.
         * </p>
         * 
         * @param visibility
         *        The visibility of the tooltip item.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * The visibility of the tooltip item.
         * </p>
         * 
         * @param visibility
         *        The visibility of the tooltip item.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(Visibility visibility);

        /**
         * <p>
         * The aggregation function of the column tooltip item.
         * </p>
         * 
         * @param aggregation
         *        The aggregation function of the column tooltip item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregation(AggregationFunction aggregation);

        /**
         * <p>
         * The aggregation function of the column tooltip item.
         * </p>
         * This is a convenience method that creates an instance of the {@link AggregationFunction.Builder} avoiding the
         * need to create one manually via {@link AggregationFunction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AggregationFunction.Builder#build()} is called immediately and
         * its result is passed to {@link #aggregation(AggregationFunction)}.
         * 
         * @param aggregation
         *        a consumer that will call methods on {@link AggregationFunction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregation(AggregationFunction)
         */
        default Builder aggregation(Consumer<AggregationFunction.Builder> aggregation) {
            return aggregation(AggregationFunction.builder().applyMutation(aggregation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ColumnIdentifier column;

        private String label;

        private String visibility;

        private AggregationFunction aggregation;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnTooltipItem model) {
            column(model.column);
            label(model.label);
            visibility(model.visibility);
            aggregation(model.aggregation);
        }

        public final ColumnIdentifier.Builder getColumn() {
            return column != null ? column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final String getLabel() {
            return label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final AggregationFunction.Builder getAggregation() {
            return aggregation != null ? aggregation.toBuilder() : null;
        }

        public final void setAggregation(AggregationFunction.BuilderImpl aggregation) {
            this.aggregation = aggregation != null ? aggregation.build() : null;
        }

        @Override
        public final Builder aggregation(AggregationFunction aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        @Override
        public ColumnTooltipItem build() {
            return new ColumnTooltipItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
