/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRefreshSchedulesResponse extends QuickSightResponse implements
        ToCopyableBuilder<ListRefreshSchedulesResponse.Builder, ListRefreshSchedulesResponse> {
    private static final SdkField<List<RefreshSchedule>> REFRESH_SCHEDULES_FIELD = SdkField
            .<List<RefreshSchedule>> builder(MarshallingType.LIST)
            .memberName("RefreshSchedules")
            .getter(getter(ListRefreshSchedulesResponse::refreshSchedules))
            .setter(setter(Builder::refreshSchedules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshSchedules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RefreshSchedule> builder(MarshallingType.SDK_POJO)
                                            .constructor(RefreshSchedule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(ListRefreshSchedulesResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(ListRefreshSchedulesResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFRESH_SCHEDULES_FIELD,
            STATUS_FIELD, REQUEST_ID_FIELD));

    private final List<RefreshSchedule> refreshSchedules;

    private final Integer status;

    private final String requestId;

    private ListRefreshSchedulesResponse(BuilderImpl builder) {
        super(builder);
        this.refreshSchedules = builder.refreshSchedules;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    /**
     * For responses, this returns true if the service returned a value for the RefreshSchedules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRefreshSchedules() {
        return refreshSchedules != null && !(refreshSchedules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of refresh schedules for the dataset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRefreshSchedules} method.
     * </p>
     * 
     * @return The list of refresh schedules for the dataset.
     */
    public final List<RefreshSchedule> refreshSchedules() {
        return refreshSchedules;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRefreshSchedules() ? refreshSchedules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRefreshSchedulesResponse)) {
            return false;
        }
        ListRefreshSchedulesResponse other = (ListRefreshSchedulesResponse) obj;
        return hasRefreshSchedules() == other.hasRefreshSchedules()
                && Objects.equals(refreshSchedules(), other.refreshSchedules()) && Objects.equals(status(), other.status())
                && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRefreshSchedulesResponse")
                .add("RefreshSchedules", hasRefreshSchedules() ? refreshSchedules() : null).add("Status", status())
                .add("RequestId", requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RefreshSchedules":
            return Optional.ofNullable(clazz.cast(refreshSchedules()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRefreshSchedulesResponse, T> g) {
        return obj -> g.apply((ListRefreshSchedulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRefreshSchedulesResponse> {
        /**
         * <p>
         * The list of refresh schedules for the dataset.
         * </p>
         * 
         * @param refreshSchedules
         *        The list of refresh schedules for the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshSchedules(Collection<RefreshSchedule> refreshSchedules);

        /**
         * <p>
         * The list of refresh schedules for the dataset.
         * </p>
         * 
         * @param refreshSchedules
         *        The list of refresh schedules for the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshSchedules(RefreshSchedule... refreshSchedules);

        /**
         * <p>
         * The list of refresh schedules for the dataset.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.RefreshSchedule.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.RefreshSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.RefreshSchedule.Builder#build()} is called
         * immediately and its result is passed to {@link #refreshSchedules(List<RefreshSchedule>)}.
         * 
         * @param refreshSchedules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.RefreshSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #refreshSchedules(java.util.Collection<RefreshSchedule>)
         */
        Builder refreshSchedules(Consumer<RefreshSchedule.Builder>... refreshSchedules);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private List<RefreshSchedule> refreshSchedules = DefaultSdkAutoConstructList.getInstance();

        private Integer status;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRefreshSchedulesResponse model) {
            super(model);
            refreshSchedules(model.refreshSchedules);
            status(model.status);
            requestId(model.requestId);
        }

        public final List<RefreshSchedule.Builder> getRefreshSchedules() {
            List<RefreshSchedule.Builder> result = RefreshSchedulesCopier.copyToBuilder(this.refreshSchedules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRefreshSchedules(Collection<RefreshSchedule.BuilderImpl> refreshSchedules) {
            this.refreshSchedules = RefreshSchedulesCopier.copyFromBuilder(refreshSchedules);
        }

        @Override
        public final Builder refreshSchedules(Collection<RefreshSchedule> refreshSchedules) {
            this.refreshSchedules = RefreshSchedulesCopier.copy(refreshSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder refreshSchedules(RefreshSchedule... refreshSchedules) {
            refreshSchedules(Arrays.asList(refreshSchedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder refreshSchedules(Consumer<RefreshSchedule.Builder>... refreshSchedules) {
            refreshSchedules(Stream.of(refreshSchedules).map(c -> RefreshSchedule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public ListRefreshSchedulesResponse build() {
            return new ListRefreshSchedulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
