/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of destination parameter values.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationParameterValueConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationParameterValueConfiguration.Builder, DestinationParameterValueConfiguration> {
    private static final SdkField<CustomValuesConfiguration> CUSTOM_VALUES_CONFIGURATION_FIELD = SdkField
            .<CustomValuesConfiguration> builder(MarshallingType.SDK_POJO).memberName("CustomValuesConfiguration")
            .getter(getter(DestinationParameterValueConfiguration::customValuesConfiguration))
            .setter(setter(Builder::customValuesConfiguration)).constructor(CustomValuesConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomValuesConfiguration").build())
            .build();

    private static final SdkField<String> SELECT_ALL_VALUE_OPTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SelectAllValueOptions")
            .getter(getter(DestinationParameterValueConfiguration::selectAllValueOptionsAsString))
            .setter(setter(Builder::selectAllValueOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectAllValueOptions").build())
            .build();

    private static final SdkField<String> SOURCE_PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceParameterName").getter(getter(DestinationParameterValueConfiguration::sourceParameterName))
            .setter(setter(Builder::sourceParameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceParameterName").build())
            .build();

    private static final SdkField<String> SOURCE_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceField").getter(getter(DestinationParameterValueConfiguration::sourceField))
            .setter(setter(Builder::sourceField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceField").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CUSTOM_VALUES_CONFIGURATION_FIELD, SELECT_ALL_VALUE_OPTIONS_FIELD, SOURCE_PARAMETER_NAME_FIELD, SOURCE_FIELD_FIELD));

    private static final long serialVersionUID = 1L;

    private final CustomValuesConfiguration customValuesConfiguration;

    private final String selectAllValueOptions;

    private final String sourceParameterName;

    private final String sourceField;

    private DestinationParameterValueConfiguration(BuilderImpl builder) {
        this.customValuesConfiguration = builder.customValuesConfiguration;
        this.selectAllValueOptions = builder.selectAllValueOptions;
        this.sourceParameterName = builder.sourceParameterName;
        this.sourceField = builder.sourceField;
    }

    /**
     * <p>
     * The configuration of custom values for destination parameter in
     * <code>DestinationParameterValueConfiguration</code>.
     * </p>
     * 
     * @return The configuration of custom values for destination parameter in
     *         <code>DestinationParameterValueConfiguration</code>.
     */
    public final CustomValuesConfiguration customValuesConfiguration() {
        return customValuesConfiguration;
    }

    /**
     * <p>
     * The configuration that selects all options.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #selectAllValueOptions} will return {@link SelectAllValueOptions#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #selectAllValueOptionsAsString}.
     * </p>
     * 
     * @return The configuration that selects all options.
     * @see SelectAllValueOptions
     */
    public final SelectAllValueOptions selectAllValueOptions() {
        return SelectAllValueOptions.fromValue(selectAllValueOptions);
    }

    /**
     * <p>
     * The configuration that selects all options.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #selectAllValueOptions} will return {@link SelectAllValueOptions#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #selectAllValueOptionsAsString}.
     * </p>
     * 
     * @return The configuration that selects all options.
     * @see SelectAllValueOptions
     */
    public final String selectAllValueOptionsAsString() {
        return selectAllValueOptions;
    }

    /**
     * <p>
     * The source parameter name of the destination parameter.
     * </p>
     * 
     * @return The source parameter name of the destination parameter.
     */
    public final String sourceParameterName() {
        return sourceParameterName;
    }

    /**
     * <p>
     * The source field ID of the destination parameter.
     * </p>
     * 
     * @return The source field ID of the destination parameter.
     */
    public final String sourceField() {
        return sourceField;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customValuesConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(selectAllValueOptionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceField());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationParameterValueConfiguration)) {
            return false;
        }
        DestinationParameterValueConfiguration other = (DestinationParameterValueConfiguration) obj;
        return Objects.equals(customValuesConfiguration(), other.customValuesConfiguration())
                && Objects.equals(selectAllValueOptionsAsString(), other.selectAllValueOptionsAsString())
                && Objects.equals(sourceParameterName(), other.sourceParameterName())
                && Objects.equals(sourceField(), other.sourceField());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DestinationParameterValueConfiguration")
                .add("CustomValuesConfiguration", customValuesConfiguration())
                .add("SelectAllValueOptions", selectAllValueOptionsAsString()).add("SourceParameterName", sourceParameterName())
                .add("SourceField", sourceField()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomValuesConfiguration":
            return Optional.ofNullable(clazz.cast(customValuesConfiguration()));
        case "SelectAllValueOptions":
            return Optional.ofNullable(clazz.cast(selectAllValueOptionsAsString()));
        case "SourceParameterName":
            return Optional.ofNullable(clazz.cast(sourceParameterName()));
        case "SourceField":
            return Optional.ofNullable(clazz.cast(sourceField()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationParameterValueConfiguration, T> g) {
        return obj -> g.apply((DestinationParameterValueConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationParameterValueConfiguration> {
        /**
         * <p>
         * The configuration of custom values for destination parameter in
         * <code>DestinationParameterValueConfiguration</code>.
         * </p>
         * 
         * @param customValuesConfiguration
         *        The configuration of custom values for destination parameter in
         *        <code>DestinationParameterValueConfiguration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customValuesConfiguration(CustomValuesConfiguration customValuesConfiguration);

        /**
         * <p>
         * The configuration of custom values for destination parameter in
         * <code>DestinationParameterValueConfiguration</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomValuesConfiguration.Builder}
         * avoiding the need to create one manually via {@link CustomValuesConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomValuesConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #customValuesConfiguration(CustomValuesConfiguration)}.
         * 
         * @param customValuesConfiguration
         *        a consumer that will call methods on {@link CustomValuesConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customValuesConfiguration(CustomValuesConfiguration)
         */
        default Builder customValuesConfiguration(Consumer<CustomValuesConfiguration.Builder> customValuesConfiguration) {
            return customValuesConfiguration(CustomValuesConfiguration.builder().applyMutation(customValuesConfiguration).build());
        }

        /**
         * <p>
         * The configuration that selects all options.
         * </p>
         * 
         * @param selectAllValueOptions
         *        The configuration that selects all options.
         * @see SelectAllValueOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SelectAllValueOptions
         */
        Builder selectAllValueOptions(String selectAllValueOptions);

        /**
         * <p>
         * The configuration that selects all options.
         * </p>
         * 
         * @param selectAllValueOptions
         *        The configuration that selects all options.
         * @see SelectAllValueOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SelectAllValueOptions
         */
        Builder selectAllValueOptions(SelectAllValueOptions selectAllValueOptions);

        /**
         * <p>
         * The source parameter name of the destination parameter.
         * </p>
         * 
         * @param sourceParameterName
         *        The source parameter name of the destination parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceParameterName(String sourceParameterName);

        /**
         * <p>
         * The source field ID of the destination parameter.
         * </p>
         * 
         * @param sourceField
         *        The source field ID of the destination parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceField(String sourceField);
    }

    static final class BuilderImpl implements Builder {
        private CustomValuesConfiguration customValuesConfiguration;

        private String selectAllValueOptions;

        private String sourceParameterName;

        private String sourceField;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationParameterValueConfiguration model) {
            customValuesConfiguration(model.customValuesConfiguration);
            selectAllValueOptions(model.selectAllValueOptions);
            sourceParameterName(model.sourceParameterName);
            sourceField(model.sourceField);
        }

        public final CustomValuesConfiguration.Builder getCustomValuesConfiguration() {
            return customValuesConfiguration != null ? customValuesConfiguration.toBuilder() : null;
        }

        public final void setCustomValuesConfiguration(CustomValuesConfiguration.BuilderImpl customValuesConfiguration) {
            this.customValuesConfiguration = customValuesConfiguration != null ? customValuesConfiguration.build() : null;
        }

        @Override
        public final Builder customValuesConfiguration(CustomValuesConfiguration customValuesConfiguration) {
            this.customValuesConfiguration = customValuesConfiguration;
            return this;
        }

        public final String getSelectAllValueOptions() {
            return selectAllValueOptions;
        }

        public final void setSelectAllValueOptions(String selectAllValueOptions) {
            this.selectAllValueOptions = selectAllValueOptions;
        }

        @Override
        public final Builder selectAllValueOptions(String selectAllValueOptions) {
            this.selectAllValueOptions = selectAllValueOptions;
            return this;
        }

        @Override
        public final Builder selectAllValueOptions(SelectAllValueOptions selectAllValueOptions) {
            this.selectAllValueOptions(selectAllValueOptions == null ? null : selectAllValueOptions.toString());
            return this;
        }

        public final String getSourceParameterName() {
            return sourceParameterName;
        }

        public final void setSourceParameterName(String sourceParameterName) {
            this.sourceParameterName = sourceParameterName;
        }

        @Override
        public final Builder sourceParameterName(String sourceParameterName) {
            this.sourceParameterName = sourceParameterName;
            return this;
        }

        public final String getSourceField() {
            return sourceField;
        }

        public final void setSourceField(String sourceField) {
            this.sourceField = sourceField;
        }

        @Override
        public final Builder sourceField(String sourceField) {
            this.sourceField = sourceField;
            return this;
        }

        @Override
        public DestinationParameterValueConfiguration build() {
            return new DestinationParameterValueConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
