/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that represents a calculated field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicCalculatedField implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicCalculatedField.Builder, TopicCalculatedField> {
    private static final SdkField<String> CALCULATED_FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CalculatedFieldName").getter(getter(TopicCalculatedField::calculatedFieldName))
            .setter(setter(Builder::calculatedFieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedFieldName").build())
            .build();

    private static final SdkField<String> CALCULATED_FIELD_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CalculatedFieldDescription")
            .getter(getter(TopicCalculatedField::calculatedFieldDescription))
            .setter(setter(Builder::calculatedFieldDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedFieldDescription").build())
            .build();

    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Expression").getter(getter(TopicCalculatedField::expression)).setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()).build();

    private static final SdkField<List<String>> CALCULATED_FIELD_SYNONYMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CalculatedFieldSynonyms")
            .getter(getter(TopicCalculatedField::calculatedFieldSynonyms))
            .setter(setter(Builder::calculatedFieldSynonyms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedFieldSynonyms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_INCLUDED_IN_TOPIC_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsIncludedInTopic").getter(getter(TopicCalculatedField::isIncludedInTopic))
            .setter(setter(Builder::isIncludedInTopic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsIncludedInTopic").build()).build();

    private static final SdkField<Boolean> DISABLE_INDEXING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisableIndexing").getter(getter(TopicCalculatedField::disableIndexing))
            .setter(setter(Builder::disableIndexing))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableIndexing").build()).build();

    private static final SdkField<String> COLUMN_DATA_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnDataRole").getter(getter(TopicCalculatedField::columnDataRoleAsString))
            .setter(setter(Builder::columnDataRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnDataRole").build()).build();

    private static final SdkField<String> TIME_GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeGranularity").getter(getter(TopicCalculatedField::timeGranularityAsString))
            .setter(setter(Builder::timeGranularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeGranularity").build()).build();

    private static final SdkField<DefaultFormatting> DEFAULT_FORMATTING_FIELD = SdkField
            .<DefaultFormatting> builder(MarshallingType.SDK_POJO).memberName("DefaultFormatting")
            .getter(getter(TopicCalculatedField::defaultFormatting)).setter(setter(Builder::defaultFormatting))
            .constructor(DefaultFormatting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultFormatting").build()).build();

    private static final SdkField<String> AGGREGATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Aggregation").getter(getter(TopicCalculatedField::aggregationAsString))
            .setter(setter(Builder::aggregation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregation").build()).build();

    private static final SdkField<ComparativeOrder> COMPARATIVE_ORDER_FIELD = SdkField
            .<ComparativeOrder> builder(MarshallingType.SDK_POJO).memberName("ComparativeOrder")
            .getter(getter(TopicCalculatedField::comparativeOrder)).setter(setter(Builder::comparativeOrder))
            .constructor(ComparativeOrder::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparativeOrder").build()).build();

    private static final SdkField<SemanticType> SEMANTIC_TYPE_FIELD = SdkField.<SemanticType> builder(MarshallingType.SDK_POJO)
            .memberName("SemanticType").getter(getter(TopicCalculatedField::semanticType)).setter(setter(Builder::semanticType))
            .constructor(SemanticType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SemanticType").build()).build();

    private static final SdkField<List<String>> ALLOWED_AGGREGATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowedAggregations")
            .getter(getter(TopicCalculatedField::allowedAggregationsAsStrings))
            .setter(setter(Builder::allowedAggregationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedAggregations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NOT_ALLOWED_AGGREGATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NotAllowedAggregations")
            .getter(getter(TopicCalculatedField::notAllowedAggregationsAsStrings))
            .setter(setter(Builder::notAllowedAggregationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotAllowedAggregations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> NEVER_AGGREGATE_IN_FILTER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NeverAggregateInFilter").getter(getter(TopicCalculatedField::neverAggregateInFilter))
            .setter(setter(Builder::neverAggregateInFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NeverAggregateInFilter").build())
            .build();

    private static final SdkField<List<CellValueSynonym>> CELL_VALUE_SYNONYMS_FIELD = SdkField
            .<List<CellValueSynonym>> builder(MarshallingType.LIST)
            .memberName("CellValueSynonyms")
            .getter(getter(TopicCalculatedField::cellValueSynonyms))
            .setter(setter(Builder::cellValueSynonyms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CellValueSynonyms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CellValueSynonym> builder(MarshallingType.SDK_POJO)
                                            .constructor(CellValueSynonym::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> NON_ADDITIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NonAdditive").getter(getter(TopicCalculatedField::nonAdditive)).setter(setter(Builder::nonAdditive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonAdditive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALCULATED_FIELD_NAME_FIELD,
            CALCULATED_FIELD_DESCRIPTION_FIELD, EXPRESSION_FIELD, CALCULATED_FIELD_SYNONYMS_FIELD, IS_INCLUDED_IN_TOPIC_FIELD,
            DISABLE_INDEXING_FIELD, COLUMN_DATA_ROLE_FIELD, TIME_GRANULARITY_FIELD, DEFAULT_FORMATTING_FIELD, AGGREGATION_FIELD,
            COMPARATIVE_ORDER_FIELD, SEMANTIC_TYPE_FIELD, ALLOWED_AGGREGATIONS_FIELD, NOT_ALLOWED_AGGREGATIONS_FIELD,
            NEVER_AGGREGATE_IN_FILTER_FIELD, CELL_VALUE_SYNONYMS_FIELD, NON_ADDITIVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String calculatedFieldName;

    private final String calculatedFieldDescription;

    private final String expression;

    private final List<String> calculatedFieldSynonyms;

    private final Boolean isIncludedInTopic;

    private final Boolean disableIndexing;

    private final String columnDataRole;

    private final String timeGranularity;

    private final DefaultFormatting defaultFormatting;

    private final String aggregation;

    private final ComparativeOrder comparativeOrder;

    private final SemanticType semanticType;

    private final List<String> allowedAggregations;

    private final List<String> notAllowedAggregations;

    private final Boolean neverAggregateInFilter;

    private final List<CellValueSynonym> cellValueSynonyms;

    private final Boolean nonAdditive;

    private TopicCalculatedField(BuilderImpl builder) {
        this.calculatedFieldName = builder.calculatedFieldName;
        this.calculatedFieldDescription = builder.calculatedFieldDescription;
        this.expression = builder.expression;
        this.calculatedFieldSynonyms = builder.calculatedFieldSynonyms;
        this.isIncludedInTopic = builder.isIncludedInTopic;
        this.disableIndexing = builder.disableIndexing;
        this.columnDataRole = builder.columnDataRole;
        this.timeGranularity = builder.timeGranularity;
        this.defaultFormatting = builder.defaultFormatting;
        this.aggregation = builder.aggregation;
        this.comparativeOrder = builder.comparativeOrder;
        this.semanticType = builder.semanticType;
        this.allowedAggregations = builder.allowedAggregations;
        this.notAllowedAggregations = builder.notAllowedAggregations;
        this.neverAggregateInFilter = builder.neverAggregateInFilter;
        this.cellValueSynonyms = builder.cellValueSynonyms;
        this.nonAdditive = builder.nonAdditive;
    }

    /**
     * <p>
     * The calculated field name.
     * </p>
     * 
     * @return The calculated field name.
     */
    public final String calculatedFieldName() {
        return calculatedFieldName;
    }

    /**
     * <p>
     * The calculated field description.
     * </p>
     * 
     * @return The calculated field description.
     */
    public final String calculatedFieldDescription() {
        return calculatedFieldDescription;
    }

    /**
     * <p>
     * The calculated field expression.
     * </p>
     * 
     * @return The calculated field expression.
     */
    public final String expression() {
        return expression;
    }

    /**
     * For responses, this returns true if the service returned a value for the CalculatedFieldSynonyms property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCalculatedFieldSynonyms() {
        return calculatedFieldSynonyms != null && !(calculatedFieldSynonyms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The other names or aliases for the calculated field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCalculatedFieldSynonyms} method.
     * </p>
     * 
     * @return The other names or aliases for the calculated field.
     */
    public final List<String> calculatedFieldSynonyms() {
        return calculatedFieldSynonyms;
    }

    /**
     * <p>
     * A boolean value that indicates if a calculated field is included in the topic.
     * </p>
     * 
     * @return A boolean value that indicates if a calculated field is included in the topic.
     */
    public final Boolean isIncludedInTopic() {
        return isIncludedInTopic;
    }

    /**
     * <p>
     * A Boolean value that indicates if a calculated field is visible in the autocomplete.
     * </p>
     * 
     * @return A Boolean value that indicates if a calculated field is visible in the autocomplete.
     */
    public final Boolean disableIndexing() {
        return disableIndexing;
    }

    /**
     * <p>
     * The column data role for a calculated field. Valid values for this structure are <code>DIMENSION</code> and
     * <code>MEASURE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #columnDataRole}
     * will return {@link ColumnDataRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #columnDataRoleAsString}.
     * </p>
     * 
     * @return The column data role for a calculated field. Valid values for this structure are <code>DIMENSION</code>
     *         and <code>MEASURE</code>.
     * @see ColumnDataRole
     */
    public final ColumnDataRole columnDataRole() {
        return ColumnDataRole.fromValue(columnDataRole);
    }

    /**
     * <p>
     * The column data role for a calculated field. Valid values for this structure are <code>DIMENSION</code> and
     * <code>MEASURE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #columnDataRole}
     * will return {@link ColumnDataRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #columnDataRoleAsString}.
     * </p>
     * 
     * @return The column data role for a calculated field. Valid values for this structure are <code>DIMENSION</code>
     *         and <code>MEASURE</code>.
     * @see ColumnDataRole
     */
    public final String columnDataRoleAsString() {
        return columnDataRole;
    }

    /**
     * <p>
     * The level of time precision that is used to aggregate <code>DateTime</code> values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeGranularity}
     * will return {@link TopicTimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #timeGranularityAsString}.
     * </p>
     * 
     * @return The level of time precision that is used to aggregate <code>DateTime</code> values.
     * @see TopicTimeGranularity
     */
    public final TopicTimeGranularity timeGranularity() {
        return TopicTimeGranularity.fromValue(timeGranularity);
    }

    /**
     * <p>
     * The level of time precision that is used to aggregate <code>DateTime</code> values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeGranularity}
     * will return {@link TopicTimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #timeGranularityAsString}.
     * </p>
     * 
     * @return The level of time precision that is used to aggregate <code>DateTime</code> values.
     * @see TopicTimeGranularity
     */
    public final String timeGranularityAsString() {
        return timeGranularity;
    }

    /**
     * <p>
     * The default formatting definition.
     * </p>
     * 
     * @return The default formatting definition.
     */
    public final DefaultFormatting defaultFormatting() {
        return defaultFormatting;
    }

    /**
     * <p>
     * The default aggregation. Valid values for this structure are <code>SUM</code>, <code>MAX</code>, <code>MIN</code>, <code>COUNT</code>, <code>DISTINCT_COUNT</code>, and <code>AVERAGE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregation} will
     * return {@link DefaultAggregation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aggregationAsString}.
     * </p>
     * 
     * @return The default aggregation. Valid values for this structure are <code>SUM</code>, <code>MAX</code>,
     *         <code>MIN</code>, <code>COUNT</code>, <code>DISTINCT_COUNT</code>, and <code>AVERAGE</code>.
     * @see DefaultAggregation
     */
    public final DefaultAggregation aggregation() {
        return DefaultAggregation.fromValue(aggregation);
    }

    /**
     * <p>
     * The default aggregation. Valid values for this structure are <code>SUM</code>, <code>MAX</code>, <code>MIN</code>, <code>COUNT</code>, <code>DISTINCT_COUNT</code>, and <code>AVERAGE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregation} will
     * return {@link DefaultAggregation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aggregationAsString}.
     * </p>
     * 
     * @return The default aggregation. Valid values for this structure are <code>SUM</code>, <code>MAX</code>,
     *         <code>MIN</code>, <code>COUNT</code>, <code>DISTINCT_COUNT</code>, and <code>AVERAGE</code>.
     * @see DefaultAggregation
     */
    public final String aggregationAsString() {
        return aggregation;
    }

    /**
     * <p>
     * The order in which data is displayed for the calculated field when it's used in a comparative context.
     * </p>
     * 
     * @return The order in which data is displayed for the calculated field when it's used in a comparative context.
     */
    public final ComparativeOrder comparativeOrder() {
        return comparativeOrder;
    }

    /**
     * <p>
     * The semantic type.
     * </p>
     * 
     * @return The semantic type.
     */
    public final SemanticType semanticType() {
        return semanticType;
    }

    /**
     * <p>
     * The list of aggregation types that are allowed for the calculated field. Valid values for this structure are
     * <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
     * <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
     * <code>VARP</code>, and <code>PERCENTILE</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedAggregations} method.
     * </p>
     * 
     * @return The list of aggregation types that are allowed for the calculated field. Valid values for this structure
     *         are <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>,
     *         <code>MEDIAN</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>,
     *         <code>VAR</code>, <code>VARP</code>, and <code>PERCENTILE</code>.
     */
    public final List<AuthorSpecifiedAggregation> allowedAggregations() {
        return AuthorSpecifiedAggregationsCopier.copyStringToEnum(allowedAggregations);
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedAggregations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedAggregations() {
        return allowedAggregations != null && !(allowedAggregations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of aggregation types that are allowed for the calculated field. Valid values for this structure are
     * <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
     * <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
     * <code>VARP</code>, and <code>PERCENTILE</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedAggregations} method.
     * </p>
     * 
     * @return The list of aggregation types that are allowed for the calculated field. Valid values for this structure
     *         are <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>,
     *         <code>MEDIAN</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>,
     *         <code>VAR</code>, <code>VARP</code>, and <code>PERCENTILE</code>.
     */
    public final List<String> allowedAggregationsAsStrings() {
        return allowedAggregations;
    }

    /**
     * <p>
     * The list of aggregation types that are not allowed for the calculated field. Valid values for this structure are
     * <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
     * <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
     * <code>VARP</code>, and <code>PERCENTILE</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotAllowedAggregations} method.
     * </p>
     * 
     * @return The list of aggregation types that are not allowed for the calculated field. Valid values for this
     *         structure are <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>,
     *         <code>MEDIAN</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>,
     *         <code>VAR</code>, <code>VARP</code>, and <code>PERCENTILE</code>.
     */
    public final List<AuthorSpecifiedAggregation> notAllowedAggregations() {
        return AuthorSpecifiedAggregationsCopier.copyStringToEnum(notAllowedAggregations);
    }

    /**
     * For responses, this returns true if the service returned a value for the NotAllowedAggregations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNotAllowedAggregations() {
        return notAllowedAggregations != null && !(notAllowedAggregations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of aggregation types that are not allowed for the calculated field. Valid values for this structure are
     * <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
     * <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
     * <code>VARP</code>, and <code>PERCENTILE</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotAllowedAggregations} method.
     * </p>
     * 
     * @return The list of aggregation types that are not allowed for the calculated field. Valid values for this
     *         structure are <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>,
     *         <code>MEDIAN</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>,
     *         <code>VAR</code>, <code>VARP</code>, and <code>PERCENTILE</code>.
     */
    public final List<String> notAllowedAggregationsAsStrings() {
        return notAllowedAggregations;
    }

    /**
     * <p>
     * A Boolean value that indicates whether to never aggregate calculated field in filters.
     * </p>
     * 
     * @return A Boolean value that indicates whether to never aggregate calculated field in filters.
     */
    public final Boolean neverAggregateInFilter() {
        return neverAggregateInFilter;
    }

    /**
     * For responses, this returns true if the service returned a value for the CellValueSynonyms property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCellValueSynonyms() {
        return cellValueSynonyms != null && !(cellValueSynonyms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The other names or aliases for the calculated field cell value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCellValueSynonyms} method.
     * </p>
     * 
     * @return The other names or aliases for the calculated field cell value.
     */
    public final List<CellValueSynonym> cellValueSynonyms() {
        return cellValueSynonyms;
    }

    /**
     * <p>
     * The non additive for the table style target.
     * </p>
     * 
     * @return The non additive for the table style target.
     */
    public final Boolean nonAdditive() {
        return nonAdditive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(calculatedFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(calculatedFieldDescription());
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(hasCalculatedFieldSynonyms() ? calculatedFieldSynonyms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isIncludedInTopic());
        hashCode = 31 * hashCode + Objects.hashCode(disableIndexing());
        hashCode = 31 * hashCode + Objects.hashCode(columnDataRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timeGranularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultFormatting());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(comparativeOrder());
        hashCode = 31 * hashCode + Objects.hashCode(semanticType());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedAggregations() ? allowedAggregationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNotAllowedAggregations() ? notAllowedAggregationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(neverAggregateInFilter());
        hashCode = 31 * hashCode + Objects.hashCode(hasCellValueSynonyms() ? cellValueSynonyms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nonAdditive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicCalculatedField)) {
            return false;
        }
        TopicCalculatedField other = (TopicCalculatedField) obj;
        return Objects.equals(calculatedFieldName(), other.calculatedFieldName())
                && Objects.equals(calculatedFieldDescription(), other.calculatedFieldDescription())
                && Objects.equals(expression(), other.expression())
                && hasCalculatedFieldSynonyms() == other.hasCalculatedFieldSynonyms()
                && Objects.equals(calculatedFieldSynonyms(), other.calculatedFieldSynonyms())
                && Objects.equals(isIncludedInTopic(), other.isIncludedInTopic())
                && Objects.equals(disableIndexing(), other.disableIndexing())
                && Objects.equals(columnDataRoleAsString(), other.columnDataRoleAsString())
                && Objects.equals(timeGranularityAsString(), other.timeGranularityAsString())
                && Objects.equals(defaultFormatting(), other.defaultFormatting())
                && Objects.equals(aggregationAsString(), other.aggregationAsString())
                && Objects.equals(comparativeOrder(), other.comparativeOrder())
                && Objects.equals(semanticType(), other.semanticType())
                && hasAllowedAggregations() == other.hasAllowedAggregations()
                && Objects.equals(allowedAggregationsAsStrings(), other.allowedAggregationsAsStrings())
                && hasNotAllowedAggregations() == other.hasNotAllowedAggregations()
                && Objects.equals(notAllowedAggregationsAsStrings(), other.notAllowedAggregationsAsStrings())
                && Objects.equals(neverAggregateInFilter(), other.neverAggregateInFilter())
                && hasCellValueSynonyms() == other.hasCellValueSynonyms()
                && Objects.equals(cellValueSynonyms(), other.cellValueSynonyms())
                && Objects.equals(nonAdditive(), other.nonAdditive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicCalculatedField").add("CalculatedFieldName", calculatedFieldName())
                .add("CalculatedFieldDescription", calculatedFieldDescription())
                .add("Expression", expression() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CalculatedFieldSynonyms", hasCalculatedFieldSynonyms() ? calculatedFieldSynonyms() : null)
                .add("IsIncludedInTopic", isIncludedInTopic()).add("DisableIndexing", disableIndexing())
                .add("ColumnDataRole", columnDataRoleAsString()).add("TimeGranularity", timeGranularityAsString())
                .add("DefaultFormatting", defaultFormatting()).add("Aggregation", aggregationAsString())
                .add("ComparativeOrder", comparativeOrder()).add("SemanticType", semanticType())
                .add("AllowedAggregations", hasAllowedAggregations() ? allowedAggregationsAsStrings() : null)
                .add("NotAllowedAggregations", hasNotAllowedAggregations() ? notAllowedAggregationsAsStrings() : null)
                .add("NeverAggregateInFilter", neverAggregateInFilter())
                .add("CellValueSynonyms", hasCellValueSynonyms() ? cellValueSynonyms() : null).add("NonAdditive", nonAdditive())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CalculatedFieldName":
            return Optional.ofNullable(clazz.cast(calculatedFieldName()));
        case "CalculatedFieldDescription":
            return Optional.ofNullable(clazz.cast(calculatedFieldDescription()));
        case "Expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "CalculatedFieldSynonyms":
            return Optional.ofNullable(clazz.cast(calculatedFieldSynonyms()));
        case "IsIncludedInTopic":
            return Optional.ofNullable(clazz.cast(isIncludedInTopic()));
        case "DisableIndexing":
            return Optional.ofNullable(clazz.cast(disableIndexing()));
        case "ColumnDataRole":
            return Optional.ofNullable(clazz.cast(columnDataRoleAsString()));
        case "TimeGranularity":
            return Optional.ofNullable(clazz.cast(timeGranularityAsString()));
        case "DefaultFormatting":
            return Optional.ofNullable(clazz.cast(defaultFormatting()));
        case "Aggregation":
            return Optional.ofNullable(clazz.cast(aggregationAsString()));
        case "ComparativeOrder":
            return Optional.ofNullable(clazz.cast(comparativeOrder()));
        case "SemanticType":
            return Optional.ofNullable(clazz.cast(semanticType()));
        case "AllowedAggregations":
            return Optional.ofNullable(clazz.cast(allowedAggregationsAsStrings()));
        case "NotAllowedAggregations":
            return Optional.ofNullable(clazz.cast(notAllowedAggregationsAsStrings()));
        case "NeverAggregateInFilter":
            return Optional.ofNullable(clazz.cast(neverAggregateInFilter()));
        case "CellValueSynonyms":
            return Optional.ofNullable(clazz.cast(cellValueSynonyms()));
        case "NonAdditive":
            return Optional.ofNullable(clazz.cast(nonAdditive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicCalculatedField, T> g) {
        return obj -> g.apply((TopicCalculatedField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicCalculatedField> {
        /**
         * <p>
         * The calculated field name.
         * </p>
         * 
         * @param calculatedFieldName
         *        The calculated field name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatedFieldName(String calculatedFieldName);

        /**
         * <p>
         * The calculated field description.
         * </p>
         * 
         * @param calculatedFieldDescription
         *        The calculated field description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatedFieldDescription(String calculatedFieldDescription);

        /**
         * <p>
         * The calculated field expression.
         * </p>
         * 
         * @param expression
         *        The calculated field expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * The other names or aliases for the calculated field.
         * </p>
         * 
         * @param calculatedFieldSynonyms
         *        The other names or aliases for the calculated field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatedFieldSynonyms(Collection<String> calculatedFieldSynonyms);

        /**
         * <p>
         * The other names or aliases for the calculated field.
         * </p>
         * 
         * @param calculatedFieldSynonyms
         *        The other names or aliases for the calculated field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatedFieldSynonyms(String... calculatedFieldSynonyms);

        /**
         * <p>
         * A boolean value that indicates if a calculated field is included in the topic.
         * </p>
         * 
         * @param isIncludedInTopic
         *        A boolean value that indicates if a calculated field is included in the topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isIncludedInTopic(Boolean isIncludedInTopic);

        /**
         * <p>
         * A Boolean value that indicates if a calculated field is visible in the autocomplete.
         * </p>
         * 
         * @param disableIndexing
         *        A Boolean value that indicates if a calculated field is visible in the autocomplete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableIndexing(Boolean disableIndexing);

        /**
         * <p>
         * The column data role for a calculated field. Valid values for this structure are <code>DIMENSION</code> and
         * <code>MEASURE</code>.
         * </p>
         * 
         * @param columnDataRole
         *        The column data role for a calculated field. Valid values for this structure are
         *        <code>DIMENSION</code> and <code>MEASURE</code>.
         * @see ColumnDataRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColumnDataRole
         */
        Builder columnDataRole(String columnDataRole);

        /**
         * <p>
         * The column data role for a calculated field. Valid values for this structure are <code>DIMENSION</code> and
         * <code>MEASURE</code>.
         * </p>
         * 
         * @param columnDataRole
         *        The column data role for a calculated field. Valid values for this structure are
         *        <code>DIMENSION</code> and <code>MEASURE</code>.
         * @see ColumnDataRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColumnDataRole
         */
        Builder columnDataRole(ColumnDataRole columnDataRole);

        /**
         * <p>
         * The level of time precision that is used to aggregate <code>DateTime</code> values.
         * </p>
         * 
         * @param timeGranularity
         *        The level of time precision that is used to aggregate <code>DateTime</code> values.
         * @see TopicTimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicTimeGranularity
         */
        Builder timeGranularity(String timeGranularity);

        /**
         * <p>
         * The level of time precision that is used to aggregate <code>DateTime</code> values.
         * </p>
         * 
         * @param timeGranularity
         *        The level of time precision that is used to aggregate <code>DateTime</code> values.
         * @see TopicTimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicTimeGranularity
         */
        Builder timeGranularity(TopicTimeGranularity timeGranularity);

        /**
         * <p>
         * The default formatting definition.
         * </p>
         * 
         * @param defaultFormatting
         *        The default formatting definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultFormatting(DefaultFormatting defaultFormatting);

        /**
         * <p>
         * The default formatting definition.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultFormatting.Builder} avoiding the
         * need to create one manually via {@link DefaultFormatting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultFormatting.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultFormatting(DefaultFormatting)}.
         * 
         * @param defaultFormatting
         *        a consumer that will call methods on {@link DefaultFormatting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultFormatting(DefaultFormatting)
         */
        default Builder defaultFormatting(Consumer<DefaultFormatting.Builder> defaultFormatting) {
            return defaultFormatting(DefaultFormatting.builder().applyMutation(defaultFormatting).build());
        }

        /**
         * <p>
         * The default aggregation. Valid values for this structure are <code>SUM</code>, <code>MAX</code>,
         * <code>MIN</code>, <code>COUNT</code>, <code>DISTINCT_COUNT</code>, and <code>AVERAGE</code>.
         * </p>
         * 
         * @param aggregation
         *        The default aggregation. Valid values for this structure are <code>SUM</code>, <code>MAX</code>,
         *        <code>MIN</code>, <code>COUNT</code>, <code>DISTINCT_COUNT</code>, and <code>AVERAGE</code>.
         * @see DefaultAggregation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultAggregation
         */
        Builder aggregation(String aggregation);

        /**
         * <p>
         * The default aggregation. Valid values for this structure are <code>SUM</code>, <code>MAX</code>,
         * <code>MIN</code>, <code>COUNT</code>, <code>DISTINCT_COUNT</code>, and <code>AVERAGE</code>.
         * </p>
         * 
         * @param aggregation
         *        The default aggregation. Valid values for this structure are <code>SUM</code>, <code>MAX</code>,
         *        <code>MIN</code>, <code>COUNT</code>, <code>DISTINCT_COUNT</code>, and <code>AVERAGE</code>.
         * @see DefaultAggregation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultAggregation
         */
        Builder aggregation(DefaultAggregation aggregation);

        /**
         * <p>
         * The order in which data is displayed for the calculated field when it's used in a comparative context.
         * </p>
         * 
         * @param comparativeOrder
         *        The order in which data is displayed for the calculated field when it's used in a comparative context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comparativeOrder(ComparativeOrder comparativeOrder);

        /**
         * <p>
         * The order in which data is displayed for the calculated field when it's used in a comparative context.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComparativeOrder.Builder} avoiding the
         * need to create one manually via {@link ComparativeOrder#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComparativeOrder.Builder#build()} is called immediately and its
         * result is passed to {@link #comparativeOrder(ComparativeOrder)}.
         * 
         * @param comparativeOrder
         *        a consumer that will call methods on {@link ComparativeOrder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comparativeOrder(ComparativeOrder)
         */
        default Builder comparativeOrder(Consumer<ComparativeOrder.Builder> comparativeOrder) {
            return comparativeOrder(ComparativeOrder.builder().applyMutation(comparativeOrder).build());
        }

        /**
         * <p>
         * The semantic type.
         * </p>
         * 
         * @param semanticType
         *        The semantic type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticType(SemanticType semanticType);

        /**
         * <p>
         * The semantic type.
         * </p>
         * This is a convenience method that creates an instance of the {@link SemanticType.Builder} avoiding the need
         * to create one manually via {@link SemanticType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SemanticType.Builder#build()} is called immediately and its
         * result is passed to {@link #semanticType(SemanticType)}.
         * 
         * @param semanticType
         *        a consumer that will call methods on {@link SemanticType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #semanticType(SemanticType)
         */
        default Builder semanticType(Consumer<SemanticType.Builder> semanticType) {
            return semanticType(SemanticType.builder().applyMutation(semanticType).build());
        }

        /**
         * <p>
         * The list of aggregation types that are allowed for the calculated field. Valid values for this structure are
         * <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
         * <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
         * <code>VARP</code>, and <code>PERCENTILE</code>.
         * </p>
         * 
         * @param allowedAggregations
         *        The list of aggregation types that are allowed for the calculated field. Valid values for this
         *        structure are <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>,
         *        <code>MEDIAN</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>,
         *        <code>VAR</code>, <code>VARP</code>, and <code>PERCENTILE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAggregationsWithStrings(Collection<String> allowedAggregations);

        /**
         * <p>
         * The list of aggregation types that are allowed for the calculated field. Valid values for this structure are
         * <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
         * <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
         * <code>VARP</code>, and <code>PERCENTILE</code>.
         * </p>
         * 
         * @param allowedAggregations
         *        The list of aggregation types that are allowed for the calculated field. Valid values for this
         *        structure are <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>,
         *        <code>MEDIAN</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>,
         *        <code>VAR</code>, <code>VARP</code>, and <code>PERCENTILE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAggregationsWithStrings(String... allowedAggregations);

        /**
         * <p>
         * The list of aggregation types that are allowed for the calculated field. Valid values for this structure are
         * <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
         * <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
         * <code>VARP</code>, and <code>PERCENTILE</code>.
         * </p>
         * 
         * @param allowedAggregations
         *        The list of aggregation types that are allowed for the calculated field. Valid values for this
         *        structure are <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>,
         *        <code>MEDIAN</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>,
         *        <code>VAR</code>, <code>VARP</code>, and <code>PERCENTILE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAggregations(Collection<AuthorSpecifiedAggregation> allowedAggregations);

        /**
         * <p>
         * The list of aggregation types that are allowed for the calculated field. Valid values for this structure are
         * <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
         * <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
         * <code>VARP</code>, and <code>PERCENTILE</code>.
         * </p>
         * 
         * @param allowedAggregations
         *        The list of aggregation types that are allowed for the calculated field. Valid values for this
         *        structure are <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>,
         *        <code>MEDIAN</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>,
         *        <code>VAR</code>, <code>VARP</code>, and <code>PERCENTILE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAggregations(AuthorSpecifiedAggregation... allowedAggregations);

        /**
         * <p>
         * The list of aggregation types that are not allowed for the calculated field. Valid values for this structure
         * are <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
         * <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
         * <code>VARP</code>, and <code>PERCENTILE</code>.
         * </p>
         * 
         * @param notAllowedAggregations
         *        The list of aggregation types that are not allowed for the calculated field. Valid values for this
         *        structure are <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>,
         *        <code>MEDIAN</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>,
         *        <code>VAR</code>, <code>VARP</code>, and <code>PERCENTILE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notAllowedAggregationsWithStrings(Collection<String> notAllowedAggregations);

        /**
         * <p>
         * The list of aggregation types that are not allowed for the calculated field. Valid values for this structure
         * are <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
         * <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
         * <code>VARP</code>, and <code>PERCENTILE</code>.
         * </p>
         * 
         * @param notAllowedAggregations
         *        The list of aggregation types that are not allowed for the calculated field. Valid values for this
         *        structure are <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>,
         *        <code>MEDIAN</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>,
         *        <code>VAR</code>, <code>VARP</code>, and <code>PERCENTILE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notAllowedAggregationsWithStrings(String... notAllowedAggregations);

        /**
         * <p>
         * The list of aggregation types that are not allowed for the calculated field. Valid values for this structure
         * are <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
         * <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
         * <code>VARP</code>, and <code>PERCENTILE</code>.
         * </p>
         * 
         * @param notAllowedAggregations
         *        The list of aggregation types that are not allowed for the calculated field. Valid values for this
         *        structure are <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>,
         *        <code>MEDIAN</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>,
         *        <code>VAR</code>, <code>VARP</code>, and <code>PERCENTILE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notAllowedAggregations(Collection<AuthorSpecifiedAggregation> notAllowedAggregations);

        /**
         * <p>
         * The list of aggregation types that are not allowed for the calculated field. Valid values for this structure
         * are <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>,
         * <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
         * <code>VARP</code>, and <code>PERCENTILE</code>.
         * </p>
         * 
         * @param notAllowedAggregations
         *        The list of aggregation types that are not allowed for the calculated field. Valid values for this
         *        structure are <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>,
         *        <code>MEDIAN</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>,
         *        <code>VAR</code>, <code>VARP</code>, and <code>PERCENTILE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notAllowedAggregations(AuthorSpecifiedAggregation... notAllowedAggregations);

        /**
         * <p>
         * A Boolean value that indicates whether to never aggregate calculated field in filters.
         * </p>
         * 
         * @param neverAggregateInFilter
         *        A Boolean value that indicates whether to never aggregate calculated field in filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neverAggregateInFilter(Boolean neverAggregateInFilter);

        /**
         * <p>
         * The other names or aliases for the calculated field cell value.
         * </p>
         * 
         * @param cellValueSynonyms
         *        The other names or aliases for the calculated field cell value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cellValueSynonyms(Collection<CellValueSynonym> cellValueSynonyms);

        /**
         * <p>
         * The other names or aliases for the calculated field cell value.
         * </p>
         * 
         * @param cellValueSynonyms
         *        The other names or aliases for the calculated field cell value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cellValueSynonyms(CellValueSynonym... cellValueSynonyms);

        /**
         * <p>
         * The other names or aliases for the calculated field cell value.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.CellValueSynonym.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.CellValueSynonym#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.CellValueSynonym.Builder#build()} is called
         * immediately and its result is passed to {@link #cellValueSynonyms(List<CellValueSynonym>)}.
         * 
         * @param cellValueSynonyms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.CellValueSynonym.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cellValueSynonyms(java.util.Collection<CellValueSynonym>)
         */
        Builder cellValueSynonyms(Consumer<CellValueSynonym.Builder>... cellValueSynonyms);

        /**
         * <p>
         * The non additive for the table style target.
         * </p>
         * 
         * @param nonAdditive
         *        The non additive for the table style target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonAdditive(Boolean nonAdditive);
    }

    static final class BuilderImpl implements Builder {
        private String calculatedFieldName;

        private String calculatedFieldDescription;

        private String expression;

        private List<String> calculatedFieldSynonyms = DefaultSdkAutoConstructList.getInstance();

        private Boolean isIncludedInTopic;

        private Boolean disableIndexing;

        private String columnDataRole;

        private String timeGranularity;

        private DefaultFormatting defaultFormatting;

        private String aggregation;

        private ComparativeOrder comparativeOrder;

        private SemanticType semanticType;

        private List<String> allowedAggregations = DefaultSdkAutoConstructList.getInstance();

        private List<String> notAllowedAggregations = DefaultSdkAutoConstructList.getInstance();

        private Boolean neverAggregateInFilter;

        private List<CellValueSynonym> cellValueSynonyms = DefaultSdkAutoConstructList.getInstance();

        private Boolean nonAdditive;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicCalculatedField model) {
            calculatedFieldName(model.calculatedFieldName);
            calculatedFieldDescription(model.calculatedFieldDescription);
            expression(model.expression);
            calculatedFieldSynonyms(model.calculatedFieldSynonyms);
            isIncludedInTopic(model.isIncludedInTopic);
            disableIndexing(model.disableIndexing);
            columnDataRole(model.columnDataRole);
            timeGranularity(model.timeGranularity);
            defaultFormatting(model.defaultFormatting);
            aggregation(model.aggregation);
            comparativeOrder(model.comparativeOrder);
            semanticType(model.semanticType);
            allowedAggregationsWithStrings(model.allowedAggregations);
            notAllowedAggregationsWithStrings(model.notAllowedAggregations);
            neverAggregateInFilter(model.neverAggregateInFilter);
            cellValueSynonyms(model.cellValueSynonyms);
            nonAdditive(model.nonAdditive);
        }

        public final String getCalculatedFieldName() {
            return calculatedFieldName;
        }

        public final void setCalculatedFieldName(String calculatedFieldName) {
            this.calculatedFieldName = calculatedFieldName;
        }

        @Override
        public final Builder calculatedFieldName(String calculatedFieldName) {
            this.calculatedFieldName = calculatedFieldName;
            return this;
        }

        public final String getCalculatedFieldDescription() {
            return calculatedFieldDescription;
        }

        public final void setCalculatedFieldDescription(String calculatedFieldDescription) {
            this.calculatedFieldDescription = calculatedFieldDescription;
        }

        @Override
        public final Builder calculatedFieldDescription(String calculatedFieldDescription) {
            this.calculatedFieldDescription = calculatedFieldDescription;
            return this;
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final Collection<String> getCalculatedFieldSynonyms() {
            if (calculatedFieldSynonyms instanceof SdkAutoConstructList) {
                return null;
            }
            return calculatedFieldSynonyms;
        }

        public final void setCalculatedFieldSynonyms(Collection<String> calculatedFieldSynonyms) {
            this.calculatedFieldSynonyms = SynonymsCopier.copy(calculatedFieldSynonyms);
        }

        @Override
        public final Builder calculatedFieldSynonyms(Collection<String> calculatedFieldSynonyms) {
            this.calculatedFieldSynonyms = SynonymsCopier.copy(calculatedFieldSynonyms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calculatedFieldSynonyms(String... calculatedFieldSynonyms) {
            calculatedFieldSynonyms(Arrays.asList(calculatedFieldSynonyms));
            return this;
        }

        public final Boolean getIsIncludedInTopic() {
            return isIncludedInTopic;
        }

        public final void setIsIncludedInTopic(Boolean isIncludedInTopic) {
            this.isIncludedInTopic = isIncludedInTopic;
        }

        @Override
        public final Builder isIncludedInTopic(Boolean isIncludedInTopic) {
            this.isIncludedInTopic = isIncludedInTopic;
            return this;
        }

        public final Boolean getDisableIndexing() {
            return disableIndexing;
        }

        public final void setDisableIndexing(Boolean disableIndexing) {
            this.disableIndexing = disableIndexing;
        }

        @Override
        public final Builder disableIndexing(Boolean disableIndexing) {
            this.disableIndexing = disableIndexing;
            return this;
        }

        public final String getColumnDataRole() {
            return columnDataRole;
        }

        public final void setColumnDataRole(String columnDataRole) {
            this.columnDataRole = columnDataRole;
        }

        @Override
        public final Builder columnDataRole(String columnDataRole) {
            this.columnDataRole = columnDataRole;
            return this;
        }

        @Override
        public final Builder columnDataRole(ColumnDataRole columnDataRole) {
            this.columnDataRole(columnDataRole == null ? null : columnDataRole.toString());
            return this;
        }

        public final String getTimeGranularity() {
            return timeGranularity;
        }

        public final void setTimeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
        }

        @Override
        public final Builder timeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
            return this;
        }

        @Override
        public final Builder timeGranularity(TopicTimeGranularity timeGranularity) {
            this.timeGranularity(timeGranularity == null ? null : timeGranularity.toString());
            return this;
        }

        public final DefaultFormatting.Builder getDefaultFormatting() {
            return defaultFormatting != null ? defaultFormatting.toBuilder() : null;
        }

        public final void setDefaultFormatting(DefaultFormatting.BuilderImpl defaultFormatting) {
            this.defaultFormatting = defaultFormatting != null ? defaultFormatting.build() : null;
        }

        @Override
        public final Builder defaultFormatting(DefaultFormatting defaultFormatting) {
            this.defaultFormatting = defaultFormatting;
            return this;
        }

        public final String getAggregation() {
            return aggregation;
        }

        public final void setAggregation(String aggregation) {
            this.aggregation = aggregation;
        }

        @Override
        public final Builder aggregation(String aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        @Override
        public final Builder aggregation(DefaultAggregation aggregation) {
            this.aggregation(aggregation == null ? null : aggregation.toString());
            return this;
        }

        public final ComparativeOrder.Builder getComparativeOrder() {
            return comparativeOrder != null ? comparativeOrder.toBuilder() : null;
        }

        public final void setComparativeOrder(ComparativeOrder.BuilderImpl comparativeOrder) {
            this.comparativeOrder = comparativeOrder != null ? comparativeOrder.build() : null;
        }

        @Override
        public final Builder comparativeOrder(ComparativeOrder comparativeOrder) {
            this.comparativeOrder = comparativeOrder;
            return this;
        }

        public final SemanticType.Builder getSemanticType() {
            return semanticType != null ? semanticType.toBuilder() : null;
        }

        public final void setSemanticType(SemanticType.BuilderImpl semanticType) {
            this.semanticType = semanticType != null ? semanticType.build() : null;
        }

        @Override
        public final Builder semanticType(SemanticType semanticType) {
            this.semanticType = semanticType;
            return this;
        }

        public final Collection<String> getAllowedAggregations() {
            if (allowedAggregations instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedAggregations;
        }

        public final void setAllowedAggregations(Collection<String> allowedAggregations) {
            this.allowedAggregations = AuthorSpecifiedAggregationsCopier.copy(allowedAggregations);
        }

        @Override
        public final Builder allowedAggregationsWithStrings(Collection<String> allowedAggregations) {
            this.allowedAggregations = AuthorSpecifiedAggregationsCopier.copy(allowedAggregations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedAggregationsWithStrings(String... allowedAggregations) {
            allowedAggregationsWithStrings(Arrays.asList(allowedAggregations));
            return this;
        }

        @Override
        public final Builder allowedAggregations(Collection<AuthorSpecifiedAggregation> allowedAggregations) {
            this.allowedAggregations = AuthorSpecifiedAggregationsCopier.copyEnumToString(allowedAggregations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedAggregations(AuthorSpecifiedAggregation... allowedAggregations) {
            allowedAggregations(Arrays.asList(allowedAggregations));
            return this;
        }

        public final Collection<String> getNotAllowedAggregations() {
            if (notAllowedAggregations instanceof SdkAutoConstructList) {
                return null;
            }
            return notAllowedAggregations;
        }

        public final void setNotAllowedAggregations(Collection<String> notAllowedAggregations) {
            this.notAllowedAggregations = AuthorSpecifiedAggregationsCopier.copy(notAllowedAggregations);
        }

        @Override
        public final Builder notAllowedAggregationsWithStrings(Collection<String> notAllowedAggregations) {
            this.notAllowedAggregations = AuthorSpecifiedAggregationsCopier.copy(notAllowedAggregations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notAllowedAggregationsWithStrings(String... notAllowedAggregations) {
            notAllowedAggregationsWithStrings(Arrays.asList(notAllowedAggregations));
            return this;
        }

        @Override
        public final Builder notAllowedAggregations(Collection<AuthorSpecifiedAggregation> notAllowedAggregations) {
            this.notAllowedAggregations = AuthorSpecifiedAggregationsCopier.copyEnumToString(notAllowedAggregations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notAllowedAggregations(AuthorSpecifiedAggregation... notAllowedAggregations) {
            notAllowedAggregations(Arrays.asList(notAllowedAggregations));
            return this;
        }

        public final Boolean getNeverAggregateInFilter() {
            return neverAggregateInFilter;
        }

        public final void setNeverAggregateInFilter(Boolean neverAggregateInFilter) {
            this.neverAggregateInFilter = neverAggregateInFilter;
        }

        @Override
        public final Builder neverAggregateInFilter(Boolean neverAggregateInFilter) {
            this.neverAggregateInFilter = neverAggregateInFilter;
            return this;
        }

        public final List<CellValueSynonym.Builder> getCellValueSynonyms() {
            List<CellValueSynonym.Builder> result = CellValueSynonymsCopier.copyToBuilder(this.cellValueSynonyms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCellValueSynonyms(Collection<CellValueSynonym.BuilderImpl> cellValueSynonyms) {
            this.cellValueSynonyms = CellValueSynonymsCopier.copyFromBuilder(cellValueSynonyms);
        }

        @Override
        public final Builder cellValueSynonyms(Collection<CellValueSynonym> cellValueSynonyms) {
            this.cellValueSynonyms = CellValueSynonymsCopier.copy(cellValueSynonyms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cellValueSynonyms(CellValueSynonym... cellValueSynonyms) {
            cellValueSynonyms(Arrays.asList(cellValueSynonyms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cellValueSynonyms(Consumer<CellValueSynonym.Builder>... cellValueSynonyms) {
            cellValueSynonyms(Stream.of(cellValueSynonyms).map(c -> CellValueSynonym.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getNonAdditive() {
            return nonAdditive;
        }

        public final void setNonAdditive(Boolean nonAdditive) {
            this.nonAdditive = nonAdditive;
        }

        @Override
        public final Builder nonAdditive(Boolean nonAdditive) {
            this.nonAdditive = nonAdditive;
            return this;
        }

        @Override
        public TopicCalculatedField build() {
            return new TopicCalculatedField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
