/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The theme version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThemeVersionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ThemeVersionSummary.Builder, ThemeVersionSummary> {
    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("VersionNumber").getter(getter(ThemeVersionSummary::versionNumber))
            .setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ThemeVersionSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ThemeVersionSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(ThemeVersionSummary::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ThemeVersionSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_NUMBER_FIELD,
            ARN_FIELD, DESCRIPTION_FIELD, CREATED_TIME_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long versionNumber;

    private final String arn;

    private final String description;

    private final Instant createdTime;

    private final String status;

    private ThemeVersionSummary(BuilderImpl builder) {
        this.versionNumber = builder.versionNumber;
        this.arn = builder.arn;
        this.description = builder.description;
        this.createdTime = builder.createdTime;
        this.status = builder.status;
    }

    /**
     * <p>
     * The version number of the theme version.
     * </p>
     * 
     * @return The version number of the theme version.
     */
    public final Long versionNumber() {
        return versionNumber;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the theme version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the theme version.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The description of the theme version.
     * </p>
     * 
     * @return The description of the theme version.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The date and time that this theme version was created.
     * </p>
     * 
     * @return The date and time that this theme version was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The status of the theme version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the theme version.
     * @see ResourceStatus
     */
    public final ResourceStatus status() {
        return ResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the theme version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the theme version.
     * @see ResourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThemeVersionSummary)) {
            return false;
        }
        ThemeVersionSummary other = (ThemeVersionSummary) obj;
        return Objects.equals(versionNumber(), other.versionNumber()) && Objects.equals(arn(), other.arn())
                && Objects.equals(description(), other.description()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThemeVersionSummary").add("VersionNumber", versionNumber()).add("Arn", arn())
                .add("Description", description()).add("CreatedTime", createdTime()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VersionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThemeVersionSummary, T> g) {
        return obj -> g.apply((ThemeVersionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThemeVersionSummary> {
        /**
         * <p>
         * The version number of the theme version.
         * </p>
         * 
         * @param versionNumber
         *        The version number of the theme version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the theme version.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the theme version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The description of the theme version.
         * </p>
         * 
         * @param description
         *        The description of the theme version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date and time that this theme version was created.
         * </p>
         * 
         * @param createdTime
         *        The date and time that this theme version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The status of the theme version.
         * </p>
         * 
         * @param status
         *        The status of the theme version.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the theme version.
         * </p>
         * 
         * @param status
         *        The status of the theme version.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(ResourceStatus status);
    }

    static final class BuilderImpl implements Builder {
        private Long versionNumber;

        private String arn;

        private String description;

        private Instant createdTime;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ThemeVersionSummary model) {
            versionNumber(model.versionNumber);
            arn(model.arn);
            description(model.description);
            createdTime(model.createdTime);
            status(model.status);
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ThemeVersionSummary build() {
            return new ThemeVersionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
