/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The error type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NamespaceInfoV2 implements SdkPojo, Serializable, ToCopyableBuilder<NamespaceInfoV2.Builder, NamespaceInfoV2> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(NamespaceInfoV2::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(NamespaceInfoV2::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CAPACITY_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CapacityRegion").getter(getter(NamespaceInfoV2::capacityRegion)).setter(setter(Builder::capacityRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityRegion").build()).build();

    private static final SdkField<String> CREATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationStatus").getter(getter(NamespaceInfoV2::creationStatusAsString))
            .setter(setter(Builder::creationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationStatus").build()).build();

    private static final SdkField<String> IDENTITY_STORE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityStore").getter(getter(NamespaceInfoV2::identityStoreAsString))
            .setter(setter(Builder::identityStore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityStore").build()).build();

    private static final SdkField<NamespaceError> NAMESPACE_ERROR_FIELD = SdkField
            .<NamespaceError> builder(MarshallingType.SDK_POJO).memberName("NamespaceError")
            .getter(getter(NamespaceInfoV2::namespaceError)).setter(setter(Builder::namespaceError))
            .constructor(NamespaceError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamespaceError").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            CAPACITY_REGION_FIELD, CREATION_STATUS_FIELD, IDENTITY_STORE_FIELD, NAMESPACE_ERROR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final String capacityRegion;

    private final String creationStatus;

    private final String identityStore;

    private final NamespaceError namespaceError;

    private NamespaceInfoV2(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.capacityRegion = builder.capacityRegion;
        this.creationStatus = builder.creationStatus;
        this.identityStore = builder.identityStore;
        this.namespaceError = builder.namespaceError;
    }

    /**
     * <p>
     * The name of the error.
     * </p>
     * 
     * @return The name of the error.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The namespace ARN.
     * </p>
     * 
     * @return The namespace ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The namespace Amazon Web Services Region.
     * </p>
     * 
     * @return The namespace Amazon Web Services Region.
     */
    public final String capacityRegion() {
        return capacityRegion;
    }

    /**
     * <p>
     * The creation status of a namespace that is not yet completely created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #creationStatus}
     * will return {@link NamespaceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #creationStatusAsString}.
     * </p>
     * 
     * @return The creation status of a namespace that is not yet completely created.
     * @see NamespaceStatus
     */
    public final NamespaceStatus creationStatus() {
        return NamespaceStatus.fromValue(creationStatus);
    }

    /**
     * <p>
     * The creation status of a namespace that is not yet completely created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #creationStatus}
     * will return {@link NamespaceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #creationStatusAsString}.
     * </p>
     * 
     * @return The creation status of a namespace that is not yet completely created.
     * @see NamespaceStatus
     */
    public final String creationStatusAsString() {
        return creationStatus;
    }

    /**
     * <p>
     * The identity store used for the namespace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityStore}
     * will return {@link IdentityStore#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityStoreAsString}.
     * </p>
     * 
     * @return The identity store used for the namespace.
     * @see IdentityStore
     */
    public final IdentityStore identityStore() {
        return IdentityStore.fromValue(identityStore);
    }

    /**
     * <p>
     * The identity store used for the namespace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityStore}
     * will return {@link IdentityStore#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityStoreAsString}.
     * </p>
     * 
     * @return The identity store used for the namespace.
     * @see IdentityStore
     */
    public final String identityStoreAsString() {
        return identityStore;
    }

    /**
     * <p>
     * An error that occurred when the namespace was created.
     * </p>
     * 
     * @return An error that occurred when the namespace was created.
     */
    public final NamespaceError namespaceError() {
        return namespaceError;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(capacityRegion());
        hashCode = 31 * hashCode + Objects.hashCode(creationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identityStoreAsString());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceError());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NamespaceInfoV2)) {
            return false;
        }
        NamespaceInfoV2 other = (NamespaceInfoV2) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(capacityRegion(), other.capacityRegion())
                && Objects.equals(creationStatusAsString(), other.creationStatusAsString())
                && Objects.equals(identityStoreAsString(), other.identityStoreAsString())
                && Objects.equals(namespaceError(), other.namespaceError());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NamespaceInfoV2").add("Name", name()).add("Arn", arn()).add("CapacityRegion", capacityRegion())
                .add("CreationStatus", creationStatusAsString()).add("IdentityStore", identityStoreAsString())
                .add("NamespaceError", namespaceError()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CapacityRegion":
            return Optional.ofNullable(clazz.cast(capacityRegion()));
        case "CreationStatus":
            return Optional.ofNullable(clazz.cast(creationStatusAsString()));
        case "IdentityStore":
            return Optional.ofNullable(clazz.cast(identityStoreAsString()));
        case "NamespaceError":
            return Optional.ofNullable(clazz.cast(namespaceError()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NamespaceInfoV2, T> g) {
        return obj -> g.apply((NamespaceInfoV2) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NamespaceInfoV2> {
        /**
         * <p>
         * The name of the error.
         * </p>
         * 
         * @param name
         *        The name of the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The namespace ARN.
         * </p>
         * 
         * @param arn
         *        The namespace ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The namespace Amazon Web Services Region.
         * </p>
         * 
         * @param capacityRegion
         *        The namespace Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityRegion(String capacityRegion);

        /**
         * <p>
         * The creation status of a namespace that is not yet completely created.
         * </p>
         * 
         * @param creationStatus
         *        The creation status of a namespace that is not yet completely created.
         * @see NamespaceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NamespaceStatus
         */
        Builder creationStatus(String creationStatus);

        /**
         * <p>
         * The creation status of a namespace that is not yet completely created.
         * </p>
         * 
         * @param creationStatus
         *        The creation status of a namespace that is not yet completely created.
         * @see NamespaceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NamespaceStatus
         */
        Builder creationStatus(NamespaceStatus creationStatus);

        /**
         * <p>
         * The identity store used for the namespace.
         * </p>
         * 
         * @param identityStore
         *        The identity store used for the namespace.
         * @see IdentityStore
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityStore
         */
        Builder identityStore(String identityStore);

        /**
         * <p>
         * The identity store used for the namespace.
         * </p>
         * 
         * @param identityStore
         *        The identity store used for the namespace.
         * @see IdentityStore
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityStore
         */
        Builder identityStore(IdentityStore identityStore);

        /**
         * <p>
         * An error that occurred when the namespace was created.
         * </p>
         * 
         * @param namespaceError
         *        An error that occurred when the namespace was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceError(NamespaceError namespaceError);

        /**
         * <p>
         * An error that occurred when the namespace was created.
         * </p>
         * This is a convenience method that creates an instance of the {@link NamespaceError.Builder} avoiding the need
         * to create one manually via {@link NamespaceError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NamespaceError.Builder#build()} is called immediately and its
         * result is passed to {@link #namespaceError(NamespaceError)}.
         * 
         * @param namespaceError
         *        a consumer that will call methods on {@link NamespaceError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #namespaceError(NamespaceError)
         */
        default Builder namespaceError(Consumer<NamespaceError.Builder> namespaceError) {
            return namespaceError(NamespaceError.builder().applyMutation(namespaceError).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String capacityRegion;

        private String creationStatus;

        private String identityStore;

        private NamespaceError namespaceError;

        private BuilderImpl() {
        }

        private BuilderImpl(NamespaceInfoV2 model) {
            name(model.name);
            arn(model.arn);
            capacityRegion(model.capacityRegion);
            creationStatus(model.creationStatus);
            identityStore(model.identityStore);
            namespaceError(model.namespaceError);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCapacityRegion() {
            return capacityRegion;
        }

        public final void setCapacityRegion(String capacityRegion) {
            this.capacityRegion = capacityRegion;
        }

        @Override
        public final Builder capacityRegion(String capacityRegion) {
            this.capacityRegion = capacityRegion;
            return this;
        }

        public final String getCreationStatus() {
            return creationStatus;
        }

        public final void setCreationStatus(String creationStatus) {
            this.creationStatus = creationStatus;
        }

        @Override
        public final Builder creationStatus(String creationStatus) {
            this.creationStatus = creationStatus;
            return this;
        }

        @Override
        public final Builder creationStatus(NamespaceStatus creationStatus) {
            this.creationStatus(creationStatus == null ? null : creationStatus.toString());
            return this;
        }

        public final String getIdentityStore() {
            return identityStore;
        }

        public final void setIdentityStore(String identityStore) {
            this.identityStore = identityStore;
        }

        @Override
        public final Builder identityStore(String identityStore) {
            this.identityStore = identityStore;
            return this;
        }

        @Override
        public final Builder identityStore(IdentityStore identityStore) {
            this.identityStore(identityStore == null ? null : identityStore.toString());
            return this;
        }

        public final NamespaceError.Builder getNamespaceError() {
            return namespaceError != null ? namespaceError.toBuilder() : null;
        }

        public final void setNamespaceError(NamespaceError.BuilderImpl namespaceError) {
            this.namespaceError = namespaceError != null ? namespaceError.build() : null;
        }

        @Override
        public final Builder namespaceError(NamespaceError namespaceError) {
            this.namespaceError = namespaceError;
            return this;
        }

        @Override
        public NamespaceInfoV2 build() {
            return new NamespaceInfoV2(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
