/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.FieldSortOptions;
import software.amazon.awssdk.services.quicksight.model.FieldSortOptionsListCopier;
import software.amazon.awssdk.services.quicksight.model.ItemsLimitConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WaterfallChartSortConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WaterfallChartSortConfiguration> {
    private static final SdkField<List<FieldSortOptions>> CATEGORY_SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CategorySort").getter(WaterfallChartSortConfiguration.getter(WaterfallChartSortConfiguration::categorySort)).setter(WaterfallChartSortConfiguration.setter(Builder::categorySort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategorySort").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldSortOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ItemsLimitConfiguration> BREAKDOWN_ITEMS_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BreakdownItemsLimit").getter(WaterfallChartSortConfiguration.getter(WaterfallChartSortConfiguration::breakdownItemsLimit)).setter(WaterfallChartSortConfiguration.setter(Builder::breakdownItemsLimit)).constructor(ItemsLimitConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BreakdownItemsLimit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_SORT_FIELD, BREAKDOWN_ITEMS_LIMIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<FieldSortOptions> categorySort;
    private final ItemsLimitConfiguration breakdownItemsLimit;

    private WaterfallChartSortConfiguration(BuilderImpl builder) {
        this.categorySort = builder.categorySort;
        this.breakdownItemsLimit = builder.breakdownItemsLimit;
    }

    public final boolean hasCategorySort() {
        return this.categorySort != null && !(this.categorySort instanceof SdkAutoConstructList);
    }

    public final List<FieldSortOptions> categorySort() {
        return this.categorySort;
    }

    public final ItemsLimitConfiguration breakdownItemsLimit() {
        return this.breakdownItemsLimit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategorySort() ? this.categorySort() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.breakdownItemsLimit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaterfallChartSortConfiguration)) {
            return false;
        }
        WaterfallChartSortConfiguration other = (WaterfallChartSortConfiguration)obj;
        return this.hasCategorySort() == other.hasCategorySort() && Objects.equals(this.categorySort(), other.categorySort()) && Objects.equals(this.breakdownItemsLimit(), other.breakdownItemsLimit());
    }

    public final String toString() {
        return ToString.builder((String)"WaterfallChartSortConfiguration").add("CategorySort", this.hasCategorySort() ? this.categorySort() : null).add("BreakdownItemsLimit", (Object)this.breakdownItemsLimit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CategorySort": {
                return Optional.ofNullable(clazz.cast(this.categorySort()));
            }
            case "BreakdownItemsLimit": {
                return Optional.ofNullable(clazz.cast(this.breakdownItemsLimit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WaterfallChartSortConfiguration, T> g) {
        return obj -> g.apply((WaterfallChartSortConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<FieldSortOptions> categorySort = DefaultSdkAutoConstructList.getInstance();
        private ItemsLimitConfiguration breakdownItemsLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(WaterfallChartSortConfiguration model) {
            this.categorySort(model.categorySort);
            this.breakdownItemsLimit(model.breakdownItemsLimit);
        }

        public final List<FieldSortOptions.Builder> getCategorySort() {
            List<FieldSortOptions.Builder> result = FieldSortOptionsListCopier.copyToBuilder(this.categorySort);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategorySort(Collection<FieldSortOptions.BuilderImpl> categorySort) {
            this.categorySort = FieldSortOptionsListCopier.copyFromBuilder(categorySort);
        }

        @Override
        public final Builder categorySort(Collection<FieldSortOptions> categorySort) {
            this.categorySort = FieldSortOptionsListCopier.copy(categorySort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categorySort(FieldSortOptions ... categorySort) {
            this.categorySort(Arrays.asList(categorySort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categorySort(Consumer<FieldSortOptions.Builder> ... categorySort) {
            this.categorySort(Stream.of(categorySort).map(c -> (FieldSortOptions)((FieldSortOptions.Builder)FieldSortOptions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ItemsLimitConfiguration.Builder getBreakdownItemsLimit() {
            return this.breakdownItemsLimit != null ? this.breakdownItemsLimit.toBuilder() : null;
        }

        public final void setBreakdownItemsLimit(ItemsLimitConfiguration.BuilderImpl breakdownItemsLimit) {
            this.breakdownItemsLimit = breakdownItemsLimit != null ? breakdownItemsLimit.build() : null;
        }

        @Override
        public final Builder breakdownItemsLimit(ItemsLimitConfiguration breakdownItemsLimit) {
            this.breakdownItemsLimit = breakdownItemsLimit;
            return this;
        }

        public WaterfallChartSortConfiguration build() {
            return new WaterfallChartSortConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WaterfallChartSortConfiguration> {
        public Builder categorySort(Collection<FieldSortOptions> var1);

        public Builder categorySort(FieldSortOptions ... var1);

        public Builder categorySort(Consumer<FieldSortOptions.Builder> ... var1);

        public Builder breakdownItemsLimit(ItemsLimitConfiguration var1);

        default public Builder breakdownItemsLimit(Consumer<ItemsLimitConfiguration.Builder> breakdownItemsLimit) {
            return this.breakdownItemsLimit((ItemsLimitConfiguration)((ItemsLimitConfiguration.Builder)ItemsLimitConfiguration.builder().applyMutation(breakdownItemsLimit)).build());
        }
    }
}

