/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTemplateDefinitionRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, DescribeTemplateDefinitionRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(DescribeTemplateDefinitionRequest.getter(DescribeTemplateDefinitionRequest::awsAccountId)).setter(DescribeTemplateDefinitionRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateId").getter(DescribeTemplateDefinitionRequest.getter(DescribeTemplateDefinitionRequest::templateId)).setter(DescribeTemplateDefinitionRequest.setter(Builder::templateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("TemplateId").build()}).build();
    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("VersionNumber").getter(DescribeTemplateDefinitionRequest.getter(DescribeTemplateDefinitionRequest::versionNumber)).setter(DescribeTemplateDefinitionRequest.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("version-number").build()}).build();
    private static final SdkField<String> ALIAS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AliasName").getter(DescribeTemplateDefinitionRequest.getter(DescribeTemplateDefinitionRequest::aliasName)).setter(DescribeTemplateDefinitionRequest.setter(Builder::aliasName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("alias-name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, TEMPLATE_ID_FIELD, VERSION_NUMBER_FIELD, ALIAS_NAME_FIELD));
    private final String awsAccountId;
    private final String templateId;
    private final Long versionNumber;
    private final String aliasName;

    private DescribeTemplateDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.templateId = builder.templateId;
        this.versionNumber = builder.versionNumber;
        this.aliasName = builder.aliasName;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String templateId() {
        return this.templateId;
    }

    public final Long versionNumber() {
        return this.versionNumber;
    }

    public final String aliasName() {
        return this.aliasName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTemplateDefinitionRequest)) {
            return false;
        }
        DescribeTemplateDefinitionRequest other = (DescribeTemplateDefinitionRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.templateId(), other.templateId()) && Objects.equals(this.versionNumber(), other.versionNumber()) && Objects.equals(this.aliasName(), other.aliasName());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTemplateDefinitionRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("TemplateId", (Object)this.templateId()).add("VersionNumber", (Object)this.versionNumber()).add("AliasName", (Object)this.aliasName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "TemplateId": {
                return Optional.ofNullable(clazz.cast(this.templateId()));
            }
            case "VersionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
            case "AliasName": {
                return Optional.ofNullable(clazz.cast(this.aliasName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTemplateDefinitionRequest, T> g) {
        return obj -> g.apply((DescribeTemplateDefinitionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String templateId;
        private Long versionNumber;
        private String aliasName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTemplateDefinitionRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.templateId(model.templateId);
            this.versionNumber(model.versionNumber);
            this.aliasName(model.aliasName);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getTemplateId() {
            return this.templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final Long getVersionNumber() {
            return this.versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final String getAliasName() {
            return this.aliasName;
        }

        public final void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        @Override
        public final Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTemplateDefinitionRequest build() {
            return new DescribeTemplateDefinitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTemplateDefinitionRequest> {
        public Builder awsAccountId(String var1);

        public Builder templateId(String var1);

        public Builder versionNumber(Long var1);

        public Builder aliasName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

