/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DefaultInteractiveLayoutConfiguration;
import software.amazon.awssdk.services.quicksight.model.DefaultPaginatedLayoutConfiguration;
import software.amazon.awssdk.services.quicksight.model.SheetContentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DefaultNewSheetConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DefaultNewSheetConfiguration> {
    private static final SdkField<DefaultInteractiveLayoutConfiguration> INTERACTIVE_LAYOUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InteractiveLayoutConfiguration").getter(DefaultNewSheetConfiguration.getter(DefaultNewSheetConfiguration::interactiveLayoutConfiguration)).setter(DefaultNewSheetConfiguration.setter(Builder::interactiveLayoutConfiguration)).constructor(DefaultInteractiveLayoutConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InteractiveLayoutConfiguration").build()}).build();
    private static final SdkField<DefaultPaginatedLayoutConfiguration> PAGINATED_LAYOUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PaginatedLayoutConfiguration").getter(DefaultNewSheetConfiguration.getter(DefaultNewSheetConfiguration::paginatedLayoutConfiguration)).setter(DefaultNewSheetConfiguration.setter(Builder::paginatedLayoutConfiguration)).constructor(DefaultPaginatedLayoutConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginatedLayoutConfiguration").build()}).build();
    private static final SdkField<String> SHEET_CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SheetContentType").getter(DefaultNewSheetConfiguration.getter(DefaultNewSheetConfiguration::sheetContentTypeAsString)).setter(DefaultNewSheetConfiguration.setter(Builder::sheetContentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetContentType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERACTIVE_LAYOUT_CONFIGURATION_FIELD, PAGINATED_LAYOUT_CONFIGURATION_FIELD, SHEET_CONTENT_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final DefaultInteractiveLayoutConfiguration interactiveLayoutConfiguration;
    private final DefaultPaginatedLayoutConfiguration paginatedLayoutConfiguration;
    private final String sheetContentType;

    private DefaultNewSheetConfiguration(BuilderImpl builder) {
        this.interactiveLayoutConfiguration = builder.interactiveLayoutConfiguration;
        this.paginatedLayoutConfiguration = builder.paginatedLayoutConfiguration;
        this.sheetContentType = builder.sheetContentType;
    }

    public final DefaultInteractiveLayoutConfiguration interactiveLayoutConfiguration() {
        return this.interactiveLayoutConfiguration;
    }

    public final DefaultPaginatedLayoutConfiguration paginatedLayoutConfiguration() {
        return this.paginatedLayoutConfiguration;
    }

    public final SheetContentType sheetContentType() {
        return SheetContentType.fromValue(this.sheetContentType);
    }

    public final String sheetContentTypeAsString() {
        return this.sheetContentType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.interactiveLayoutConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.paginatedLayoutConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sheetContentTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultNewSheetConfiguration)) {
            return false;
        }
        DefaultNewSheetConfiguration other = (DefaultNewSheetConfiguration)obj;
        return Objects.equals(this.interactiveLayoutConfiguration(), other.interactiveLayoutConfiguration()) && Objects.equals(this.paginatedLayoutConfiguration(), other.paginatedLayoutConfiguration()) && Objects.equals(this.sheetContentTypeAsString(), other.sheetContentTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DefaultNewSheetConfiguration").add("InteractiveLayoutConfiguration", (Object)this.interactiveLayoutConfiguration()).add("PaginatedLayoutConfiguration", (Object)this.paginatedLayoutConfiguration()).add("SheetContentType", (Object)this.sheetContentTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InteractiveLayoutConfiguration": {
                return Optional.ofNullable(clazz.cast(this.interactiveLayoutConfiguration()));
            }
            case "PaginatedLayoutConfiguration": {
                return Optional.ofNullable(clazz.cast(this.paginatedLayoutConfiguration()));
            }
            case "SheetContentType": {
                return Optional.ofNullable(clazz.cast(this.sheetContentTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DefaultNewSheetConfiguration, T> g) {
        return obj -> g.apply((DefaultNewSheetConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DefaultInteractiveLayoutConfiguration interactiveLayoutConfiguration;
        private DefaultPaginatedLayoutConfiguration paginatedLayoutConfiguration;
        private String sheetContentType;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultNewSheetConfiguration model) {
            this.interactiveLayoutConfiguration(model.interactiveLayoutConfiguration);
            this.paginatedLayoutConfiguration(model.paginatedLayoutConfiguration);
            this.sheetContentType(model.sheetContentType);
        }

        public final DefaultInteractiveLayoutConfiguration.Builder getInteractiveLayoutConfiguration() {
            return this.interactiveLayoutConfiguration != null ? this.interactiveLayoutConfiguration.toBuilder() : null;
        }

        public final void setInteractiveLayoutConfiguration(DefaultInteractiveLayoutConfiguration.BuilderImpl interactiveLayoutConfiguration) {
            this.interactiveLayoutConfiguration = interactiveLayoutConfiguration != null ? interactiveLayoutConfiguration.build() : null;
        }

        @Override
        public final Builder interactiveLayoutConfiguration(DefaultInteractiveLayoutConfiguration interactiveLayoutConfiguration) {
            this.interactiveLayoutConfiguration = interactiveLayoutConfiguration;
            return this;
        }

        public final DefaultPaginatedLayoutConfiguration.Builder getPaginatedLayoutConfiguration() {
            return this.paginatedLayoutConfiguration != null ? this.paginatedLayoutConfiguration.toBuilder() : null;
        }

        public final void setPaginatedLayoutConfiguration(DefaultPaginatedLayoutConfiguration.BuilderImpl paginatedLayoutConfiguration) {
            this.paginatedLayoutConfiguration = paginatedLayoutConfiguration != null ? paginatedLayoutConfiguration.build() : null;
        }

        @Override
        public final Builder paginatedLayoutConfiguration(DefaultPaginatedLayoutConfiguration paginatedLayoutConfiguration) {
            this.paginatedLayoutConfiguration = paginatedLayoutConfiguration;
            return this;
        }

        public final String getSheetContentType() {
            return this.sheetContentType;
        }

        public final void setSheetContentType(String sheetContentType) {
            this.sheetContentType = sheetContentType;
        }

        @Override
        public final Builder sheetContentType(String sheetContentType) {
            this.sheetContentType = sheetContentType;
            return this;
        }

        @Override
        public final Builder sheetContentType(SheetContentType sheetContentType) {
            this.sheetContentType(sheetContentType == null ? null : sheetContentType.toString());
            return this;
        }

        public DefaultNewSheetConfiguration build() {
            return new DefaultNewSheetConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DefaultNewSheetConfiguration> {
        public Builder interactiveLayoutConfiguration(DefaultInteractiveLayoutConfiguration var1);

        default public Builder interactiveLayoutConfiguration(Consumer<DefaultInteractiveLayoutConfiguration.Builder> interactiveLayoutConfiguration) {
            return this.interactiveLayoutConfiguration((DefaultInteractiveLayoutConfiguration)((DefaultInteractiveLayoutConfiguration.Builder)DefaultInteractiveLayoutConfiguration.builder().applyMutation(interactiveLayoutConfiguration)).build());
        }

        public Builder paginatedLayoutConfiguration(DefaultPaginatedLayoutConfiguration var1);

        default public Builder paginatedLayoutConfiguration(Consumer<DefaultPaginatedLayoutConfiguration.Builder> paginatedLayoutConfiguration) {
            return this.paginatedLayoutConfiguration((DefaultPaginatedLayoutConfiguration)((DefaultPaginatedLayoutConfiguration.Builder)DefaultPaginatedLayoutConfiguration.builder().applyMutation(paginatedLayoutConfiguration)).build());
        }

        public Builder sheetContentType(String var1);

        public Builder sheetContentType(SheetContentType var1);
    }
}

