/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AnalysisDefaults;
import software.amazon.awssdk.services.quicksight.model.CalculatedField;
import software.amazon.awssdk.services.quicksight.model.CalculatedFieldsCopier;
import software.amazon.awssdk.services.quicksight.model.ColumnConfiguration;
import software.amazon.awssdk.services.quicksight.model.ColumnConfigurationListCopier;
import software.amazon.awssdk.services.quicksight.model.DataSetIdentifierDeclaration;
import software.amazon.awssdk.services.quicksight.model.DataSetIdentifierDeclarationListCopier;
import software.amazon.awssdk.services.quicksight.model.FilterGroup;
import software.amazon.awssdk.services.quicksight.model.FilterGroupListCopier;
import software.amazon.awssdk.services.quicksight.model.ParameterDeclaration;
import software.amazon.awssdk.services.quicksight.model.ParameterDeclarationListCopier;
import software.amazon.awssdk.services.quicksight.model.SheetDefinition;
import software.amazon.awssdk.services.quicksight.model.SheetDefinitionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DashboardVersionDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DashboardVersionDefinition> {
    private static final SdkField<List<DataSetIdentifierDeclaration>> DATA_SET_IDENTIFIER_DECLARATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataSetIdentifierDeclarations").getter(DashboardVersionDefinition.getter(DashboardVersionDefinition::dataSetIdentifierDeclarations)).setter(DashboardVersionDefinition.setter(Builder::dataSetIdentifierDeclarations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetIdentifierDeclarations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSetIdentifierDeclaration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SheetDefinition>> SHEETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sheets").getter(DashboardVersionDefinition.getter(DashboardVersionDefinition::sheets)).setter(DashboardVersionDefinition.setter(Builder::sheets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sheets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SheetDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CalculatedField>> CALCULATED_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CalculatedFields").getter(DashboardVersionDefinition.getter(DashboardVersionDefinition::calculatedFields)).setter(DashboardVersionDefinition.setter(Builder::calculatedFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CalculatedField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ParameterDeclaration>> PARAMETER_DECLARATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ParameterDeclarations").getter(DashboardVersionDefinition.getter(DashboardVersionDefinition::parameterDeclarations)).setter(DashboardVersionDefinition.setter(Builder::parameterDeclarations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterDeclarations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterDeclaration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FilterGroup>> FILTER_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FilterGroups").getter(DashboardVersionDefinition.getter(DashboardVersionDefinition::filterGroups)).setter(DashboardVersionDefinition.setter(Builder::filterGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FilterGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ColumnConfiguration>> COLUMN_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnConfigurations").getter(DashboardVersionDefinition.getter(DashboardVersionDefinition::columnConfigurations)).setter(DashboardVersionDefinition.setter(Builder::columnConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AnalysisDefaults> ANALYSIS_DEFAULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnalysisDefaults").getter(DashboardVersionDefinition.getter(DashboardVersionDefinition::analysisDefaults)).setter(DashboardVersionDefinition.setter(Builder::analysisDefaults)).constructor(AnalysisDefaults::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisDefaults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_IDENTIFIER_DECLARATIONS_FIELD, SHEETS_FIELD, CALCULATED_FIELDS_FIELD, PARAMETER_DECLARATIONS_FIELD, FILTER_GROUPS_FIELD, COLUMN_CONFIGURATIONS_FIELD, ANALYSIS_DEFAULTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<DataSetIdentifierDeclaration> dataSetIdentifierDeclarations;
    private final List<SheetDefinition> sheets;
    private final List<CalculatedField> calculatedFields;
    private final List<ParameterDeclaration> parameterDeclarations;
    private final List<FilterGroup> filterGroups;
    private final List<ColumnConfiguration> columnConfigurations;
    private final AnalysisDefaults analysisDefaults;

    private DashboardVersionDefinition(BuilderImpl builder) {
        this.dataSetIdentifierDeclarations = builder.dataSetIdentifierDeclarations;
        this.sheets = builder.sheets;
        this.calculatedFields = builder.calculatedFields;
        this.parameterDeclarations = builder.parameterDeclarations;
        this.filterGroups = builder.filterGroups;
        this.columnConfigurations = builder.columnConfigurations;
        this.analysisDefaults = builder.analysisDefaults;
    }

    public final boolean hasDataSetIdentifierDeclarations() {
        return this.dataSetIdentifierDeclarations != null && !(this.dataSetIdentifierDeclarations instanceof SdkAutoConstructList);
    }

    public final List<DataSetIdentifierDeclaration> dataSetIdentifierDeclarations() {
        return this.dataSetIdentifierDeclarations;
    }

    public final boolean hasSheets() {
        return this.sheets != null && !(this.sheets instanceof SdkAutoConstructList);
    }

    public final List<SheetDefinition> sheets() {
        return this.sheets;
    }

    public final boolean hasCalculatedFields() {
        return this.calculatedFields != null && !(this.calculatedFields instanceof SdkAutoConstructList);
    }

    public final List<CalculatedField> calculatedFields() {
        return this.calculatedFields;
    }

    public final boolean hasParameterDeclarations() {
        return this.parameterDeclarations != null && !(this.parameterDeclarations instanceof SdkAutoConstructList);
    }

    public final List<ParameterDeclaration> parameterDeclarations() {
        return this.parameterDeclarations;
    }

    public final boolean hasFilterGroups() {
        return this.filterGroups != null && !(this.filterGroups instanceof SdkAutoConstructList);
    }

    public final List<FilterGroup> filterGroups() {
        return this.filterGroups;
    }

    public final boolean hasColumnConfigurations() {
        return this.columnConfigurations != null && !(this.columnConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ColumnConfiguration> columnConfigurations() {
        return this.columnConfigurations;
    }

    public final AnalysisDefaults analysisDefaults() {
        return this.analysisDefaults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataSetIdentifierDeclarations() ? this.dataSetIdentifierDeclarations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSheets() ? this.sheets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCalculatedFields() ? this.calculatedFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameterDeclarations() ? this.parameterDeclarations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterGroups() ? this.filterGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnConfigurations() ? this.columnConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisDefaults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashboardVersionDefinition)) {
            return false;
        }
        DashboardVersionDefinition other = (DashboardVersionDefinition)obj;
        return this.hasDataSetIdentifierDeclarations() == other.hasDataSetIdentifierDeclarations() && Objects.equals(this.dataSetIdentifierDeclarations(), other.dataSetIdentifierDeclarations()) && this.hasSheets() == other.hasSheets() && Objects.equals(this.sheets(), other.sheets()) && this.hasCalculatedFields() == other.hasCalculatedFields() && Objects.equals(this.calculatedFields(), other.calculatedFields()) && this.hasParameterDeclarations() == other.hasParameterDeclarations() && Objects.equals(this.parameterDeclarations(), other.parameterDeclarations()) && this.hasFilterGroups() == other.hasFilterGroups() && Objects.equals(this.filterGroups(), other.filterGroups()) && this.hasColumnConfigurations() == other.hasColumnConfigurations() && Objects.equals(this.columnConfigurations(), other.columnConfigurations()) && Objects.equals(this.analysisDefaults(), other.analysisDefaults());
    }

    public final String toString() {
        return ToString.builder((String)"DashboardVersionDefinition").add("DataSetIdentifierDeclarations", this.hasDataSetIdentifierDeclarations() ? this.dataSetIdentifierDeclarations() : null).add("Sheets", this.hasSheets() ? this.sheets() : null).add("CalculatedFields", this.hasCalculatedFields() ? this.calculatedFields() : null).add("ParameterDeclarations", this.hasParameterDeclarations() ? this.parameterDeclarations() : null).add("FilterGroups", this.hasFilterGroups() ? this.filterGroups() : null).add("ColumnConfigurations", this.hasColumnConfigurations() ? this.columnConfigurations() : null).add("AnalysisDefaults", (Object)this.analysisDefaults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSetIdentifierDeclarations": {
                return Optional.ofNullable(clazz.cast(this.dataSetIdentifierDeclarations()));
            }
            case "Sheets": {
                return Optional.ofNullable(clazz.cast(this.sheets()));
            }
            case "CalculatedFields": {
                return Optional.ofNullable(clazz.cast(this.calculatedFields()));
            }
            case "ParameterDeclarations": {
                return Optional.ofNullable(clazz.cast(this.parameterDeclarations()));
            }
            case "FilterGroups": {
                return Optional.ofNullable(clazz.cast(this.filterGroups()));
            }
            case "ColumnConfigurations": {
                return Optional.ofNullable(clazz.cast(this.columnConfigurations()));
            }
            case "AnalysisDefaults": {
                return Optional.ofNullable(clazz.cast(this.analysisDefaults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashboardVersionDefinition, T> g) {
        return obj -> g.apply((DashboardVersionDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DataSetIdentifierDeclaration> dataSetIdentifierDeclarations = DefaultSdkAutoConstructList.getInstance();
        private List<SheetDefinition> sheets = DefaultSdkAutoConstructList.getInstance();
        private List<CalculatedField> calculatedFields = DefaultSdkAutoConstructList.getInstance();
        private List<ParameterDeclaration> parameterDeclarations = DefaultSdkAutoConstructList.getInstance();
        private List<FilterGroup> filterGroups = DefaultSdkAutoConstructList.getInstance();
        private List<ColumnConfiguration> columnConfigurations = DefaultSdkAutoConstructList.getInstance();
        private AnalysisDefaults analysisDefaults;

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardVersionDefinition model) {
            this.dataSetIdentifierDeclarations(model.dataSetIdentifierDeclarations);
            this.sheets(model.sheets);
            this.calculatedFields(model.calculatedFields);
            this.parameterDeclarations(model.parameterDeclarations);
            this.filterGroups(model.filterGroups);
            this.columnConfigurations(model.columnConfigurations);
            this.analysisDefaults(model.analysisDefaults);
        }

        public final List<DataSetIdentifierDeclaration.Builder> getDataSetIdentifierDeclarations() {
            List<DataSetIdentifierDeclaration.Builder> result = DataSetIdentifierDeclarationListCopier.copyToBuilder(this.dataSetIdentifierDeclarations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSetIdentifierDeclarations(Collection<DataSetIdentifierDeclaration.BuilderImpl> dataSetIdentifierDeclarations) {
            this.dataSetIdentifierDeclarations = DataSetIdentifierDeclarationListCopier.copyFromBuilder(dataSetIdentifierDeclarations);
        }

        @Override
        public final Builder dataSetIdentifierDeclarations(Collection<DataSetIdentifierDeclaration> dataSetIdentifierDeclarations) {
            this.dataSetIdentifierDeclarations = DataSetIdentifierDeclarationListCopier.copy(dataSetIdentifierDeclarations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetIdentifierDeclarations(DataSetIdentifierDeclaration ... dataSetIdentifierDeclarations) {
            this.dataSetIdentifierDeclarations(Arrays.asList(dataSetIdentifierDeclarations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetIdentifierDeclarations(Consumer<DataSetIdentifierDeclaration.Builder> ... dataSetIdentifierDeclarations) {
            this.dataSetIdentifierDeclarations(Stream.of(dataSetIdentifierDeclarations).map(c -> (DataSetIdentifierDeclaration)((DataSetIdentifierDeclaration.Builder)DataSetIdentifierDeclaration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SheetDefinition.Builder> getSheets() {
            List<SheetDefinition.Builder> result = SheetDefinitionListCopier.copyToBuilder(this.sheets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSheets(Collection<SheetDefinition.BuilderImpl> sheets) {
            this.sheets = SheetDefinitionListCopier.copyFromBuilder(sheets);
        }

        @Override
        public final Builder sheets(Collection<SheetDefinition> sheets) {
            this.sheets = SheetDefinitionListCopier.copy(sheets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sheets(SheetDefinition ... sheets) {
            this.sheets(Arrays.asList(sheets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sheets(Consumer<SheetDefinition.Builder> ... sheets) {
            this.sheets(Stream.of(sheets).map(c -> (SheetDefinition)((SheetDefinition.Builder)SheetDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CalculatedField.Builder> getCalculatedFields() {
            List<CalculatedField.Builder> result = CalculatedFieldsCopier.copyToBuilder(this.calculatedFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCalculatedFields(Collection<CalculatedField.BuilderImpl> calculatedFields) {
            this.calculatedFields = CalculatedFieldsCopier.copyFromBuilder(calculatedFields);
        }

        @Override
        public final Builder calculatedFields(Collection<CalculatedField> calculatedFields) {
            this.calculatedFields = CalculatedFieldsCopier.copy(calculatedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calculatedFields(CalculatedField ... calculatedFields) {
            this.calculatedFields(Arrays.asList(calculatedFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calculatedFields(Consumer<CalculatedField.Builder> ... calculatedFields) {
            this.calculatedFields(Stream.of(calculatedFields).map(c -> (CalculatedField)((CalculatedField.Builder)CalculatedField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ParameterDeclaration.Builder> getParameterDeclarations() {
            List<ParameterDeclaration.Builder> result = ParameterDeclarationListCopier.copyToBuilder(this.parameterDeclarations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameterDeclarations(Collection<ParameterDeclaration.BuilderImpl> parameterDeclarations) {
            this.parameterDeclarations = ParameterDeclarationListCopier.copyFromBuilder(parameterDeclarations);
        }

        @Override
        public final Builder parameterDeclarations(Collection<ParameterDeclaration> parameterDeclarations) {
            this.parameterDeclarations = ParameterDeclarationListCopier.copy(parameterDeclarations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterDeclarations(ParameterDeclaration ... parameterDeclarations) {
            this.parameterDeclarations(Arrays.asList(parameterDeclarations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterDeclarations(Consumer<ParameterDeclaration.Builder> ... parameterDeclarations) {
            this.parameterDeclarations(Stream.of(parameterDeclarations).map(c -> (ParameterDeclaration)((ParameterDeclaration.Builder)ParameterDeclaration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FilterGroup.Builder> getFilterGroups() {
            List<FilterGroup.Builder> result = FilterGroupListCopier.copyToBuilder(this.filterGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilterGroups(Collection<FilterGroup.BuilderImpl> filterGroups) {
            this.filterGroups = FilterGroupListCopier.copyFromBuilder(filterGroups);
        }

        @Override
        public final Builder filterGroups(Collection<FilterGroup> filterGroups) {
            this.filterGroups = FilterGroupListCopier.copy(filterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterGroups(FilterGroup ... filterGroups) {
            this.filterGroups(Arrays.asList(filterGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterGroups(Consumer<FilterGroup.Builder> ... filterGroups) {
            this.filterGroups(Stream.of(filterGroups).map(c -> (FilterGroup)((FilterGroup.Builder)FilterGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ColumnConfiguration.Builder> getColumnConfigurations() {
            List<ColumnConfiguration.Builder> result = ColumnConfigurationListCopier.copyToBuilder(this.columnConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnConfigurations(Collection<ColumnConfiguration.BuilderImpl> columnConfigurations) {
            this.columnConfigurations = ColumnConfigurationListCopier.copyFromBuilder(columnConfigurations);
        }

        @Override
        public final Builder columnConfigurations(Collection<ColumnConfiguration> columnConfigurations) {
            this.columnConfigurations = ColumnConfigurationListCopier.copy(columnConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnConfigurations(ColumnConfiguration ... columnConfigurations) {
            this.columnConfigurations(Arrays.asList(columnConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnConfigurations(Consumer<ColumnConfiguration.Builder> ... columnConfigurations) {
            this.columnConfigurations(Stream.of(columnConfigurations).map(c -> (ColumnConfiguration)((ColumnConfiguration.Builder)ColumnConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AnalysisDefaults.Builder getAnalysisDefaults() {
            return this.analysisDefaults != null ? this.analysisDefaults.toBuilder() : null;
        }

        public final void setAnalysisDefaults(AnalysisDefaults.BuilderImpl analysisDefaults) {
            this.analysisDefaults = analysisDefaults != null ? analysisDefaults.build() : null;
        }

        @Override
        public final Builder analysisDefaults(AnalysisDefaults analysisDefaults) {
            this.analysisDefaults = analysisDefaults;
            return this;
        }

        public DashboardVersionDefinition build() {
            return new DashboardVersionDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DashboardVersionDefinition> {
        public Builder dataSetIdentifierDeclarations(Collection<DataSetIdentifierDeclaration> var1);

        public Builder dataSetIdentifierDeclarations(DataSetIdentifierDeclaration ... var1);

        public Builder dataSetIdentifierDeclarations(Consumer<DataSetIdentifierDeclaration.Builder> ... var1);

        public Builder sheets(Collection<SheetDefinition> var1);

        public Builder sheets(SheetDefinition ... var1);

        public Builder sheets(Consumer<SheetDefinition.Builder> ... var1);

        public Builder calculatedFields(Collection<CalculatedField> var1);

        public Builder calculatedFields(CalculatedField ... var1);

        public Builder calculatedFields(Consumer<CalculatedField.Builder> ... var1);

        public Builder parameterDeclarations(Collection<ParameterDeclaration> var1);

        public Builder parameterDeclarations(ParameterDeclaration ... var1);

        public Builder parameterDeclarations(Consumer<ParameterDeclaration.Builder> ... var1);

        public Builder filterGroups(Collection<FilterGroup> var1);

        public Builder filterGroups(FilterGroup ... var1);

        public Builder filterGroups(Consumer<FilterGroup.Builder> ... var1);

        public Builder columnConfigurations(Collection<ColumnConfiguration> var1);

        public Builder columnConfigurations(ColumnConfiguration ... var1);

        public Builder columnConfigurations(Consumer<ColumnConfiguration.Builder> ... var1);

        public Builder analysisDefaults(AnalysisDefaults var1);

        default public Builder analysisDefaults(Consumer<AnalysisDefaults.Builder> analysisDefaults) {
            return this.analysisDefaults((AnalysisDefaults)((AnalysisDefaults.Builder)AnalysisDefaults.builder().applyMutation(analysisDefaults)).build());
        }
    }
}

