/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CustomContentType {
    IMAGE("IMAGE"),
    OTHER_EMBEDDED_CONTENT("OTHER_EMBEDDED_CONTENT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CustomContentType> VALUE_MAP;
    private final String value;

    private CustomContentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CustomContentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CustomContentType> knownValues() {
        EnumSet<CustomContentType> knownValues = EnumSet.allOf(CustomContentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CustomContentType.class, CustomContentType::toString);
    }
}

