/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.ActiveIAMPolicyAssignment;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsForUserRequest;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsForUserResponse;

public class ListIAMPolicyAssignmentsForUserIterable
implements SdkIterable<ListIamPolicyAssignmentsForUserResponse> {
    private final QuickSightClient client;
    private final ListIamPolicyAssignmentsForUserRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIAMPolicyAssignmentsForUserIterable(QuickSightClient client, ListIamPolicyAssignmentsForUserRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListIamPolicyAssignmentsForUserResponseFetcher();
    }

    public Iterator<ListIamPolicyAssignmentsForUserResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ActiveIAMPolicyAssignment> activeAssignments() {
        Function<ListIamPolicyAssignmentsForUserResponse, Iterator> getIterator = response -> {
            if (response != null && response.activeAssignments() != null) {
                return response.activeAssignments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListIamPolicyAssignmentsForUserResponseFetcher
    implements SyncPageFetcher<ListIamPolicyAssignmentsForUserResponse> {
        private ListIamPolicyAssignmentsForUserResponseFetcher() {
        }

        public boolean hasNextPage(ListIamPolicyAssignmentsForUserResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIamPolicyAssignmentsForUserResponse nextPage(ListIamPolicyAssignmentsForUserResponse previousPage) {
            if (previousPage == null) {
                return ListIAMPolicyAssignmentsForUserIterable.this.client.listIAMPolicyAssignmentsForUser(ListIAMPolicyAssignmentsForUserIterable.this.firstRequest);
            }
            return ListIAMPolicyAssignmentsForUserIterable.this.client.listIAMPolicyAssignmentsForUser((ListIamPolicyAssignmentsForUserRequest)((Object)ListIAMPolicyAssignmentsForUserIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

