/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StyledCellType {
    TOTAL("TOTAL"),
    METRIC_HEADER("METRIC_HEADER"),
    VALUE("VALUE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StyledCellType> VALUE_MAP;
    private final String value;

    private StyledCellType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StyledCellType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StyledCellType> knownValues() {
        EnumSet<StyledCellType> knownValues = EnumSet.allOf(StyledCellType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StyledCellType.class, StyledCellType::toString);
    }
}

