/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.CategoryDrillDownFilter;
import software.amazon.awssdk.services.quicksight.model.NumericEqualityDrillDownFilter;
import software.amazon.awssdk.services.quicksight.model.TimeRangeDrillDownFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DrillDownFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DrillDownFilter> {
    private static final SdkField<NumericEqualityDrillDownFilter> NUMERIC_EQUALITY_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NumericEqualityFilter").getter(DrillDownFilter.getter(DrillDownFilter::numericEqualityFilter)).setter(DrillDownFilter.setter(Builder::numericEqualityFilter)).constructor(NumericEqualityDrillDownFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumericEqualityFilter").build()}).build();
    private static final SdkField<CategoryDrillDownFilter> CATEGORY_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CategoryFilter").getter(DrillDownFilter.getter(DrillDownFilter::categoryFilter)).setter(DrillDownFilter.setter(Builder::categoryFilter)).constructor(CategoryDrillDownFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryFilter").build()}).build();
    private static final SdkField<TimeRangeDrillDownFilter> TIME_RANGE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeRangeFilter").getter(DrillDownFilter.getter(DrillDownFilter::timeRangeFilter)).setter(DrillDownFilter.setter(Builder::timeRangeFilter)).constructor(TimeRangeDrillDownFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRangeFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMERIC_EQUALITY_FILTER_FIELD, CATEGORY_FILTER_FIELD, TIME_RANGE_FILTER_FIELD));
    private static final long serialVersionUID = 1L;
    private final NumericEqualityDrillDownFilter numericEqualityFilter;
    private final CategoryDrillDownFilter categoryFilter;
    private final TimeRangeDrillDownFilter timeRangeFilter;

    private DrillDownFilter(BuilderImpl builder) {
        this.numericEqualityFilter = builder.numericEqualityFilter;
        this.categoryFilter = builder.categoryFilter;
        this.timeRangeFilter = builder.timeRangeFilter;
    }

    public final NumericEqualityDrillDownFilter numericEqualityFilter() {
        return this.numericEqualityFilter;
    }

    public final CategoryDrillDownFilter categoryFilter() {
        return this.categoryFilter;
    }

    public final TimeRangeDrillDownFilter timeRangeFilter() {
        return this.timeRangeFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numericEqualityFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeRangeFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DrillDownFilter)) {
            return false;
        }
        DrillDownFilter other = (DrillDownFilter)obj;
        return Objects.equals(this.numericEqualityFilter(), other.numericEqualityFilter()) && Objects.equals(this.categoryFilter(), other.categoryFilter()) && Objects.equals(this.timeRangeFilter(), other.timeRangeFilter());
    }

    public final String toString() {
        return ToString.builder((String)"DrillDownFilter").add("NumericEqualityFilter", (Object)this.numericEqualityFilter()).add("CategoryFilter", (Object)this.categoryFilter()).add("TimeRangeFilter", (Object)this.timeRangeFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NumericEqualityFilter": {
                return Optional.ofNullable(clazz.cast(this.numericEqualityFilter()));
            }
            case "CategoryFilter": {
                return Optional.ofNullable(clazz.cast(this.categoryFilter()));
            }
            case "TimeRangeFilter": {
                return Optional.ofNullable(clazz.cast(this.timeRangeFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DrillDownFilter, T> g) {
        return obj -> g.apply((DrillDownFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private NumericEqualityDrillDownFilter numericEqualityFilter;
        private CategoryDrillDownFilter categoryFilter;
        private TimeRangeDrillDownFilter timeRangeFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(DrillDownFilter model) {
            this.numericEqualityFilter(model.numericEqualityFilter);
            this.categoryFilter(model.categoryFilter);
            this.timeRangeFilter(model.timeRangeFilter);
        }

        public final NumericEqualityDrillDownFilter.Builder getNumericEqualityFilter() {
            return this.numericEqualityFilter != null ? this.numericEqualityFilter.toBuilder() : null;
        }

        public final void setNumericEqualityFilter(NumericEqualityDrillDownFilter.BuilderImpl numericEqualityFilter) {
            this.numericEqualityFilter = numericEqualityFilter != null ? numericEqualityFilter.build() : null;
        }

        @Override
        public final Builder numericEqualityFilter(NumericEqualityDrillDownFilter numericEqualityFilter) {
            this.numericEqualityFilter = numericEqualityFilter;
            return this;
        }

        public final CategoryDrillDownFilter.Builder getCategoryFilter() {
            return this.categoryFilter != null ? this.categoryFilter.toBuilder() : null;
        }

        public final void setCategoryFilter(CategoryDrillDownFilter.BuilderImpl categoryFilter) {
            this.categoryFilter = categoryFilter != null ? categoryFilter.build() : null;
        }

        @Override
        public final Builder categoryFilter(CategoryDrillDownFilter categoryFilter) {
            this.categoryFilter = categoryFilter;
            return this;
        }

        public final TimeRangeDrillDownFilter.Builder getTimeRangeFilter() {
            return this.timeRangeFilter != null ? this.timeRangeFilter.toBuilder() : null;
        }

        public final void setTimeRangeFilter(TimeRangeDrillDownFilter.BuilderImpl timeRangeFilter) {
            this.timeRangeFilter = timeRangeFilter != null ? timeRangeFilter.build() : null;
        }

        @Override
        public final Builder timeRangeFilter(TimeRangeDrillDownFilter timeRangeFilter) {
            this.timeRangeFilter = timeRangeFilter;
            return this;
        }

        public DrillDownFilter build() {
            return new DrillDownFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DrillDownFilter> {
        public Builder numericEqualityFilter(NumericEqualityDrillDownFilter var1);

        default public Builder numericEqualityFilter(Consumer<NumericEqualityDrillDownFilter.Builder> numericEqualityFilter) {
            return this.numericEqualityFilter((NumericEqualityDrillDownFilter)((NumericEqualityDrillDownFilter.Builder)NumericEqualityDrillDownFilter.builder().applyMutation(numericEqualityFilter)).build());
        }

        public Builder categoryFilter(CategoryDrillDownFilter var1);

        default public Builder categoryFilter(Consumer<CategoryDrillDownFilter.Builder> categoryFilter) {
            return this.categoryFilter((CategoryDrillDownFilter)((CategoryDrillDownFilter.Builder)CategoryDrillDownFilter.builder().applyMutation(categoryFilter)).build());
        }

        public Builder timeRangeFilter(TimeRangeDrillDownFilter var1);

        default public Builder timeRangeFilter(Consumer<TimeRangeDrillDownFilter.Builder> timeRangeFilter) {
            return this.timeRangeFilter((TimeRangeDrillDownFilter)((TimeRangeDrillDownFilter.Builder)TimeRangeDrillDownFilter.builder().applyMutation(timeRangeFilter)).build());
        }
    }
}

