/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.FolderSummary;
import software.amazon.awssdk.services.quicksight.model.FolderSummaryListCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFoldersResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, ListFoldersResponse> {
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(ListFoldersResponse.getter(ListFoldersResponse::status)).setter(ListFoldersResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<List<FolderSummary>> FOLDER_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FolderSummaryList").getter(ListFoldersResponse.getter(ListFoldersResponse::folderSummaryList)).setter(ListFoldersResponse.setter(Builder::folderSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FolderSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FolderSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFoldersResponse.getter(ListFoldersResponse::nextToken)).setter(ListFoldersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(ListFoldersResponse.getter(ListFoldersResponse::requestId)).setter(ListFoldersResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, FOLDER_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD, REQUEST_ID_FIELD));
    private final Integer status;
    private final List<FolderSummary> folderSummaryList;
    private final String nextToken;
    private final String requestId;

    private ListFoldersResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.folderSummaryList = builder.folderSummaryList;
        this.nextToken = builder.nextToken;
        this.requestId = builder.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public final boolean hasFolderSummaryList() {
        return this.folderSummaryList != null && !(this.folderSummaryList instanceof SdkAutoConstructList);
    }

    public final List<FolderSummary> folderSummaryList() {
        return this.folderSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFolderSummaryList() ? this.folderSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFoldersResponse)) {
            return false;
        }
        ListFoldersResponse other = (ListFoldersResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && this.hasFolderSummaryList() == other.hasFolderSummaryList() && Objects.equals(this.folderSummaryList(), other.folderSummaryList()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.requestId(), other.requestId());
    }

    public final String toString() {
        return ToString.builder((String)"ListFoldersResponse").add("Status", (Object)this.status()).add("FolderSummaryList", this.hasFolderSummaryList() ? this.folderSummaryList() : null).add("NextToken", (Object)this.nextToken()).add("RequestId", (Object)this.requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "FolderSummaryList": {
                return Optional.ofNullable(clazz.cast(this.folderSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFoldersResponse, T> g) {
        return obj -> g.apply((ListFoldersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private Integer status;
        private List<FolderSummary> folderSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFoldersResponse model) {
            super(model);
            this.status(model.status);
            this.folderSummaryList(model.folderSummaryList);
            this.nextToken(model.nextToken);
            this.requestId(model.requestId);
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final List<FolderSummary.Builder> getFolderSummaryList() {
            List<FolderSummary.Builder> result = FolderSummaryListCopier.copyToBuilder(this.folderSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFolderSummaryList(Collection<FolderSummary.BuilderImpl> folderSummaryList) {
            this.folderSummaryList = FolderSummaryListCopier.copyFromBuilder(folderSummaryList);
        }

        @Override
        @Transient
        public final Builder folderSummaryList(Collection<FolderSummary> folderSummaryList) {
            this.folderSummaryList = FolderSummaryListCopier.copy(folderSummaryList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder folderSummaryList(FolderSummary ... folderSummaryList) {
            this.folderSummaryList(Arrays.asList(folderSummaryList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder folderSummaryList(Consumer<FolderSummary.Builder> ... folderSummaryList) {
            this.folderSummaryList(Stream.of(folderSummaryList).map(c -> (FolderSummary)((FolderSummary.Builder)FolderSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        @Transient
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public ListFoldersResponse build() {
            return new ListFoldersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFoldersResponse> {
        public Builder status(Integer var1);

        public Builder folderSummaryList(Collection<FolderSummary> var1);

        public Builder folderSummaryList(FolderSummary ... var1);

        public Builder folderSummaryList(Consumer<FolderSummary.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder requestId(String var1);
    }
}

