/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.qldb.DefaultQldbAsyncClient;
import software.amazon.awssdk.services.qldb.DefaultQldbBaseClientBuilder;
import software.amazon.awssdk.services.qldb.QldbAsyncClient;
import software.amazon.awssdk.services.qldb.QldbAsyncClientBuilder;
import software.amazon.awssdk.services.qldb.QldbServiceClientConfiguration;
import software.amazon.awssdk.services.qldb.endpoints.QldbEndpointProvider;

@SdkInternalApi
final class DefaultQldbAsyncClientBuilder
extends DefaultQldbBaseClientBuilder<QldbAsyncClientBuilder, QldbAsyncClient>
implements QldbAsyncClientBuilder {
    DefaultQldbAsyncClientBuilder() {
    }

    @Override
    public DefaultQldbAsyncClientBuilder endpointProvider(QldbEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final QldbAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultQldbAsyncClientBuilder.validateClientOptions(clientConfiguration);
        QldbServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultQldbAsyncClient client = new DefaultQldbAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private QldbServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return QldbServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

