/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLedgerRequest extends QldbRequest implements
        ToCopyableBuilder<UpdateLedgerRequest.Builder, UpdateLedgerRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateLedgerRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(UpdateLedgerRequest::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KmsKey")
            .getter(getter(UpdateLedgerRequest::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DELETION_PROTECTION_FIELD, KMS_KEY_FIELD));

    private final String name;

    private final Boolean deletionProtection;

    private final String kmsKey;

    private UpdateLedgerRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.deletionProtection = builder.deletionProtection;
        this.kmsKey = builder.kmsKey;
    }

    /**
     * <p>
     * The name of the ledger.
     * </p>
     * 
     * @return The name of the ledger.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies whether the ledger is protected from being deleted by any user. If not defined during ledger creation,
     * this feature is enabled (<code>true</code>) by default.
     * </p>
     * <p>
     * If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it
     * by calling the <code>UpdateLedger</code> operation to set this parameter to <code>false</code>.
     * </p>
     * 
     * @return Specifies whether the ledger is protected from being deleted by any user. If not defined during ledger
     *         creation, this feature is enabled (<code>true</code>) by default.</p>
     *         <p>
     *         If deletion protection is enabled, you must first disable it before you can delete the ledger. You can
     *         disable it by calling the <code>UpdateLedger</code> operation to set this parameter to <code>false</code>.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * <p>
     * The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest</a> in
     * the <i>Amazon QLDB Developer Guide</i>.
     * </p>
     * <p>
     * Use one of the following options to specify this parameter:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AWS_OWNED_KMS_KEY</code>: Use an KMS key that is owned and managed by Amazon Web Services on your behalf.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Undefined</b>: Make no changes to the KMS key of the ledger.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>A valid symmetric customer managed KMS key</b>: Use the specified symmetric encryption KMS key in your account
     * that you create, own, and manage.
     * </p>
     * <p>
     * Amazon QLDB does not support asymmetric keys. For more information, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and
     * asymmetric keys</a> in the <i>Key Management Service Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name (ARN), alias name, or alias
     * ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a key in a different Amazon Web
     * Services account, you must use the key ARN or alias ARN.
     * </p>
     * <p>
     * For example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Alias name: <code>alias/ExampleAlias</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in
     * the <i>Key Management Service Developer Guide</i>.
     * </p>
     * 
     * @return The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at
     *         rest</a> in the <i>Amazon QLDB Developer Guide</i>.</p>
     *         <p>
     *         Use one of the following options to specify this parameter:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS_OWNED_KMS_KEY</code>: Use an KMS key that is owned and managed by Amazon Web Services on your
     *         behalf.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Undefined</b>: Make no changes to the KMS key of the ledger.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>A valid symmetric customer managed KMS key</b>: Use the specified symmetric encryption KMS key in your
     *         account that you create, own, and manage.
     *         </p>
     *         <p>
     *         Amazon QLDB does not support asymmetric keys. For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric
     *         and asymmetric keys</a> in the <i>Key Management Service Developer Guide</i>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name (ARN), alias name, or
     *         alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a key in a
     *         different Amazon Web Services account, you must use the key ARN or alias ARN.
     *         </p>
     *         <p>
     *         For example:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Alias name: <code>alias/ExampleAlias</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers
     *         (KeyId)</a> in the <i>Key Management Service Developer Guide</i>.
     */
    public final String kmsKey() {
        return kmsKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLedgerRequest)) {
            return false;
        }
        UpdateLedgerRequest other = (UpdateLedgerRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(deletionProtection(), other.deletionProtection())
                && Objects.equals(kmsKey(), other.kmsKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLedgerRequest").add("Name", name()).add("DeletionProtection", deletionProtection())
                .add("KmsKey", kmsKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "KmsKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLedgerRequest, T> g) {
        return obj -> g.apply((UpdateLedgerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QldbRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLedgerRequest> {
        /**
         * <p>
         * The name of the ledger.
         * </p>
         * 
         * @param name
         *        The name of the ledger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies whether the ledger is protected from being deleted by any user. If not defined during ledger
         * creation, this feature is enabled (<code>true</code>) by default.
         * </p>
         * <p>
         * If deletion protection is enabled, you must first disable it before you can delete the ledger. You can
         * disable it by calling the <code>UpdateLedger</code> operation to set this parameter to <code>false</code>.
         * </p>
         * 
         * @param deletionProtection
         *        Specifies whether the ledger is protected from being deleted by any user. If not defined during ledger
         *        creation, this feature is enabled (<code>true</code>) by default.</p>
         *        <p>
         *        If deletion protection is enabled, you must first disable it before you can delete the ledger. You can
         *        disable it by calling the <code>UpdateLedger</code> operation to set this parameter to
         *        <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest</a>
         * in the <i>Amazon QLDB Developer Guide</i>.
         * </p>
         * <p>
         * Use one of the following options to specify this parameter:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWS_OWNED_KMS_KEY</code>: Use an KMS key that is owned and managed by Amazon Web Services on your
         * behalf.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Undefined</b>: Make no changes to the KMS key of the ledger.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>A valid symmetric customer managed KMS key</b>: Use the specified symmetric encryption KMS key in your
         * account that you create, own, and manage.
         * </p>
         * <p>
         * Amazon QLDB does not support asymmetric keys. For more information, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and
         * asymmetric keys</a> in the <i>Key Management Service Developer Guide</i>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name (ARN), alias name, or
         * alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a key in a different
         * Amazon Web Services account, you must use the key ARN or alias ARN.
         * </p>
         * <p>
         * For example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Alias name: <code>alias/ExampleAlias</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a>
         * in the <i>Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param kmsKey
         *        The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at
         *        rest</a> in the <i>Amazon QLDB Developer Guide</i>.</p>
         *        <p>
         *        Use one of the following options to specify this parameter:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS_OWNED_KMS_KEY</code>: Use an KMS key that is owned and managed by Amazon Web Services on
         *        your behalf.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Undefined</b>: Make no changes to the KMS key of the ledger.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>A valid symmetric customer managed KMS key</b>: Use the specified symmetric encryption KMS key in
         *        your account that you create, own, and manage.
         *        </p>
         *        <p>
         *        Amazon QLDB does not support asymmetric keys. For more information, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric
         *        and asymmetric keys</a> in the <i>Key Management Service Developer Guide</i>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name (ARN), alias name,
         *        or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a key in a
         *        different Amazon Web Services account, you must use the key ARN or alias ARN.
         *        </p>
         *        <p>
         *        For example:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Alias name: <code>alias/ExampleAlias</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers
         *        (KeyId)</a> in the <i>Key Management Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QldbRequest.BuilderImpl implements Builder {
        private String name;

        private Boolean deletionProtection;

        private String kmsKey;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLedgerRequest model) {
            super(model);
            name(model.name);
            deletionProtection(model.deletionProtection);
            kmsKey(model.kmsKey);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLedgerRequest build() {
            return new UpdateLedgerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
