/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.qldb.DefaultQldbBaseClientBuilder;
import software.amazon.awssdk.services.qldb.DefaultQldbClient;
import software.amazon.awssdk.services.qldb.QldbClient;
import software.amazon.awssdk.services.qldb.QldbClientBuilder;
import software.amazon.awssdk.services.qldb.QldbServiceClientConfiguration;
import software.amazon.awssdk.services.qldb.endpoints.QldbEndpointProvider;

@SdkInternalApi
final class DefaultQldbClientBuilder
extends DefaultQldbBaseClientBuilder<QldbClientBuilder, QldbClient>
implements QldbClientBuilder {
    DefaultQldbClientBuilder() {
    }

    @Override
    public DefaultQldbClientBuilder endpointProvider(QldbEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final QldbClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultQldbClientBuilder.validateClientOptions(clientConfiguration);
        QldbServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultQldbClient client = new DefaultQldbClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private QldbServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return QldbServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

