/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qbusiness.QBusinessAsyncClient;
import software.amazon.awssdk.services.qbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.qbusiness.model.ListMessagesRequest;
import software.amazon.awssdk.services.qbusiness.model.ListMessagesResponse;
import software.amazon.awssdk.services.qbusiness.model.Message;

public class ListMessagesPublisher
implements SdkPublisher<ListMessagesResponse> {
    private final QBusinessAsyncClient client;
    private final ListMessagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMessagesPublisher(QBusinessAsyncClient client, ListMessagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMessagesPublisher(QBusinessAsyncClient client, ListMessagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMessagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMessagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Message> messages() {
        Function<ListMessagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.messages() != null) {
                return response.messages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMessagesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMessagesResponseFetcher
    implements AsyncPageFetcher<ListMessagesResponse> {
        private ListMessagesResponseFetcher() {
        }

        public boolean hasNextPage(ListMessagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMessagesResponse> nextPage(ListMessagesResponse previousPage) {
            if (previousPage == null) {
                return ListMessagesPublisher.this.client.listMessages(ListMessagesPublisher.this.firstRequest);
            }
            return ListMessagesPublisher.this.client.listMessages((ListMessagesRequest)((Object)ListMessagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

