/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.QBusinessResponse;
import software.amazon.awssdk.services.qbusiness.model.WebExperience;
import software.amazon.awssdk.services.qbusiness.model.WebExperiencesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWebExperiencesResponse
extends QBusinessResponse
implements ToCopyableBuilder<Builder, ListWebExperiencesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListWebExperiencesResponse.getter(ListWebExperiencesResponse::nextToken)).setter(ListWebExperiencesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<WebExperience>> WEB_EXPERIENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("webExperiences").getter(ListWebExperiencesResponse.getter(ListWebExperiencesResponse::webExperiences)).setter(ListWebExperiencesResponse.setter(Builder::webExperiences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webExperiences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WebExperience::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, WEB_EXPERIENCES_FIELD));
    private final String nextToken;
    private final List<WebExperience> webExperiences;

    private ListWebExperiencesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.webExperiences = builder.webExperiences;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasWebExperiences() {
        return this.webExperiences != null && !(this.webExperiences instanceof SdkAutoConstructList);
    }

    public final List<WebExperience> webExperiences() {
        return this.webExperiences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWebExperiences() ? this.webExperiences() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWebExperiencesResponse)) {
            return false;
        }
        ListWebExperiencesResponse other = (ListWebExperiencesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasWebExperiences() == other.hasWebExperiences() && Objects.equals(this.webExperiences(), other.webExperiences());
    }

    public final String toString() {
        return ToString.builder((String)"ListWebExperiencesResponse").add("NextToken", (Object)this.nextToken()).add("WebExperiences", this.hasWebExperiences() ? this.webExperiences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "webExperiences": {
                return Optional.ofNullable(clazz.cast(this.webExperiences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWebExperiencesResponse, T> g) {
        return obj -> g.apply((ListWebExperiencesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<WebExperience> webExperiences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWebExperiencesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.webExperiences(model.webExperiences);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<WebExperience.Builder> getWebExperiences() {
            List<WebExperience.Builder> result = WebExperiencesCopier.copyToBuilder(this.webExperiences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWebExperiences(Collection<WebExperience.BuilderImpl> webExperiences) {
            this.webExperiences = WebExperiencesCopier.copyFromBuilder(webExperiences);
        }

        @Override
        public final Builder webExperiences(Collection<WebExperience> webExperiences) {
            this.webExperiences = WebExperiencesCopier.copy(webExperiences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder webExperiences(WebExperience ... webExperiences) {
            this.webExperiences(Arrays.asList(webExperiences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder webExperiences(Consumer<WebExperience.Builder> ... webExperiences) {
            this.webExperiences(Stream.of(webExperiences).map(c -> (WebExperience)((WebExperience.Builder)WebExperience.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWebExperiencesResponse build() {
            return new ListWebExperiencesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWebExperiencesResponse> {
        public Builder nextToken(String var1);

        public Builder webExperiences(Collection<WebExperience> var1);

        public Builder webExperiences(WebExperience ... var1);

        public Builder webExperiences(Consumer<WebExperience.Builder> ... var1);
    }
}

