/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qbusiness.QBusinessAsyncClient;
import software.amazon.awssdk.services.qbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesRequest;
import software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesResponse;
import software.amazon.awssdk.services.qbusiness.model.WebExperience;

public class ListWebExperiencesPublisher
implements SdkPublisher<ListWebExperiencesResponse> {
    private final QBusinessAsyncClient client;
    private final ListWebExperiencesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWebExperiencesPublisher(QBusinessAsyncClient client, ListWebExperiencesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWebExperiencesPublisher(QBusinessAsyncClient client, ListWebExperiencesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWebExperiencesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWebExperiencesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WebExperience> webExperiences() {
        Function<ListWebExperiencesResponse, Iterator> getIterator = response -> {
            if (response != null && response.webExperiences() != null) {
                return response.webExperiences().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWebExperiencesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWebExperiencesResponseFetcher
    implements AsyncPageFetcher<ListWebExperiencesResponse> {
        private ListWebExperiencesResponseFetcher() {
        }

        public boolean hasNextPage(ListWebExperiencesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWebExperiencesResponse> nextPage(ListWebExperiencesResponse previousPage) {
            if (previousPage == null) {
                return ListWebExperiencesPublisher.this.client.listWebExperiences(ListWebExperiencesPublisher.this.firstRequest);
            }
            return ListWebExperiencesPublisher.this.client.listWebExperiences((ListWebExperiencesRequest)((Object)ListWebExperiencesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

