/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.QBusinessResponse;
import software.amazon.awssdk.services.qbusiness.model.Retriever;
import software.amazon.awssdk.services.qbusiness.model.RetrieversCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRetrieversResponse
extends QBusinessResponse
implements ToCopyableBuilder<Builder, ListRetrieversResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRetrieversResponse.getter(ListRetrieversResponse::nextToken)).setter(ListRetrieversResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<Retriever>> RETRIEVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("retrievers").getter(ListRetrieversResponse.getter(ListRetrieversResponse::retrievers)).setter(ListRetrieversResponse.setter(Builder::retrievers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrievers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Retriever::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RETRIEVERS_FIELD));
    private final String nextToken;
    private final List<Retriever> retrievers;

    private ListRetrieversResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.retrievers = builder.retrievers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRetrievers() {
        return this.retrievers != null && !(this.retrievers instanceof SdkAutoConstructList);
    }

    public final List<Retriever> retrievers() {
        return this.retrievers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRetrievers() ? this.retrievers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRetrieversResponse)) {
            return false;
        }
        ListRetrieversResponse other = (ListRetrieversResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRetrievers() == other.hasRetrievers() && Objects.equals(this.retrievers(), other.retrievers());
    }

    public final String toString() {
        return ToString.builder((String)"ListRetrieversResponse").add("NextToken", (Object)this.nextToken()).add("Retrievers", this.hasRetrievers() ? this.retrievers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "retrievers": {
                return Optional.ofNullable(clazz.cast(this.retrievers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRetrieversResponse, T> g) {
        return obj -> g.apply((ListRetrieversResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<Retriever> retrievers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRetrieversResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.retrievers(model.retrievers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Retriever.Builder> getRetrievers() {
            List<Retriever.Builder> result = RetrieversCopier.copyToBuilder(this.retrievers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRetrievers(Collection<Retriever.BuilderImpl> retrievers) {
            this.retrievers = RetrieversCopier.copyFromBuilder(retrievers);
        }

        @Override
        public final Builder retrievers(Collection<Retriever> retrievers) {
            this.retrievers = RetrieversCopier.copy(retrievers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retrievers(Retriever ... retrievers) {
            this.retrievers(Arrays.asList(retrievers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retrievers(Consumer<Retriever.Builder> ... retrievers) {
            this.retrievers(Stream.of(retrievers).map(c -> (Retriever)((Retriever.Builder)Retriever.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRetrieversResponse build() {
            return new ListRetrieversResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRetrieversResponse> {
        public Builder nextToken(String var1);

        public Builder retrievers(Collection<Retriever> var1);

        public Builder retrievers(Retriever ... var1);

        public Builder retrievers(Consumer<Retriever.Builder> ... var1);
    }
}

