/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.AttributeType;
import software.amazon.awssdk.services.qbusiness.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentAttributeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentAttributeConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DocumentAttributeConfiguration.getter(DocumentAttributeConfiguration::name)).setter(DocumentAttributeConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SEARCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("search").getter(DocumentAttributeConfiguration.getter(DocumentAttributeConfiguration::searchAsString)).setter(DocumentAttributeConfiguration.setter(Builder::search)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("search").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(DocumentAttributeConfiguration.getter(DocumentAttributeConfiguration::typeAsString)).setter(DocumentAttributeConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SEARCH_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String search;
    private final String type;

    private DocumentAttributeConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.search = builder.search;
        this.type = builder.type;
    }

    public final String name() {
        return this.name;
    }

    public final Status search() {
        return Status.fromValue(this.search);
    }

    public final String searchAsString() {
        return this.search;
    }

    public final AttributeType type() {
        return AttributeType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentAttributeConfiguration)) {
            return false;
        }
        DocumentAttributeConfiguration other = (DocumentAttributeConfiguration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.searchAsString(), other.searchAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentAttributeConfiguration").add("Name", (Object)this.name()).add("Search", (Object)this.searchAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "search": {
                return Optional.ofNullable(clazz.cast(this.searchAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentAttributeConfiguration, T> g) {
        return obj -> g.apply((DocumentAttributeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String search;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentAttributeConfiguration model) {
            this.name(model.name);
            this.search(model.search);
            this.type(model.type);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSearch() {
            return this.search;
        }

        public final void setSearch(String search) {
            this.search = search;
        }

        @Override
        public final Builder search(String search) {
            this.search = search;
            return this;
        }

        @Override
        public final Builder search(Status search) {
            this.search(search == null ? null : search.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AttributeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public DocumentAttributeConfiguration build() {
            return new DocumentAttributeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentAttributeConfiguration> {
        public Builder name(String var1);

        public Builder search(String var1);

        public Builder search(Status var1);

        public Builder type(String var1);

        public Builder type(AttributeType var1);
    }
}

