/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServiceSyncConfigResponse extends ProtonResponse implements
        ToCopyableBuilder<UpdateServiceSyncConfigResponse.Builder, UpdateServiceSyncConfigResponse> {
    private static final SdkField<ServiceSyncConfig> SERVICE_SYNC_CONFIG_FIELD = SdkField
            .<ServiceSyncConfig> builder(MarshallingType.SDK_POJO).memberName("serviceSyncConfig")
            .getter(getter(UpdateServiceSyncConfigResponse::serviceSyncConfig)).setter(setter(Builder::serviceSyncConfig))
            .constructor(ServiceSyncConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceSyncConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_SYNC_CONFIG_FIELD));

    private final ServiceSyncConfig serviceSyncConfig;

    private UpdateServiceSyncConfigResponse(BuilderImpl builder) {
        super(builder);
        this.serviceSyncConfig = builder.serviceSyncConfig;
    }

    /**
     * <p>
     * The detailed data of the Proton Ops file.
     * </p>
     * 
     * @return The detailed data of the Proton Ops file.
     */
    public final ServiceSyncConfig serviceSyncConfig() {
        return serviceSyncConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceSyncConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceSyncConfigResponse)) {
            return false;
        }
        UpdateServiceSyncConfigResponse other = (UpdateServiceSyncConfigResponse) obj;
        return Objects.equals(serviceSyncConfig(), other.serviceSyncConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateServiceSyncConfigResponse").add("ServiceSyncConfig", serviceSyncConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceSyncConfig":
            return Optional.ofNullable(clazz.cast(serviceSyncConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceSyncConfigResponse, T> g) {
        return obj -> g.apply((UpdateServiceSyncConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateServiceSyncConfigResponse> {
        /**
         * <p>
         * The detailed data of the Proton Ops file.
         * </p>
         * 
         * @param serviceSyncConfig
         *        The detailed data of the Proton Ops file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSyncConfig(ServiceSyncConfig serviceSyncConfig);

        /**
         * <p>
         * The detailed data of the Proton Ops file.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceSyncConfig.Builder} avoiding the
         * need to create one manually via {@link ServiceSyncConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceSyncConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceSyncConfig(ServiceSyncConfig)}.
         * 
         * @param serviceSyncConfig
         *        a consumer that will call methods on {@link ServiceSyncConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceSyncConfig(ServiceSyncConfig)
         */
        default Builder serviceSyncConfig(Consumer<ServiceSyncConfig.Builder> serviceSyncConfig) {
            return serviceSyncConfig(ServiceSyncConfig.builder().applyMutation(serviceSyncConfig).build());
        }
    }

    static final class BuilderImpl extends ProtonResponse.BuilderImpl implements Builder {
        private ServiceSyncConfig serviceSyncConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceSyncConfigResponse model) {
            super(model);
            serviceSyncConfig(model.serviceSyncConfig);
        }

        public final ServiceSyncConfig.Builder getServiceSyncConfig() {
            return serviceSyncConfig != null ? serviceSyncConfig.toBuilder() : null;
        }

        public final void setServiceSyncConfig(ServiceSyncConfig.BuilderImpl serviceSyncConfig) {
            this.serviceSyncConfig = serviceSyncConfig != null ? serviceSyncConfig.build() : null;
        }

        @Override
        public final Builder serviceSyncConfig(ServiceSyncConfig serviceSyncConfig) {
            this.serviceSyncConfig = serviceSyncConfig;
            return this;
        }

        @Override
        public UpdateServiceSyncConfigResponse build() {
            return new UpdateServiceSyncConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
