/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetComponentResponse extends ProtonResponse implements
        ToCopyableBuilder<GetComponentResponse.Builder, GetComponentResponse> {
    private static final SdkField<Component> COMPONENT_FIELD = SdkField.<Component> builder(MarshallingType.SDK_POJO)
            .memberName("component").getter(getter(GetComponentResponse::component)).setter(setter(Builder::component))
            .constructor(Component::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("component").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_FIELD));

    private final Component component;

    private GetComponentResponse(BuilderImpl builder) {
        super(builder);
        this.component = builder.component;
    }

    /**
     * <p>
     * The detailed data of the requested component.
     * </p>
     * 
     * @return The detailed data of the requested component.
     */
    public final Component component() {
        return component;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(component());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComponentResponse)) {
            return false;
        }
        GetComponentResponse other = (GetComponentResponse) obj;
        return Objects.equals(component(), other.component());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetComponentResponse").add("Component", component()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "component":
            return Optional.ofNullable(clazz.cast(component()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetComponentResponse, T> g) {
        return obj -> g.apply((GetComponentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetComponentResponse> {
        /**
         * <p>
         * The detailed data of the requested component.
         * </p>
         * 
         * @param component
         *        The detailed data of the requested component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder component(Component component);

        /**
         * <p>
         * The detailed data of the requested component.
         * </p>
         * This is a convenience method that creates an instance of the {@link Component.Builder} avoiding the need to
         * create one manually via {@link Component#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Component.Builder#build()} is called immediately and its result
         * is passed to {@link #component(Component)}.
         * 
         * @param component
         *        a consumer that will call methods on {@link Component.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #component(Component)
         */
        default Builder component(Consumer<Component.Builder> component) {
            return component(Component.builder().applyMutation(component).build());
        }
    }

    static final class BuilderImpl extends ProtonResponse.BuilderImpl implements Builder {
        private Component component;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComponentResponse model) {
            super(model);
            component(model.component);
        }

        public final Component.Builder getComponent() {
            return component != null ? component.toBuilder() : null;
        }

        public final void setComponent(Component.BuilderImpl component) {
            this.component = component != null ? component.build() : null;
        }

        @Override
        public final Builder component(Component component) {
            this.component = component;
            return this;
        }

        @Override
        public GetComponentResponse build() {
            return new GetComponentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
