/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEnvironmentRequest extends ProtonRequest implements
        ToCopyableBuilder<CreateEnvironmentRequest.Builder, CreateEnvironmentRequest> {
    private static final SdkField<String> CODEBUILD_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("codebuildRoleArn").getter(getter(CreateEnvironmentRequest::codebuildRoleArn))
            .setter(setter(Builder::codebuildRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codebuildRoleArn").build()).build();

    private static final SdkField<String> COMPONENT_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentRoleArn").getter(getter(CreateEnvironmentRequest::componentRoleArn))
            .setter(setter(Builder::componentRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentRoleArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateEnvironmentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENVIRONMENT_ACCOUNT_CONNECTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("environmentAccountConnectionId")
            .getter(getter(CreateEnvironmentRequest::environmentAccountConnectionId))
            .setter(setter(Builder::environmentAccountConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentAccountConnectionId")
                    .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateEnvironmentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROTON_SERVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protonServiceRoleArn").getter(getter(CreateEnvironmentRequest::protonServiceRoleArn))
            .setter(setter(Builder::protonServiceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protonServiceRoleArn").build())
            .build();

    private static final SdkField<RepositoryBranchInput> PROVISIONING_REPOSITORY_FIELD = SdkField
            .<RepositoryBranchInput> builder(MarshallingType.SDK_POJO).memberName("provisioningRepository")
            .getter(getter(CreateEnvironmentRequest::provisioningRepository)).setter(setter(Builder::provisioningRepository))
            .constructor(RepositoryBranchInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningRepository").build())
            .build();

    private static final SdkField<String> SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("spec")
            .getter(getter(CreateEnvironmentRequest::spec)).setter(setter(Builder::spec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateEnvironmentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TEMPLATE_MAJOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateMajorVersion").getter(getter(CreateEnvironmentRequest::templateMajorVersion))
            .setter(setter(Builder::templateMajorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateMajorVersion").build())
            .build();

    private static final SdkField<String> TEMPLATE_MINOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateMinorVersion").getter(getter(CreateEnvironmentRequest::templateMinorVersion))
            .setter(setter(Builder::templateMinorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateMinorVersion").build())
            .build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateName").getter(getter(CreateEnvironmentRequest::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODEBUILD_ROLE_ARN_FIELD,
            COMPONENT_ROLE_ARN_FIELD, DESCRIPTION_FIELD, ENVIRONMENT_ACCOUNT_CONNECTION_ID_FIELD, NAME_FIELD,
            PROTON_SERVICE_ROLE_ARN_FIELD, PROVISIONING_REPOSITORY_FIELD, SPEC_FIELD, TAGS_FIELD, TEMPLATE_MAJOR_VERSION_FIELD,
            TEMPLATE_MINOR_VERSION_FIELD, TEMPLATE_NAME_FIELD));

    private final String codebuildRoleArn;

    private final String componentRoleArn;

    private final String description;

    private final String environmentAccountConnectionId;

    private final String name;

    private final String protonServiceRoleArn;

    private final RepositoryBranchInput provisioningRepository;

    private final String spec;

    private final List<Tag> tags;

    private final String templateMajorVersion;

    private final String templateMinorVersion;

    private final String templateName;

    private CreateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.codebuildRoleArn = builder.codebuildRoleArn;
        this.componentRoleArn = builder.componentRoleArn;
        this.description = builder.description;
        this.environmentAccountConnectionId = builder.environmentAccountConnectionId;
        this.name = builder.name;
        this.protonServiceRoleArn = builder.protonServiceRoleArn;
        this.provisioningRepository = builder.provisioningRepository;
        this.spec = builder.spec;
        this.tags = builder.tags;
        this.templateMajorVersion = builder.templateMajorVersion;
        this.templateMinorVersion = builder.templateMinorVersion;
        this.templateName = builder.templateName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM service role that allows Proton to provision infrastructure using
     * CodeBuild-based provisioning on your behalf.
     * </p>
     * <p>
     * To use CodeBuild-based provisioning for the environment or for any service instance running in the environment,
     * specify either the <code>environmentAccountConnectionId</code> or <code>codebuildRoleArn</code> parameter.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM service role that allows Proton to provision infrastructure
     *         using CodeBuild-based provisioning on your behalf.</p>
     *         <p>
     *         To use CodeBuild-based provisioning for the environment or for any service instance running in the
     *         environment, specify either the <code>environmentAccountConnectionId</code> or
     *         <code>codebuildRoleArn</code> parameter.
     */
    public final String codebuildRoleArn() {
        return codebuildRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined
     * components in this environment. It determines the scope of infrastructure that a component can provision.
     * </p>
     * <p>
     * You must specify <code>componentRoleArn</code> to allow directly defined components to be associated with this
     * environment.
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly
     *         defined components in this environment. It determines the scope of infrastructure that a component can
     *         provision.</p>
     *         <p>
     *         You must specify <code>componentRoleArn</code> to allow directly defined components to be associated with
     *         this environment.
     *         </p>
     *         <p>
     *         For more information about components, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in
     *         the <i>Proton User Guide</i>.
     */
    public final String componentRoleArn() {
        return componentRoleArn;
    }

    /**
     * <p>
     * A description of the environment that's being created and deployed.
     * </p>
     * 
     * @return A description of the environment that's being created and deployed.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the environment account connection that you provide if you're provisioning your environment
     * infrastructure resources to an environment account. For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html">Environment account
     * connections</a> in the <i>Proton User guide</i>.
     * </p>
     * <p>
     * To use Amazon Web Services-managed provisioning for the environment, specify either the
     * <code>environmentAccountConnectionId</code> or <code>protonServiceRoleArn</code> parameter and omit the
     * <code>provisioningRepository</code> parameter.
     * </p>
     * 
     * @return The ID of the environment account connection that you provide if you're provisioning your environment
     *         infrastructure resources to an environment account. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html">Environment
     *         account connections</a> in the <i>Proton User guide</i>.</p>
     *         <p>
     *         To use Amazon Web Services-managed provisioning for the environment, specify either the
     *         <code>environmentAccountConnectionId</code> or <code>protonServiceRoleArn</code> parameter and omit the
     *         <code>provisioningRepository</code> parameter.
     */
    public final String environmentAccountConnectionId() {
        return environmentAccountConnectionId;
    }

    /**
     * <p>
     * The name of the environment.
     * </p>
     * 
     * @return The name of the environment.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make calls to other services on
     * your behalf.
     * </p>
     * <p>
     * To use Amazon Web Services-managed provisioning for the environment, specify either the
     * <code>environmentAccountConnectionId</code> or <code>protonServiceRoleArn</code> parameter and omit the
     * <code>provisioningRepository</code> parameter.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make calls to other
     *         services on your behalf.</p>
     *         <p>
     *         To use Amazon Web Services-managed provisioning for the environment, specify either the
     *         <code>environmentAccountConnectionId</code> or <code>protonServiceRoleArn</code> parameter and omit the
     *         <code>provisioningRepository</code> parameter.
     */
    public final String protonServiceRoleArn() {
        return protonServiceRoleArn;
    }

    /**
     * <p>
     * The linked repository that you use to host your rendered infrastructure templates for self-managed provisioning.
     * A linked repository is a repository that has been registered with Proton. For more information, see
     * <a>CreateRepository</a>.
     * </p>
     * <p>
     * To use self-managed provisioning for the environment, specify this parameter and omit the
     * <code>environmentAccountConnectionId</code> and <code>protonServiceRoleArn</code> parameters.
     * </p>
     * 
     * @return The linked repository that you use to host your rendered infrastructure templates for self-managed
     *         provisioning. A linked repository is a repository that has been registered with Proton. For more
     *         information, see <a>CreateRepository</a>.</p>
     *         <p>
     *         To use self-managed provisioning for the environment, specify this parameter and omit the
     *         <code>environmentAccountConnectionId</code> and <code>protonServiceRoleArn</code> parameters.
     */
    public final RepositoryBranchInput provisioningRepository() {
        return provisioningRepository;
    }

    /**
     * <p>
     * A YAML formatted string that provides inputs as defined in the environment template bundle schema file. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-environments.html">Environments</a> in the <i>Proton
     * User Guide</i>.
     * </p>
     * 
     * @return A YAML formatted string that provides inputs as defined in the environment template bundle schema file.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-environments.html">Environments</a> in the
     *         <i>Proton User Guide</i>.
     */
    public final String spec() {
        return spec;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional list of metadata items that you can associate with the Proton environment. A tag is a key-value pair.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton
     * resources and tagging</a> in the <i>Proton User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An optional list of metadata items that you can associate with the Proton environment. A tag is a
     *         key-value pair.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton resources and
     *         tagging</a> in the <i>Proton User Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The major version of the environment template.
     * </p>
     * 
     * @return The major version of the environment template.
     */
    public final String templateMajorVersion() {
        return templateMajorVersion;
    }

    /**
     * <p>
     * The minor version of the environment template.
     * </p>
     * 
     * @return The minor version of the environment template.
     */
    public final String templateMinorVersion() {
        return templateMinorVersion;
    }

    /**
     * <p>
     * The name of the environment template. For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-templates.html">Environment Templates</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * 
     * @return The name of the environment template. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-templates.html">Environment Templates</a> in
     *         the <i>Proton User Guide</i>.
     */
    public final String templateName() {
        return templateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(codebuildRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(componentRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(environmentAccountConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(protonServiceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningRepository());
        hashCode = 31 * hashCode + Objects.hashCode(spec());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(templateMajorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(templateMinorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentRequest)) {
            return false;
        }
        CreateEnvironmentRequest other = (CreateEnvironmentRequest) obj;
        return Objects.equals(codebuildRoleArn(), other.codebuildRoleArn())
                && Objects.equals(componentRoleArn(), other.componentRoleArn())
                && Objects.equals(description(), other.description())
                && Objects.equals(environmentAccountConnectionId(), other.environmentAccountConnectionId())
                && Objects.equals(name(), other.name()) && Objects.equals(protonServiceRoleArn(), other.protonServiceRoleArn())
                && Objects.equals(provisioningRepository(), other.provisioningRepository())
                && Objects.equals(spec(), other.spec()) && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(templateMajorVersion(), other.templateMajorVersion())
                && Objects.equals(templateMinorVersion(), other.templateMinorVersion())
                && Objects.equals(templateName(), other.templateName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEnvironmentRequest").add("CodebuildRoleArn", codebuildRoleArn())
                .add("ComponentRoleArn", componentRoleArn())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EnvironmentAccountConnectionId", environmentAccountConnectionId()).add("Name", name())
                .add("ProtonServiceRoleArn", protonServiceRoleArn()).add("ProvisioningRepository", provisioningRepository())
                .add("Spec", spec() == null ? null : "*** Sensitive Data Redacted ***").add("Tags", hasTags() ? tags() : null)
                .add("TemplateMajorVersion", templateMajorVersion()).add("TemplateMinorVersion", templateMinorVersion())
                .add("TemplateName", templateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "codebuildRoleArn":
            return Optional.ofNullable(clazz.cast(codebuildRoleArn()));
        case "componentRoleArn":
            return Optional.ofNullable(clazz.cast(componentRoleArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "environmentAccountConnectionId":
            return Optional.ofNullable(clazz.cast(environmentAccountConnectionId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "protonServiceRoleArn":
            return Optional.ofNullable(clazz.cast(protonServiceRoleArn()));
        case "provisioningRepository":
            return Optional.ofNullable(clazz.cast(provisioningRepository()));
        case "spec":
            return Optional.ofNullable(clazz.cast(spec()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "templateMajorVersion":
            return Optional.ofNullable(clazz.cast(templateMajorVersion()));
        case "templateMinorVersion":
            return Optional.ofNullable(clazz.cast(templateMinorVersion()));
        case "templateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentRequest, T> g) {
        return obj -> g.apply((CreateEnvironmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateEnvironmentRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM service role that allows Proton to provision infrastructure using
         * CodeBuild-based provisioning on your behalf.
         * </p>
         * <p>
         * To use CodeBuild-based provisioning for the environment or for any service instance running in the
         * environment, specify either the <code>environmentAccountConnectionId</code> or <code>codebuildRoleArn</code>
         * parameter.
         * </p>
         * 
         * @param codebuildRoleArn
         *        The Amazon Resource Name (ARN) of the IAM service role that allows Proton to provision infrastructure
         *        using CodeBuild-based provisioning on your behalf.</p>
         *        <p>
         *        To use CodeBuild-based provisioning for the environment or for any service instance running in the
         *        environment, specify either the <code>environmentAccountConnectionId</code> or
         *        <code>codebuildRoleArn</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codebuildRoleArn(String codebuildRoleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined
         * components in this environment. It determines the scope of infrastructure that a component can provision.
         * </p>
         * <p>
         * You must specify <code>componentRoleArn</code> to allow directly defined components to be associated with
         * this environment.
         * </p>
         * <p>
         * For more information about components, see <a
         * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
         * <i>Proton User Guide</i>.
         * </p>
         * 
         * @param componentRoleArn
         *        The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly
         *        defined components in this environment. It determines the scope of infrastructure that a component can
         *        provision.</p>
         *        <p>
         *        You must specify <code>componentRoleArn</code> to allow directly defined components to be associated
         *        with this environment.
         *        </p>
         *        <p>
         *        For more information about components, see <a
         *        href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in
         *        the <i>Proton User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentRoleArn(String componentRoleArn);

        /**
         * <p>
         * A description of the environment that's being created and deployed.
         * </p>
         * 
         * @param description
         *        A description of the environment that's being created and deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the environment account connection that you provide if you're provisioning your environment
         * infrastructure resources to an environment account. For more information, see <a
         * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html">Environment
         * account connections</a> in the <i>Proton User guide</i>.
         * </p>
         * <p>
         * To use Amazon Web Services-managed provisioning for the environment, specify either the
         * <code>environmentAccountConnectionId</code> or <code>protonServiceRoleArn</code> parameter and omit the
         * <code>provisioningRepository</code> parameter.
         * </p>
         * 
         * @param environmentAccountConnectionId
         *        The ID of the environment account connection that you provide if you're provisioning your environment
         *        infrastructure resources to an environment account. For more information, see <a
         *        href="https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html">Environment
         *        account connections</a> in the <i>Proton User guide</i>.</p>
         *        <p>
         *        To use Amazon Web Services-managed provisioning for the environment, specify either the
         *        <code>environmentAccountConnectionId</code> or <code>protonServiceRoleArn</code> parameter and omit
         *        the <code>provisioningRepository</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentAccountConnectionId(String environmentAccountConnectionId);

        /**
         * <p>
         * The name of the environment.
         * </p>
         * 
         * @param name
         *        The name of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make calls to other services
         * on your behalf.
         * </p>
         * <p>
         * To use Amazon Web Services-managed provisioning for the environment, specify either the
         * <code>environmentAccountConnectionId</code> or <code>protonServiceRoleArn</code> parameter and omit the
         * <code>provisioningRepository</code> parameter.
         * </p>
         * 
         * @param protonServiceRoleArn
         *        The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make calls to other
         *        services on your behalf.</p>
         *        <p>
         *        To use Amazon Web Services-managed provisioning for the environment, specify either the
         *        <code>environmentAccountConnectionId</code> or <code>protonServiceRoleArn</code> parameter and omit
         *        the <code>provisioningRepository</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protonServiceRoleArn(String protonServiceRoleArn);

        /**
         * <p>
         * The linked repository that you use to host your rendered infrastructure templates for self-managed
         * provisioning. A linked repository is a repository that has been registered with Proton. For more information,
         * see <a>CreateRepository</a>.
         * </p>
         * <p>
         * To use self-managed provisioning for the environment, specify this parameter and omit the
         * <code>environmentAccountConnectionId</code> and <code>protonServiceRoleArn</code> parameters.
         * </p>
         * 
         * @param provisioningRepository
         *        The linked repository that you use to host your rendered infrastructure templates for self-managed
         *        provisioning. A linked repository is a repository that has been registered with Proton. For more
         *        information, see <a>CreateRepository</a>.</p>
         *        <p>
         *        To use self-managed provisioning for the environment, specify this parameter and omit the
         *        <code>environmentAccountConnectionId</code> and <code>protonServiceRoleArn</code> parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningRepository(RepositoryBranchInput provisioningRepository);

        /**
         * <p>
         * The linked repository that you use to host your rendered infrastructure templates for self-managed
         * provisioning. A linked repository is a repository that has been registered with Proton. For more information,
         * see <a>CreateRepository</a>.
         * </p>
         * <p>
         * To use self-managed provisioning for the environment, specify this parameter and omit the
         * <code>environmentAccountConnectionId</code> and <code>protonServiceRoleArn</code> parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link RepositoryBranchInput.Builder} avoiding
         * the need to create one manually via {@link RepositoryBranchInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RepositoryBranchInput.Builder#build()} is called immediately and
         * its result is passed to {@link #provisioningRepository(RepositoryBranchInput)}.
         * 
         * @param provisioningRepository
         *        a consumer that will call methods on {@link RepositoryBranchInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningRepository(RepositoryBranchInput)
         */
        default Builder provisioningRepository(Consumer<RepositoryBranchInput.Builder> provisioningRepository) {
            return provisioningRepository(RepositoryBranchInput.builder().applyMutation(provisioningRepository).build());
        }

        /**
         * <p>
         * A YAML formatted string that provides inputs as defined in the environment template bundle schema file. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-environments.html">Environments</a> in the
         * <i>Proton User Guide</i>.
         * </p>
         * 
         * @param spec
         *        A YAML formatted string that provides inputs as defined in the environment template bundle schema
         *        file. For more information, see <a
         *        href="https://docs.aws.amazon.com/proton/latest/userguide/ag-environments.html">Environments</a> in
         *        the <i>Proton User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spec(String spec);

        /**
         * <p>
         * An optional list of metadata items that you can associate with the Proton environment. A tag is a key-value
         * pair.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton
         * resources and tagging</a> in the <i>Proton User Guide</i>.
         * </p>
         * 
         * @param tags
         *        An optional list of metadata items that you can associate with the Proton environment. A tag is a
         *        key-value pair.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton resources and
         *        tagging</a> in the <i>Proton User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An optional list of metadata items that you can associate with the Proton environment. A tag is a key-value
         * pair.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton
         * resources and tagging</a> in the <i>Proton User Guide</i>.
         * </p>
         * 
         * @param tags
         *        An optional list of metadata items that you can associate with the Proton environment. A tag is a
         *        key-value pair.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton resources and
         *        tagging</a> in the <i>Proton User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An optional list of metadata items that you can associate with the Proton environment. A tag is a key-value
         * pair.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton
         * resources and tagging</a> in the <i>Proton User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.proton.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.proton.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.proton.model.Tag.Builder#build()}
         * is called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.proton.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The major version of the environment template.
         * </p>
         * 
         * @param templateMajorVersion
         *        The major version of the environment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateMajorVersion(String templateMajorVersion);

        /**
         * <p>
         * The minor version of the environment template.
         * </p>
         * 
         * @param templateMinorVersion
         *        The minor version of the environment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateMinorVersion(String templateMinorVersion);

        /**
         * <p>
         * The name of the environment template. For more information, see <a
         * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-templates.html">Environment Templates</a> in the
         * <i>Proton User Guide</i>.
         * </p>
         * 
         * @param templateName
         *        The name of the environment template. For more information, see <a
         *        href="https://docs.aws.amazon.com/proton/latest/userguide/ag-templates.html">Environment Templates</a>
         *        in the <i>Proton User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtonRequest.BuilderImpl implements Builder {
        private String codebuildRoleArn;

        private String componentRoleArn;

        private String description;

        private String environmentAccountConnectionId;

        private String name;

        private String protonServiceRoleArn;

        private RepositoryBranchInput provisioningRepository;

        private String spec;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String templateMajorVersion;

        private String templateMinorVersion;

        private String templateName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentRequest model) {
            super(model);
            codebuildRoleArn(model.codebuildRoleArn);
            componentRoleArn(model.componentRoleArn);
            description(model.description);
            environmentAccountConnectionId(model.environmentAccountConnectionId);
            name(model.name);
            protonServiceRoleArn(model.protonServiceRoleArn);
            provisioningRepository(model.provisioningRepository);
            spec(model.spec);
            tags(model.tags);
            templateMajorVersion(model.templateMajorVersion);
            templateMinorVersion(model.templateMinorVersion);
            templateName(model.templateName);
        }

        public final String getCodebuildRoleArn() {
            return codebuildRoleArn;
        }

        public final void setCodebuildRoleArn(String codebuildRoleArn) {
            this.codebuildRoleArn = codebuildRoleArn;
        }

        @Override
        public final Builder codebuildRoleArn(String codebuildRoleArn) {
            this.codebuildRoleArn = codebuildRoleArn;
            return this;
        }

        public final String getComponentRoleArn() {
            return componentRoleArn;
        }

        public final void setComponentRoleArn(String componentRoleArn) {
            this.componentRoleArn = componentRoleArn;
        }

        @Override
        public final Builder componentRoleArn(String componentRoleArn) {
            this.componentRoleArn = componentRoleArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEnvironmentAccountConnectionId() {
            return environmentAccountConnectionId;
        }

        public final void setEnvironmentAccountConnectionId(String environmentAccountConnectionId) {
            this.environmentAccountConnectionId = environmentAccountConnectionId;
        }

        @Override
        public final Builder environmentAccountConnectionId(String environmentAccountConnectionId) {
            this.environmentAccountConnectionId = environmentAccountConnectionId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProtonServiceRoleArn() {
            return protonServiceRoleArn;
        }

        public final void setProtonServiceRoleArn(String protonServiceRoleArn) {
            this.protonServiceRoleArn = protonServiceRoleArn;
        }

        @Override
        public final Builder protonServiceRoleArn(String protonServiceRoleArn) {
            this.protonServiceRoleArn = protonServiceRoleArn;
            return this;
        }

        public final RepositoryBranchInput.Builder getProvisioningRepository() {
            return provisioningRepository != null ? provisioningRepository.toBuilder() : null;
        }

        public final void setProvisioningRepository(RepositoryBranchInput.BuilderImpl provisioningRepository) {
            this.provisioningRepository = provisioningRepository != null ? provisioningRepository.build() : null;
        }

        @Override
        public final Builder provisioningRepository(RepositoryBranchInput provisioningRepository) {
            this.provisioningRepository = provisioningRepository;
            return this;
        }

        public final String getSpec() {
            return spec;
        }

        public final void setSpec(String spec) {
            this.spec = spec;
        }

        @Override
        public final Builder spec(String spec) {
            this.spec = spec;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTemplateMajorVersion() {
            return templateMajorVersion;
        }

        public final void setTemplateMajorVersion(String templateMajorVersion) {
            this.templateMajorVersion = templateMajorVersion;
        }

        @Override
        public final Builder templateMajorVersion(String templateMajorVersion) {
            this.templateMajorVersion = templateMajorVersion;
            return this;
        }

        public final String getTemplateMinorVersion() {
            return templateMinorVersion;
        }

        public final void setTemplateMinorVersion(String templateMinorVersion) {
            this.templateMinorVersion = templateMinorVersion;
        }

        @Override
        public final Builder templateMinorVersion(String templateMinorVersion) {
            this.templateMinorVersion = templateMinorVersion;
            return this;
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentRequest build() {
            return new CreateEnvironmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
