/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for using a self-managed Apache Kafka stream as a source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePipeSourceSelfManagedKafkaParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdatePipeSourceSelfManagedKafkaParameters.Builder, UpdatePipeSourceSelfManagedKafkaParameters> {
    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BatchSize").getter(getter(UpdatePipeSourceSelfManagedKafkaParameters::batchSize))
            .setter(setter(Builder::batchSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()).build();

    private static final SdkField<SelfManagedKafkaAccessConfigurationCredentials> CREDENTIALS_FIELD = SdkField
            .<SelfManagedKafkaAccessConfigurationCredentials> builder(MarshallingType.SDK_POJO).memberName("Credentials")
            .getter(getter(UpdatePipeSourceSelfManagedKafkaParameters::credentials)).setter(setter(Builder::credentials))
            .constructor(SelfManagedKafkaAccessConfigurationCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()).build();

    private static final SdkField<Integer> MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumBatchingWindowInSeconds")
            .getter(getter(UpdatePipeSourceSelfManagedKafkaParameters::maximumBatchingWindowInSeconds))
            .setter(setter(Builder::maximumBatchingWindowInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchingWindowInSeconds")
                    .build()).build();

    private static final SdkField<String> SERVER_ROOT_CA_CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerRootCaCertificate")
            .getter(getter(UpdatePipeSourceSelfManagedKafkaParameters::serverRootCaCertificate))
            .setter(setter(Builder::serverRootCaCertificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerRootCaCertificate").build())
            .build();

    private static final SdkField<SelfManagedKafkaAccessConfigurationVpc> VPC_FIELD = SdkField
            .<SelfManagedKafkaAccessConfigurationVpc> builder(MarshallingType.SDK_POJO).memberName("Vpc")
            .getter(getter(UpdatePipeSourceSelfManagedKafkaParameters::vpc)).setter(setter(Builder::vpc))
            .constructor(SelfManagedKafkaAccessConfigurationVpc::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpc").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_SIZE_FIELD,
            CREDENTIALS_FIELD, MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD, SERVER_ROOT_CA_CERTIFICATE_FIELD, VPC_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer batchSize;

    private final SelfManagedKafkaAccessConfigurationCredentials credentials;

    private final Integer maximumBatchingWindowInSeconds;

    private final String serverRootCaCertificate;

    private final SelfManagedKafkaAccessConfigurationVpc vpc;

    private UpdatePipeSourceSelfManagedKafkaParameters(BuilderImpl builder) {
        this.batchSize = builder.batchSize;
        this.credentials = builder.credentials;
        this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
        this.serverRootCaCertificate = builder.serverRootCaCertificate;
        this.vpc = builder.vpc;
    }

    /**
     * <p>
     * The maximum number of records to include in each batch.
     * </p>
     * 
     * @return The maximum number of records to include in each batch.
     */
    public final Integer batchSize() {
        return batchSize;
    }

    /**
     * <p>
     * The credentials needed to access the resource.
     * </p>
     * 
     * @return The credentials needed to access the resource.
     */
    public final SelfManagedKafkaAccessConfigurationCredentials credentials() {
        return credentials;
    }

    /**
     * <p>
     * The maximum length of a time to wait for events.
     * </p>
     * 
     * @return The maximum length of a time to wait for events.
     */
    public final Integer maximumBatchingWindowInSeconds() {
        return maximumBatchingWindowInSeconds;
    }

    /**
     * <p>
     * The ARN of the Secrets Manager secret used for certification.
     * </p>
     * 
     * @return The ARN of the Secrets Manager secret used for certification.
     */
    public final String serverRootCaCertificate() {
        return serverRootCaCertificate;
    }

    /**
     * <p>
     * This structure specifies the VPC subnets and security groups for the stream, and whether a public IP address is
     * to be used.
     * </p>
     * 
     * @return This structure specifies the VPC subnets and security groups for the stream, and whether a public IP
     *         address is to be used.
     */
    public final SelfManagedKafkaAccessConfigurationVpc vpc() {
        return vpc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(credentials());
        hashCode = 31 * hashCode + Objects.hashCode(maximumBatchingWindowInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(serverRootCaCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipeSourceSelfManagedKafkaParameters)) {
            return false;
        }
        UpdatePipeSourceSelfManagedKafkaParameters other = (UpdatePipeSourceSelfManagedKafkaParameters) obj;
        return Objects.equals(batchSize(), other.batchSize()) && Objects.equals(credentials(), other.credentials())
                && Objects.equals(maximumBatchingWindowInSeconds(), other.maximumBatchingWindowInSeconds())
                && Objects.equals(serverRootCaCertificate(), other.serverRootCaCertificate())
                && Objects.equals(vpc(), other.vpc());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePipeSourceSelfManagedKafkaParameters").add("BatchSize", batchSize())
                .add("Credentials", credentials()).add("MaximumBatchingWindowInSeconds", maximumBatchingWindowInSeconds())
                .add("ServerRootCaCertificate", serverRootCaCertificate()).add("Vpc", vpc()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BatchSize":
            return Optional.ofNullable(clazz.cast(batchSize()));
        case "Credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        case "MaximumBatchingWindowInSeconds":
            return Optional.ofNullable(clazz.cast(maximumBatchingWindowInSeconds()));
        case "ServerRootCaCertificate":
            return Optional.ofNullable(clazz.cast(serverRootCaCertificate()));
        case "Vpc":
            return Optional.ofNullable(clazz.cast(vpc()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipeSourceSelfManagedKafkaParameters, T> g) {
        return obj -> g.apply((UpdatePipeSourceSelfManagedKafkaParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdatePipeSourceSelfManagedKafkaParameters> {
        /**
         * <p>
         * The maximum number of records to include in each batch.
         * </p>
         * 
         * @param batchSize
         *        The maximum number of records to include in each batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchSize(Integer batchSize);

        /**
         * <p>
         * The credentials needed to access the resource.
         * </p>
         * 
         * @param credentials
         *        The credentials needed to access the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(SelfManagedKafkaAccessConfigurationCredentials credentials);

        /**
         * <p>
         * The credentials needed to access the resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SelfManagedKafkaAccessConfigurationCredentials.Builder} avoiding the need to create one manually via
         * {@link SelfManagedKafkaAccessConfigurationCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SelfManagedKafkaAccessConfigurationCredentials.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #credentials(SelfManagedKafkaAccessConfigurationCredentials)}.
         * 
         * @param credentials
         *        a consumer that will call methods on {@link SelfManagedKafkaAccessConfigurationCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(SelfManagedKafkaAccessConfigurationCredentials)
         */
        default Builder credentials(Consumer<SelfManagedKafkaAccessConfigurationCredentials.Builder> credentials) {
            return credentials(SelfManagedKafkaAccessConfigurationCredentials.builder().applyMutation(credentials).build());
        }

        /**
         * <p>
         * The maximum length of a time to wait for events.
         * </p>
         * 
         * @param maximumBatchingWindowInSeconds
         *        The maximum length of a time to wait for events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds);

        /**
         * <p>
         * The ARN of the Secrets Manager secret used for certification.
         * </p>
         * 
         * @param serverRootCaCertificate
         *        The ARN of the Secrets Manager secret used for certification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverRootCaCertificate(String serverRootCaCertificate);

        /**
         * <p>
         * This structure specifies the VPC subnets and security groups for the stream, and whether a public IP address
         * is to be used.
         * </p>
         * 
         * @param vpc
         *        This structure specifies the VPC subnets and security groups for the stream, and whether a public IP
         *        address is to be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(SelfManagedKafkaAccessConfigurationVpc vpc);

        /**
         * <p>
         * This structure specifies the VPC subnets and security groups for the stream, and whether a public IP address
         * is to be used.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SelfManagedKafkaAccessConfigurationVpc.Builder} avoiding the need to create one manually via
         * {@link SelfManagedKafkaAccessConfigurationVpc#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SelfManagedKafkaAccessConfigurationVpc.Builder#build()} is called
         * immediately and its result is passed to {@link #vpc(SelfManagedKafkaAccessConfigurationVpc)}.
         * 
         * @param vpc
         *        a consumer that will call methods on {@link SelfManagedKafkaAccessConfigurationVpc.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpc(SelfManagedKafkaAccessConfigurationVpc)
         */
        default Builder vpc(Consumer<SelfManagedKafkaAccessConfigurationVpc.Builder> vpc) {
            return vpc(SelfManagedKafkaAccessConfigurationVpc.builder().applyMutation(vpc).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer batchSize;

        private SelfManagedKafkaAccessConfigurationCredentials credentials;

        private Integer maximumBatchingWindowInSeconds;

        private String serverRootCaCertificate;

        private SelfManagedKafkaAccessConfigurationVpc vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipeSourceSelfManagedKafkaParameters model) {
            batchSize(model.batchSize);
            credentials(model.credentials);
            maximumBatchingWindowInSeconds(model.maximumBatchingWindowInSeconds);
            serverRootCaCertificate(model.serverRootCaCertificate);
            vpc(model.vpc);
        }

        public final Integer getBatchSize() {
            return batchSize;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final SelfManagedKafkaAccessConfigurationCredentials.Builder getCredentials() {
            return credentials != null ? credentials.toBuilder() : null;
        }

        public final void setCredentials(SelfManagedKafkaAccessConfigurationCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(SelfManagedKafkaAccessConfigurationCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final Integer getMaximumBatchingWindowInSeconds() {
            return maximumBatchingWindowInSeconds;
        }

        public final void setMaximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
        }

        @Override
        public final Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
            return this;
        }

        public final String getServerRootCaCertificate() {
            return serverRootCaCertificate;
        }

        public final void setServerRootCaCertificate(String serverRootCaCertificate) {
            this.serverRootCaCertificate = serverRootCaCertificate;
        }

        @Override
        public final Builder serverRootCaCertificate(String serverRootCaCertificate) {
            this.serverRootCaCertificate = serverRootCaCertificate;
            return this;
        }

        public final SelfManagedKafkaAccessConfigurationVpc.Builder getVpc() {
            return vpc != null ? vpc.toBuilder() : null;
        }

        public final void setVpc(SelfManagedKafkaAccessConfigurationVpc.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public final Builder vpc(SelfManagedKafkaAccessConfigurationVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        @Override
        public UpdatePipeSourceSelfManagedKafkaParameters build() {
            return new UpdatePipeSourceSelfManagedKafkaParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
