/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for using a Kinesis stream as a source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipeTargetKinesisStreamParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<PipeTargetKinesisStreamParameters.Builder, PipeTargetKinesisStreamParameters> {
    private static final SdkField<String> PARTITION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PartitionKey").getter(getter(PipeTargetKinesisStreamParameters::partitionKey))
            .setter(setter(Builder::partitionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTITION_KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String partitionKey;

    private PipeTargetKinesisStreamParameters(BuilderImpl builder) {
        this.partitionKey = builder.partitionKey;
    }

    /**
     * <p>
     * Determines which shard in the stream the data record is assigned to. Partition keys are Unicode strings with a
     * maximum length limit of 256 characters for each key. Amazon Kinesis Data Streams uses the partition key as input
     * to a hash function that maps the partition key and associated data to a specific shard. Specifically, an MD5 hash
     * function is used to map partition keys to 128-bit integer values and to map associated data records to shards. As
     * a result of this hashing mechanism, all data records with the same partition key map to the same shard within the
     * stream.
     * </p>
     * 
     * @return Determines which shard in the stream the data record is assigned to. Partition keys are Unicode strings
     *         with a maximum length limit of 256 characters for each key. Amazon Kinesis Data Streams uses the
     *         partition key as input to a hash function that maps the partition key and associated data to a specific
     *         shard. Specifically, an MD5 hash function is used to map partition keys to 128-bit integer values and to
     *         map associated data records to shards. As a result of this hashing mechanism, all data records with the
     *         same partition key map to the same shard within the stream.
     */
    public final String partitionKey() {
        return partitionKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(partitionKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeTargetKinesisStreamParameters)) {
            return false;
        }
        PipeTargetKinesisStreamParameters other = (PipeTargetKinesisStreamParameters) obj;
        return Objects.equals(partitionKey(), other.partitionKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipeTargetKinesisStreamParameters")
                .add("PartitionKey", partitionKey() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PartitionKey":
            return Optional.ofNullable(clazz.cast(partitionKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipeTargetKinesisStreamParameters, T> g) {
        return obj -> g.apply((PipeTargetKinesisStreamParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipeTargetKinesisStreamParameters> {
        /**
         * <p>
         * Determines which shard in the stream the data record is assigned to. Partition keys are Unicode strings with
         * a maximum length limit of 256 characters for each key. Amazon Kinesis Data Streams uses the partition key as
         * input to a hash function that maps the partition key and associated data to a specific shard. Specifically,
         * an MD5 hash function is used to map partition keys to 128-bit integer values and to map associated data
         * records to shards. As a result of this hashing mechanism, all data records with the same partition key map to
         * the same shard within the stream.
         * </p>
         * 
         * @param partitionKey
         *        Determines which shard in the stream the data record is assigned to. Partition keys are Unicode
         *        strings with a maximum length limit of 256 characters for each key. Amazon Kinesis Data Streams uses
         *        the partition key as input to a hash function that maps the partition key and associated data to a
         *        specific shard. Specifically, an MD5 hash function is used to map partition keys to 128-bit integer
         *        values and to map associated data records to shards. As a result of this hashing mechanism, all data
         *        records with the same partition key map to the same shard within the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionKey(String partitionKey);
    }

    static final class BuilderImpl implements Builder {
        private String partitionKey;

        private BuilderImpl() {
        }

        private BuilderImpl(PipeTargetKinesisStreamParameters model) {
            partitionKey(model.partitionKey);
        }

        public final String getPartitionKey() {
            return partitionKey;
        }

        public final void setPartitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
        }

        @Override
        public final Builder partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        @Override
        public PipeTargetKinesisStreamParameters build() {
            return new PipeTargetKinesisStreamParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
