/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * These are custom parameter to be used when the target is an API Gateway REST APIs or EventBridge ApiDestinations. In
 * the latter case, these are merged with any InvocationParameters specified on the Connection, with any values from the
 * Connection taking precedence.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipeEnrichmentHttpParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<PipeEnrichmentHttpParameters.Builder, PipeEnrichmentHttpParameters> {
    private static final SdkField<Map<String, String>> HEADER_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("HeaderParameters")
            .getter(getter(PipeEnrichmentHttpParameters::headerParameters))
            .setter(setter(Builder::headerParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> PATH_PARAMETER_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PathParameterValues")
            .getter(getter(PipeEnrichmentHttpParameters::pathParameterValues))
            .setter(setter(Builder::pathParameterValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathParameterValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> QUERY_STRING_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("QueryStringParameters")
            .getter(getter(PipeEnrichmentHttpParameters::queryStringParameters))
            .setter(setter(Builder::queryStringParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStringParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADER_PARAMETERS_FIELD,
            PATH_PARAMETER_VALUES_FIELD, QUERY_STRING_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> headerParameters;

    private final List<String> pathParameterValues;

    private final Map<String, String> queryStringParameters;

    private PipeEnrichmentHttpParameters(BuilderImpl builder) {
        this.headerParameters = builder.headerParameters;
        this.pathParameterValues = builder.pathParameterValues;
        this.queryStringParameters = builder.queryStringParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the HeaderParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHeaderParameters() {
        return headerParameters != null && !(headerParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The headers that need to be sent as part of request invoking the API Gateway REST API or EventBridge
     * ApiDestination.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHeaderParameters} method.
     * </p>
     * 
     * @return The headers that need to be sent as part of request invoking the API Gateway REST API or EventBridge
     *         ApiDestination.
     */
    public final Map<String, String> headerParameters() {
        return headerParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the PathParameterValues property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPathParameterValues() {
        return pathParameterValues != null && !(pathParameterValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The path parameter values to be used to populate API Gateway REST API or EventBridge ApiDestination path
     * wildcards ("*").
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPathParameterValues} method.
     * </p>
     * 
     * @return The path parameter values to be used to populate API Gateway REST API or EventBridge ApiDestination path
     *         wildcards ("*").
     */
    public final List<String> pathParameterValues() {
        return pathParameterValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueryStringParameters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasQueryStringParameters() {
        return queryStringParameters != null && !(queryStringParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The query string keys/values that need to be sent as part of request invoking the API Gateway REST API or
     * EventBridge ApiDestination.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueryStringParameters} method.
     * </p>
     * 
     * @return The query string keys/values that need to be sent as part of request invoking the API Gateway REST API or
     *         EventBridge ApiDestination.
     */
    public final Map<String, String> queryStringParameters() {
        return queryStringParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasHeaderParameters() ? headerParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPathParameterValues() ? pathParameterValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasQueryStringParameters() ? queryStringParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeEnrichmentHttpParameters)) {
            return false;
        }
        PipeEnrichmentHttpParameters other = (PipeEnrichmentHttpParameters) obj;
        return hasHeaderParameters() == other.hasHeaderParameters()
                && Objects.equals(headerParameters(), other.headerParameters())
                && hasPathParameterValues() == other.hasPathParameterValues()
                && Objects.equals(pathParameterValues(), other.pathParameterValues())
                && hasQueryStringParameters() == other.hasQueryStringParameters()
                && Objects.equals(queryStringParameters(), other.queryStringParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipeEnrichmentHttpParameters")
                .add("HeaderParameters", headerParameters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PathParameterValues", pathParameterValues() == null ? null : "*** Sensitive Data Redacted ***")
                .add("QueryStringParameters", queryStringParameters() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HeaderParameters":
            return Optional.ofNullable(clazz.cast(headerParameters()));
        case "PathParameterValues":
            return Optional.ofNullable(clazz.cast(pathParameterValues()));
        case "QueryStringParameters":
            return Optional.ofNullable(clazz.cast(queryStringParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipeEnrichmentHttpParameters, T> g) {
        return obj -> g.apply((PipeEnrichmentHttpParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipeEnrichmentHttpParameters> {
        /**
         * <p>
         * The headers that need to be sent as part of request invoking the API Gateway REST API or EventBridge
         * ApiDestination.
         * </p>
         * 
         * @param headerParameters
         *        The headers that need to be sent as part of request invoking the API Gateway REST API or EventBridge
         *        ApiDestination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerParameters(Map<String, String> headerParameters);

        /**
         * <p>
         * The path parameter values to be used to populate API Gateway REST API or EventBridge ApiDestination path
         * wildcards ("*").
         * </p>
         * 
         * @param pathParameterValues
         *        The path parameter values to be used to populate API Gateway REST API or EventBridge ApiDestination
         *        path wildcards ("*").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathParameterValues(Collection<String> pathParameterValues);

        /**
         * <p>
         * The path parameter values to be used to populate API Gateway REST API or EventBridge ApiDestination path
         * wildcards ("*").
         * </p>
         * 
         * @param pathParameterValues
         *        The path parameter values to be used to populate API Gateway REST API or EventBridge ApiDestination
         *        path wildcards ("*").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathParameterValues(String... pathParameterValues);

        /**
         * <p>
         * The query string keys/values that need to be sent as part of request invoking the API Gateway REST API or
         * EventBridge ApiDestination.
         * </p>
         * 
         * @param queryStringParameters
         *        The query string keys/values that need to be sent as part of request invoking the API Gateway REST API
         *        or EventBridge ApiDestination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryStringParameters(Map<String, String> queryStringParameters);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> headerParameters = DefaultSdkAutoConstructMap.getInstance();

        private List<String> pathParameterValues = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> queryStringParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PipeEnrichmentHttpParameters model) {
            headerParameters(model.headerParameters);
            pathParameterValues(model.pathParameterValues);
            queryStringParameters(model.queryStringParameters);
        }

        public final Map<String, String> getHeaderParameters() {
            if (headerParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return headerParameters;
        }

        public final void setHeaderParameters(Map<String, String> headerParameters) {
            this.headerParameters = HeaderParametersMapCopier.copy(headerParameters);
        }

        @Override
        public final Builder headerParameters(Map<String, String> headerParameters) {
            this.headerParameters = HeaderParametersMapCopier.copy(headerParameters);
            return this;
        }

        public final Collection<String> getPathParameterValues() {
            if (pathParameterValues instanceof SdkAutoConstructList) {
                return null;
            }
            return pathParameterValues;
        }

        public final void setPathParameterValues(Collection<String> pathParameterValues) {
            this.pathParameterValues = PathParameterListCopier.copy(pathParameterValues);
        }

        @Override
        public final Builder pathParameterValues(Collection<String> pathParameterValues) {
            this.pathParameterValues = PathParameterListCopier.copy(pathParameterValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pathParameterValues(String... pathParameterValues) {
            pathParameterValues(Arrays.asList(pathParameterValues));
            return this;
        }

        public final Map<String, String> getQueryStringParameters() {
            if (queryStringParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return queryStringParameters;
        }

        public final void setQueryStringParameters(Map<String, String> queryStringParameters) {
            this.queryStringParameters = QueryStringParametersMapCopier.copy(queryStringParameters);
        }

        @Override
        public final Builder queryStringParameters(Map<String, String> queryStringParameters) {
            this.queryStringParameters = QueryStringParametersMapCopier.copy(queryStringParameters);
            return this;
        }

        @Override
        public PipeEnrichmentHttpParameters build() {
            return new PipeEnrichmentHttpParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
