/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for using a self-managed Apache Kafka stream as a source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipeSourceSelfManagedKafkaParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<PipeSourceSelfManagedKafkaParameters.Builder, PipeSourceSelfManagedKafkaParameters> {
    private static final SdkField<List<String>> ADDITIONAL_BOOTSTRAP_SERVERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdditionalBootstrapServers")
            .getter(getter(PipeSourceSelfManagedKafkaParameters::additionalBootstrapServers))
            .setter(setter(Builder::additionalBootstrapServers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalBootstrapServers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BatchSize").getter(getter(PipeSourceSelfManagedKafkaParameters::batchSize))
            .setter(setter(Builder::batchSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()).build();

    private static final SdkField<String> CONSUMER_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsumerGroupID").getter(getter(PipeSourceSelfManagedKafkaParameters::consumerGroupID))
            .setter(setter(Builder::consumerGroupID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerGroupID").build()).build();

    private static final SdkField<SelfManagedKafkaAccessConfigurationCredentials> CREDENTIALS_FIELD = SdkField
            .<SelfManagedKafkaAccessConfigurationCredentials> builder(MarshallingType.SDK_POJO).memberName("Credentials")
            .getter(getter(PipeSourceSelfManagedKafkaParameters::credentials)).setter(setter(Builder::credentials))
            .constructor(SelfManagedKafkaAccessConfigurationCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()).build();

    private static final SdkField<Integer> MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumBatchingWindowInSeconds")
            .getter(getter(PipeSourceSelfManagedKafkaParameters::maximumBatchingWindowInSeconds))
            .setter(setter(Builder::maximumBatchingWindowInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchingWindowInSeconds")
                    .build()).build();

    private static final SdkField<String> SERVER_ROOT_CA_CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerRootCaCertificate").getter(getter(PipeSourceSelfManagedKafkaParameters::serverRootCaCertificate))
            .setter(setter(Builder::serverRootCaCertificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerRootCaCertificate").build())
            .build();

    private static final SdkField<String> STARTING_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartingPosition").getter(getter(PipeSourceSelfManagedKafkaParameters::startingPositionAsString))
            .setter(setter(Builder::startingPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingPosition").build()).build();

    private static final SdkField<String> TOPIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicName").getter(getter(PipeSourceSelfManagedKafkaParameters::topicName))
            .setter(setter(Builder::topicName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicName").build()).build();

    private static final SdkField<SelfManagedKafkaAccessConfigurationVpc> VPC_FIELD = SdkField
            .<SelfManagedKafkaAccessConfigurationVpc> builder(MarshallingType.SDK_POJO).memberName("Vpc")
            .getter(getter(PipeSourceSelfManagedKafkaParameters::vpc)).setter(setter(Builder::vpc))
            .constructor(SelfManagedKafkaAccessConfigurationVpc::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpc").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ADDITIONAL_BOOTSTRAP_SERVERS_FIELD, BATCH_SIZE_FIELD, CONSUMER_GROUP_ID_FIELD, CREDENTIALS_FIELD,
            MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD, SERVER_ROOT_CA_CERTIFICATE_FIELD, STARTING_POSITION_FIELD,
            TOPIC_NAME_FIELD, VPC_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> additionalBootstrapServers;

    private final Integer batchSize;

    private final String consumerGroupID;

    private final SelfManagedKafkaAccessConfigurationCredentials credentials;

    private final Integer maximumBatchingWindowInSeconds;

    private final String serverRootCaCertificate;

    private final String startingPosition;

    private final String topicName;

    private final SelfManagedKafkaAccessConfigurationVpc vpc;

    private PipeSourceSelfManagedKafkaParameters(BuilderImpl builder) {
        this.additionalBootstrapServers = builder.additionalBootstrapServers;
        this.batchSize = builder.batchSize;
        this.consumerGroupID = builder.consumerGroupID;
        this.credentials = builder.credentials;
        this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
        this.serverRootCaCertificate = builder.serverRootCaCertificate;
        this.startingPosition = builder.startingPosition;
        this.topicName = builder.topicName;
        this.vpc = builder.vpc;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalBootstrapServers property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalBootstrapServers() {
        return additionalBootstrapServers != null && !(additionalBootstrapServers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of server URLs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalBootstrapServers} method.
     * </p>
     * 
     * @return An array of server URLs.
     */
    public final List<String> additionalBootstrapServers() {
        return additionalBootstrapServers;
    }

    /**
     * <p>
     * The maximum number of records to include in each batch.
     * </p>
     * 
     * @return The maximum number of records to include in each batch.
     */
    public final Integer batchSize() {
        return batchSize;
    }

    /**
     * <p>
     * The name of the destination queue to consume.
     * </p>
     * 
     * @return The name of the destination queue to consume.
     */
    public final String consumerGroupID() {
        return consumerGroupID;
    }

    /**
     * <p>
     * The credentials needed to access the resource.
     * </p>
     * 
     * @return The credentials needed to access the resource.
     */
    public final SelfManagedKafkaAccessConfigurationCredentials credentials() {
        return credentials;
    }

    /**
     * <p>
     * The maximum length of a time to wait for events.
     * </p>
     * 
     * @return The maximum length of a time to wait for events.
     */
    public final Integer maximumBatchingWindowInSeconds() {
        return maximumBatchingWindowInSeconds;
    }

    /**
     * <p>
     * The ARN of the Secrets Manager secret used for certification.
     * </p>
     * 
     * @return The ARN of the Secrets Manager secret used for certification.
     */
    public final String serverRootCaCertificate() {
        return serverRootCaCertificate;
    }

    /**
     * <p>
     * (Streams only) The position in a stream from which to start reading.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #startingPosition}
     * will return {@link SelfManagedKafkaStartPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #startingPositionAsString}.
     * </p>
     * 
     * @return (Streams only) The position in a stream from which to start reading.
     * @see SelfManagedKafkaStartPosition
     */
    public final SelfManagedKafkaStartPosition startingPosition() {
        return SelfManagedKafkaStartPosition.fromValue(startingPosition);
    }

    /**
     * <p>
     * (Streams only) The position in a stream from which to start reading.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #startingPosition}
     * will return {@link SelfManagedKafkaStartPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #startingPositionAsString}.
     * </p>
     * 
     * @return (Streams only) The position in a stream from which to start reading.
     * @see SelfManagedKafkaStartPosition
     */
    public final String startingPositionAsString() {
        return startingPosition;
    }

    /**
     * <p>
     * The name of the topic that the pipe will read from.
     * </p>
     * 
     * @return The name of the topic that the pipe will read from.
     */
    public final String topicName() {
        return topicName;
    }

    /**
     * <p>
     * This structure specifies the VPC subnets and security groups for the stream, and whether a public IP address is
     * to be used.
     * </p>
     * 
     * @return This structure specifies the VPC subnets and security groups for the stream, and whether a public IP
     *         address is to be used.
     */
    public final SelfManagedKafkaAccessConfigurationVpc vpc() {
        return vpc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalBootstrapServers() ? additionalBootstrapServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(consumerGroupID());
        hashCode = 31 * hashCode + Objects.hashCode(credentials());
        hashCode = 31 * hashCode + Objects.hashCode(maximumBatchingWindowInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(serverRootCaCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(startingPositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(topicName());
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeSourceSelfManagedKafkaParameters)) {
            return false;
        }
        PipeSourceSelfManagedKafkaParameters other = (PipeSourceSelfManagedKafkaParameters) obj;
        return hasAdditionalBootstrapServers() == other.hasAdditionalBootstrapServers()
                && Objects.equals(additionalBootstrapServers(), other.additionalBootstrapServers())
                && Objects.equals(batchSize(), other.batchSize()) && Objects.equals(consumerGroupID(), other.consumerGroupID())
                && Objects.equals(credentials(), other.credentials())
                && Objects.equals(maximumBatchingWindowInSeconds(), other.maximumBatchingWindowInSeconds())
                && Objects.equals(serverRootCaCertificate(), other.serverRootCaCertificate())
                && Objects.equals(startingPositionAsString(), other.startingPositionAsString())
                && Objects.equals(topicName(), other.topicName()) && Objects.equals(vpc(), other.vpc());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("PipeSourceSelfManagedKafkaParameters")
                .add("AdditionalBootstrapServers",
                        additionalBootstrapServers() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BatchSize", batchSize())
                .add("ConsumerGroupID", consumerGroupID() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Credentials", credentials()).add("MaximumBatchingWindowInSeconds", maximumBatchingWindowInSeconds())
                .add("ServerRootCaCertificate", serverRootCaCertificate()).add("StartingPosition", startingPositionAsString())
                .add("TopicName", topicName() == null ? null : "*** Sensitive Data Redacted ***").add("Vpc", vpc()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdditionalBootstrapServers":
            return Optional.ofNullable(clazz.cast(additionalBootstrapServers()));
        case "BatchSize":
            return Optional.ofNullable(clazz.cast(batchSize()));
        case "ConsumerGroupID":
            return Optional.ofNullable(clazz.cast(consumerGroupID()));
        case "Credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        case "MaximumBatchingWindowInSeconds":
            return Optional.ofNullable(clazz.cast(maximumBatchingWindowInSeconds()));
        case "ServerRootCaCertificate":
            return Optional.ofNullable(clazz.cast(serverRootCaCertificate()));
        case "StartingPosition":
            return Optional.ofNullable(clazz.cast(startingPositionAsString()));
        case "TopicName":
            return Optional.ofNullable(clazz.cast(topicName()));
        case "Vpc":
            return Optional.ofNullable(clazz.cast(vpc()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipeSourceSelfManagedKafkaParameters, T> g) {
        return obj -> g.apply((PipeSourceSelfManagedKafkaParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipeSourceSelfManagedKafkaParameters> {
        /**
         * <p>
         * An array of server URLs.
         * </p>
         * 
         * @param additionalBootstrapServers
         *        An array of server URLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalBootstrapServers(Collection<String> additionalBootstrapServers);

        /**
         * <p>
         * An array of server URLs.
         * </p>
         * 
         * @param additionalBootstrapServers
         *        An array of server URLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalBootstrapServers(String... additionalBootstrapServers);

        /**
         * <p>
         * The maximum number of records to include in each batch.
         * </p>
         * 
         * @param batchSize
         *        The maximum number of records to include in each batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchSize(Integer batchSize);

        /**
         * <p>
         * The name of the destination queue to consume.
         * </p>
         * 
         * @param consumerGroupID
         *        The name of the destination queue to consume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerGroupID(String consumerGroupID);

        /**
         * <p>
         * The credentials needed to access the resource.
         * </p>
         * 
         * @param credentials
         *        The credentials needed to access the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(SelfManagedKafkaAccessConfigurationCredentials credentials);

        /**
         * <p>
         * The credentials needed to access the resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SelfManagedKafkaAccessConfigurationCredentials.Builder} avoiding the need to create one manually via
         * {@link SelfManagedKafkaAccessConfigurationCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SelfManagedKafkaAccessConfigurationCredentials.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #credentials(SelfManagedKafkaAccessConfigurationCredentials)}.
         * 
         * @param credentials
         *        a consumer that will call methods on {@link SelfManagedKafkaAccessConfigurationCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(SelfManagedKafkaAccessConfigurationCredentials)
         */
        default Builder credentials(Consumer<SelfManagedKafkaAccessConfigurationCredentials.Builder> credentials) {
            return credentials(SelfManagedKafkaAccessConfigurationCredentials.builder().applyMutation(credentials).build());
        }

        /**
         * <p>
         * The maximum length of a time to wait for events.
         * </p>
         * 
         * @param maximumBatchingWindowInSeconds
         *        The maximum length of a time to wait for events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds);

        /**
         * <p>
         * The ARN of the Secrets Manager secret used for certification.
         * </p>
         * 
         * @param serverRootCaCertificate
         *        The ARN of the Secrets Manager secret used for certification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverRootCaCertificate(String serverRootCaCertificate);

        /**
         * <p>
         * (Streams only) The position in a stream from which to start reading.
         * </p>
         * 
         * @param startingPosition
         *        (Streams only) The position in a stream from which to start reading.
         * @see SelfManagedKafkaStartPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SelfManagedKafkaStartPosition
         */
        Builder startingPosition(String startingPosition);

        /**
         * <p>
         * (Streams only) The position in a stream from which to start reading.
         * </p>
         * 
         * @param startingPosition
         *        (Streams only) The position in a stream from which to start reading.
         * @see SelfManagedKafkaStartPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SelfManagedKafkaStartPosition
         */
        Builder startingPosition(SelfManagedKafkaStartPosition startingPosition);

        /**
         * <p>
         * The name of the topic that the pipe will read from.
         * </p>
         * 
         * @param topicName
         *        The name of the topic that the pipe will read from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicName(String topicName);

        /**
         * <p>
         * This structure specifies the VPC subnets and security groups for the stream, and whether a public IP address
         * is to be used.
         * </p>
         * 
         * @param vpc
         *        This structure specifies the VPC subnets and security groups for the stream, and whether a public IP
         *        address is to be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(SelfManagedKafkaAccessConfigurationVpc vpc);

        /**
         * <p>
         * This structure specifies the VPC subnets and security groups for the stream, and whether a public IP address
         * is to be used.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SelfManagedKafkaAccessConfigurationVpc.Builder} avoiding the need to create one manually via
         * {@link SelfManagedKafkaAccessConfigurationVpc#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SelfManagedKafkaAccessConfigurationVpc.Builder#build()} is called
         * immediately and its result is passed to {@link #vpc(SelfManagedKafkaAccessConfigurationVpc)}.
         * 
         * @param vpc
         *        a consumer that will call methods on {@link SelfManagedKafkaAccessConfigurationVpc.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpc(SelfManagedKafkaAccessConfigurationVpc)
         */
        default Builder vpc(Consumer<SelfManagedKafkaAccessConfigurationVpc.Builder> vpc) {
            return vpc(SelfManagedKafkaAccessConfigurationVpc.builder().applyMutation(vpc).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> additionalBootstrapServers = DefaultSdkAutoConstructList.getInstance();

        private Integer batchSize;

        private String consumerGroupID;

        private SelfManagedKafkaAccessConfigurationCredentials credentials;

        private Integer maximumBatchingWindowInSeconds;

        private String serverRootCaCertificate;

        private String startingPosition;

        private String topicName;

        private SelfManagedKafkaAccessConfigurationVpc vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(PipeSourceSelfManagedKafkaParameters model) {
            additionalBootstrapServers(model.additionalBootstrapServers);
            batchSize(model.batchSize);
            consumerGroupID(model.consumerGroupID);
            credentials(model.credentials);
            maximumBatchingWindowInSeconds(model.maximumBatchingWindowInSeconds);
            serverRootCaCertificate(model.serverRootCaCertificate);
            startingPosition(model.startingPosition);
            topicName(model.topicName);
            vpc(model.vpc);
        }

        public final Collection<String> getAdditionalBootstrapServers() {
            if (additionalBootstrapServers instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalBootstrapServers;
        }

        public final void setAdditionalBootstrapServers(Collection<String> additionalBootstrapServers) {
            this.additionalBootstrapServers = KafkaBootstrapServersCopier.copy(additionalBootstrapServers);
        }

        @Override
        public final Builder additionalBootstrapServers(Collection<String> additionalBootstrapServers) {
            this.additionalBootstrapServers = KafkaBootstrapServersCopier.copy(additionalBootstrapServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalBootstrapServers(String... additionalBootstrapServers) {
            additionalBootstrapServers(Arrays.asList(additionalBootstrapServers));
            return this;
        }

        public final Integer getBatchSize() {
            return batchSize;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final String getConsumerGroupID() {
            return consumerGroupID;
        }

        public final void setConsumerGroupID(String consumerGroupID) {
            this.consumerGroupID = consumerGroupID;
        }

        @Override
        public final Builder consumerGroupID(String consumerGroupID) {
            this.consumerGroupID = consumerGroupID;
            return this;
        }

        public final SelfManagedKafkaAccessConfigurationCredentials.Builder getCredentials() {
            return credentials != null ? credentials.toBuilder() : null;
        }

        public final void setCredentials(SelfManagedKafkaAccessConfigurationCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(SelfManagedKafkaAccessConfigurationCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final Integer getMaximumBatchingWindowInSeconds() {
            return maximumBatchingWindowInSeconds;
        }

        public final void setMaximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
        }

        @Override
        public final Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
            return this;
        }

        public final String getServerRootCaCertificate() {
            return serverRootCaCertificate;
        }

        public final void setServerRootCaCertificate(String serverRootCaCertificate) {
            this.serverRootCaCertificate = serverRootCaCertificate;
        }

        @Override
        public final Builder serverRootCaCertificate(String serverRootCaCertificate) {
            this.serverRootCaCertificate = serverRootCaCertificate;
            return this;
        }

        public final String getStartingPosition() {
            return startingPosition;
        }

        public final void setStartingPosition(String startingPosition) {
            this.startingPosition = startingPosition;
        }

        @Override
        public final Builder startingPosition(String startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        @Override
        public final Builder startingPosition(SelfManagedKafkaStartPosition startingPosition) {
            this.startingPosition(startingPosition == null ? null : startingPosition.toString());
            return this;
        }

        public final String getTopicName() {
            return topicName;
        }

        public final void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        @Override
        public final Builder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public final SelfManagedKafkaAccessConfigurationVpc.Builder getVpc() {
            return vpc != null ? vpc.toBuilder() : null;
        }

        public final void setVpc(SelfManagedKafkaAccessConfigurationVpc.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public final Builder vpc(SelfManagedKafkaAccessConfigurationVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        @Override
        public PipeSourceSelfManagedKafkaParameters build() {
            return new PipeSourceSelfManagedKafkaParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
