/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptOutListInformation;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptOutListInformationListCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOptOutListsResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, DescribeOptOutListsResponse> {
    private static final SdkField<List<OptOutListInformation>> OPT_OUT_LISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OptOutLists").getter(DescribeOptOutListsResponse.getter(DescribeOptOutListsResponse::optOutLists)).setter(DescribeOptOutListsResponse.setter(Builder::optOutLists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOutLists").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OptOutListInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeOptOutListsResponse.getter(DescribeOptOutListsResponse::nextToken)).setter(DescribeOptOutListsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPT_OUT_LISTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<OptOutListInformation> optOutLists;
    private final String nextToken;

    private DescribeOptOutListsResponse(BuilderImpl builder) {
        super(builder);
        this.optOutLists = builder.optOutLists;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasOptOutLists() {
        return this.optOutLists != null && !(this.optOutLists instanceof SdkAutoConstructList);
    }

    public final List<OptOutListInformation> optOutLists() {
        return this.optOutLists;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptOutLists() ? this.optOutLists() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOptOutListsResponse)) {
            return false;
        }
        DescribeOptOutListsResponse other = (DescribeOptOutListsResponse)((Object)obj);
        return this.hasOptOutLists() == other.hasOptOutLists() && Objects.equals(this.optOutLists(), other.optOutLists()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeOptOutListsResponse").add("OptOutLists", this.hasOptOutLists() ? this.optOutLists() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OptOutLists": {
                return Optional.ofNullable(clazz.cast(this.optOutLists()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOptOutListsResponse, T> g) {
        return obj -> g.apply((DescribeOptOutListsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private List<OptOutListInformation> optOutLists = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOptOutListsResponse model) {
            super(model);
            this.optOutLists(model.optOutLists);
            this.nextToken(model.nextToken);
        }

        public final List<OptOutListInformation.Builder> getOptOutLists() {
            List<OptOutListInformation.Builder> result = OptOutListInformationListCopier.copyToBuilder(this.optOutLists);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptOutLists(Collection<OptOutListInformation.BuilderImpl> optOutLists) {
            this.optOutLists = OptOutListInformationListCopier.copyFromBuilder(optOutLists);
        }

        @Override
        public final Builder optOutLists(Collection<OptOutListInformation> optOutLists) {
            this.optOutLists = OptOutListInformationListCopier.copy(optOutLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optOutLists(OptOutListInformation ... optOutLists) {
            this.optOutLists(Arrays.asList(optOutLists));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optOutLists(Consumer<OptOutListInformation.Builder> ... optOutLists) {
            this.optOutLists(Stream.of(optOutLists).map(c -> (OptOutListInformation)((OptOutListInformation.Builder)OptOutListInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeOptOutListsResponse build() {
            return new DescribeOptOutListsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOptOutListsResponse> {
        public Builder optOutLists(Collection<OptOutListInformation> var1);

        public Builder optOutLists(OptOutListInformation ... var1);

        public Builder optOutLists(Consumer<OptOutListInformation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

