/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ValidationExceptionReason {
    UNKNOWN_OPERATION("UNKNOWN_OPERATION"),
    CANNOT_PARSE("CANNOT_PARSE"),
    FIELD_VALIDATION_FAILED("FIELD_VALIDATION_FAILED"),
    OTHER("OTHER"),
    INVALID_PARAMETER("INVALID_PARAMETER"),
    INVALID_ARN("INVALID_ARN"),
    INVALID_IDENTITY_FOR_DESTINATION_COUNTRY("INVALID_IDENTITY_FOR_DESTINATION_COUNTRY"),
    DESTINATION_COUNTRY_BLOCKED("DESTINATION_COUNTRY_BLOCKED"),
    CANNOT_ADD_OPTED_OUT_NUMBER("CANNOT_ADD_OPTED_OUT_NUMBER"),
    COUNTRY_CODE_MISMATCH("COUNTRY_CODE_MISMATCH"),
    INVALID_FILTER_VALUES("INVALID_FILTER_VALUES"),
    INVALID_NEXT_TOKEN("INVALID_NEXT_TOKEN"),
    MISSING_PARAMETER("MISSING_PARAMETER"),
    PARAMETERS_CANNOT_BE_USED_TOGETHER("PARAMETERS_CANNOT_BE_USED_TOGETHER"),
    PHONE_NUMBER_CANNOT_BE_OPTED_IN("PHONE_NUMBER_CANNOT_BE_OPTED_IN"),
    PHONE_NUMBER_CANNOT_BE_RELEASED("PHONE_NUMBER_CANNOT_BE_RELEASED"),
    PRICE_OVER_THRESHOLD("PRICE_OVER_THRESHOLD"),
    REQUESTED_SPEND_LIMIT_HIGHER_THAN_SERVICE_LIMIT("REQUESTED_SPEND_LIMIT_HIGHER_THAN_SERVICE_LIMIT"),
    SENDER_ID_NOT_REGISTERED("SENDER_ID_NOT_REGISTERED"),
    SENDER_ID_NOT_SUPPORTED("SENDER_ID_NOT_SUPPORTED"),
    TWO_WAY_NOT_ENABLED("TWO_WAY_NOT_ENABLED"),
    TWO_WAY_NOT_SUPPORTED_IN_COUNTRY("TWO_WAY_NOT_SUPPORTED_IN_COUNTRY"),
    TWO_WAY_NOT_SUPPORTED_IN_REGION("TWO_WAY_NOT_SUPPORTED_IN_REGION"),
    TWO_WAY_TOPIC_NOT_PRESENT("TWO_WAY_TOPIC_NOT_PRESENT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ValidationExceptionReason> VALUE_MAP;
    private final String value;

    private ValidationExceptionReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ValidationExceptionReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ValidationExceptionReason> knownValues() {
        EnumSet<ValidationExceptionReason> knownValues = EnumSet.allOf(ValidationExceptionReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ValidationExceptionReason.class, ValidationExceptionReason::toString);
    }
}

