/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDefaultMessageTypeResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<DeleteDefaultMessageTypeResponse.Builder, DeleteDefaultMessageTypeResponse> {
    private static final SdkField<String> CONFIGURATION_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetArn").getter(getter(DeleteDefaultMessageTypeResponse::configurationSetArn))
            .setter(setter(Builder::configurationSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetArn").build())
            .build();

    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetName").getter(getter(DeleteDefaultMessageTypeResponse::configurationSetName))
            .setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build())
            .build();

    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageType").getter(getter(DeleteDefaultMessageTypeResponse::messageTypeAsString))
            .setter(setter(Builder::messageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_ARN_FIELD,
            CONFIGURATION_SET_NAME_FIELD, MESSAGE_TYPE_FIELD));

    private final String configurationSetArn;

    private final String configurationSetName;

    private final String messageType;

    private DeleteDefaultMessageTypeResponse(BuilderImpl builder) {
        super(builder);
        this.configurationSetArn = builder.configurationSetArn;
        this.configurationSetName = builder.configurationSetName;
        this.messageType = builder.messageType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configuration set.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configuration set.
     */
    public final String configurationSetArn() {
        return configurationSetArn;
    }

    /**
     * <p>
     * The name of the configuration set.
     * </p>
     * 
     * @return The name of the configuration set.
     */
    public final String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * The current message type for the configuration set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The current message type for the configuration set.
     * @see MessageType
     */
    public final MessageType messageType() {
        return MessageType.fromValue(messageType);
    }

    /**
     * <p>
     * The current message type for the configuration set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The current message type for the configuration set.
     * @see MessageType
     */
    public final String messageTypeAsString() {
        return messageType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(messageTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDefaultMessageTypeResponse)) {
            return false;
        }
        DeleteDefaultMessageTypeResponse other = (DeleteDefaultMessageTypeResponse) obj;
        return Objects.equals(configurationSetArn(), other.configurationSetArn())
                && Objects.equals(configurationSetName(), other.configurationSetName())
                && Objects.equals(messageTypeAsString(), other.messageTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteDefaultMessageTypeResponse").add("ConfigurationSetArn", configurationSetArn())
                .add("ConfigurationSetName", configurationSetName()).add("MessageType", messageTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSetArn":
            return Optional.ofNullable(clazz.cast(configurationSetArn()));
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "MessageType":
            return Optional.ofNullable(clazz.cast(messageTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDefaultMessageTypeResponse, T> g) {
        return obj -> g.apply((DeleteDefaultMessageTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteDefaultMessageTypeResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configuration set.
         * </p>
         * 
         * @param configurationSetArn
         *        The Amazon Resource Name (ARN) of the configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetArn(String configurationSetArn);

        /**
         * <p>
         * The name of the configuration set.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * The current message type for the configuration set.
         * </p>
         * 
         * @param messageType
         *        The current message type for the configuration set.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(String messageType);

        /**
         * <p>
         * The current message type for the configuration set.
         * </p>
         * 
         * @param messageType
         *        The current message type for the configuration set.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(MessageType messageType);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String configurationSetArn;

        private String configurationSetName;

        private String messageType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDefaultMessageTypeResponse model) {
            super(model);
            configurationSetArn(model.configurationSetArn);
            configurationSetName(model.configurationSetName);
            messageType(model.messageType);
        }

        public final String getConfigurationSetArn() {
            return configurationSetArn;
        }

        public final void setConfigurationSetArn(String configurationSetArn) {
            this.configurationSetArn = configurationSetArn;
        }

        @Override
        public final Builder configurationSetArn(String configurationSetArn) {
            this.configurationSetArn = configurationSetArn;
            return this;
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final String getMessageType() {
            return messageType;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType == null ? null : messageType.toString());
            return this;
        }

        @Override
        public DeleteDefaultMessageTypeResponse build() {
            return new DeleteDefaultMessageTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
