/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Used to create a campaign treatment.
 */
@Generated("software.amazon.awssdk:codegen")
public final class WriteTreatmentResource implements SdkPojo, Serializable,
        ToCopyableBuilder<WriteTreatmentResource.Builder, WriteTreatmentResource> {
    private static final SdkField<MessageConfiguration> MESSAGE_CONFIGURATION_FIELD = SdkField
            .<MessageConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(WriteTreatmentResource::messageConfiguration)).setter(setter(Builder::messageConfiguration))
            .constructor(MessageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageConfiguration").build())
            .build();

    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.<Schedule> builder(MarshallingType.SDK_POJO)
            .getter(getter(WriteTreatmentResource::schedule)).setter(setter(Builder::schedule)).constructor(Schedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<Integer> SIZE_PERCENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(WriteTreatmentResource::sizePercent)).setter(setter(Builder::sizePercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizePercent").build()).build();

    private static final SdkField<String> TREATMENT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WriteTreatmentResource::treatmentDescription)).setter(setter(Builder::treatmentDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentDescription").build())
            .build();

    private static final SdkField<String> TREATMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WriteTreatmentResource::treatmentName)).setter(setter(Builder::treatmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_CONFIGURATION_FIELD,
            SCHEDULE_FIELD, SIZE_PERCENT_FIELD, TREATMENT_DESCRIPTION_FIELD, TREATMENT_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final MessageConfiguration messageConfiguration;

    private final Schedule schedule;

    private final Integer sizePercent;

    private final String treatmentDescription;

    private final String treatmentName;

    private WriteTreatmentResource(BuilderImpl builder) {
        this.messageConfiguration = builder.messageConfiguration;
        this.schedule = builder.schedule;
        this.sizePercent = builder.sizePercent;
        this.treatmentDescription = builder.treatmentDescription;
        this.treatmentName = builder.treatmentName;
    }

    /**
     * The message configuration settings.
     * 
     * @return The message configuration settings.
     */
    public MessageConfiguration messageConfiguration() {
        return messageConfiguration;
    }

    /**
     * The campaign schedule.
     * 
     * @return The campaign schedule.
     */
    public Schedule schedule() {
        return schedule;
    }

    /**
     * The allocated percentage of users for this treatment.
     * 
     * @return The allocated percentage of users for this treatment.
     */
    public Integer sizePercent() {
        return sizePercent;
    }

    /**
     * A custom description for the treatment.
     * 
     * @return A custom description for the treatment.
     */
    public String treatmentDescription() {
        return treatmentDescription;
    }

    /**
     * The custom name of a variation of the campaign used for A/B testing.
     * 
     * @return The custom name of a variation of the campaign used for A/B testing.
     */
    public String treatmentName() {
        return treatmentName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(sizePercent());
        hashCode = 31 * hashCode + Objects.hashCode(treatmentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(treatmentName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteTreatmentResource)) {
            return false;
        }
        WriteTreatmentResource other = (WriteTreatmentResource) obj;
        return Objects.equals(messageConfiguration(), other.messageConfiguration())
                && Objects.equals(schedule(), other.schedule()) && Objects.equals(sizePercent(), other.sizePercent())
                && Objects.equals(treatmentDescription(), other.treatmentDescription())
                && Objects.equals(treatmentName(), other.treatmentName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("WriteTreatmentResource").add("MessageConfiguration", messageConfiguration())
                .add("Schedule", schedule()).add("SizePercent", sizePercent())
                .add("TreatmentDescription", treatmentDescription()).add("TreatmentName", treatmentName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MessageConfiguration":
            return Optional.ofNullable(clazz.cast(messageConfiguration()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "SizePercent":
            return Optional.ofNullable(clazz.cast(sizePercent()));
        case "TreatmentDescription":
            return Optional.ofNullable(clazz.cast(treatmentDescription()));
        case "TreatmentName":
            return Optional.ofNullable(clazz.cast(treatmentName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WriteTreatmentResource, T> g) {
        return obj -> g.apply((WriteTreatmentResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WriteTreatmentResource> {
        /**
         * The message configuration settings.
         * 
         * @param messageConfiguration
         *        The message configuration settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageConfiguration(MessageConfiguration messageConfiguration);

        /**
         * The message configuration settings. This is a convenience that creates an instance of the
         * {@link MessageConfiguration.Builder} avoiding the need to create one manually via
         * {@link MessageConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link MessageConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #messageConfiguration(MessageConfiguration)}.
         * 
         * @param messageConfiguration
         *        a consumer that will call methods on {@link MessageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messageConfiguration(MessageConfiguration)
         */
        default Builder messageConfiguration(Consumer<MessageConfiguration.Builder> messageConfiguration) {
            return messageConfiguration(MessageConfiguration.builder().applyMutation(messageConfiguration).build());
        }

        /**
         * The campaign schedule.
         * 
         * @param schedule
         *        The campaign schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(Schedule schedule);

        /**
         * The campaign schedule. This is a convenience that creates an instance of the {@link Schedule.Builder}
         * avoiding the need to create one manually via {@link Schedule#builder()}.
         *
         * When the {@link Consumer} completes, {@link Schedule.Builder#build()} is called immediately and its result is
         * passed to {@link #schedule(Schedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link Schedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(Schedule)
         */
        default Builder schedule(Consumer<Schedule.Builder> schedule) {
            return schedule(Schedule.builder().applyMutation(schedule).build());
        }

        /**
         * The allocated percentage of users for this treatment.
         * 
         * @param sizePercent
         *        The allocated percentage of users for this treatment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizePercent(Integer sizePercent);

        /**
         * A custom description for the treatment.
         * 
         * @param treatmentDescription
         *        A custom description for the treatment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatmentDescription(String treatmentDescription);

        /**
         * The custom name of a variation of the campaign used for A/B testing.
         * 
         * @param treatmentName
         *        The custom name of a variation of the campaign used for A/B testing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatmentName(String treatmentName);
    }

    static final class BuilderImpl implements Builder {
        private MessageConfiguration messageConfiguration;

        private Schedule schedule;

        private Integer sizePercent;

        private String treatmentDescription;

        private String treatmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteTreatmentResource model) {
            messageConfiguration(model.messageConfiguration);
            schedule(model.schedule);
            sizePercent(model.sizePercent);
            treatmentDescription(model.treatmentDescription);
            treatmentName(model.treatmentName);
        }

        public final MessageConfiguration.Builder getMessageConfiguration() {
            return messageConfiguration != null ? messageConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder messageConfiguration(MessageConfiguration messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
            return this;
        }

        public final void setMessageConfiguration(MessageConfiguration.BuilderImpl messageConfiguration) {
            this.messageConfiguration = messageConfiguration != null ? messageConfiguration.build() : null;
        }

        public final Schedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        public final Integer getSizePercent() {
            return sizePercent;
        }

        @Override
        public final Builder sizePercent(Integer sizePercent) {
            this.sizePercent = sizePercent;
            return this;
        }

        public final void setSizePercent(Integer sizePercent) {
            this.sizePercent = sizePercent;
        }

        public final String getTreatmentDescription() {
            return treatmentDescription;
        }

        @Override
        public final Builder treatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
            return this;
        }

        public final void setTreatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
        }

        public final String getTreatmentName() {
            return treatmentName;
        }

        @Override
        public final Builder treatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
            return this;
        }

        public final void setTreatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
        }

        @Override
        public WriteTreatmentResource build() {
            return new WriteTreatmentResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
