/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Request to save an EventStream.
 */
@Generated("software.amazon.awssdk:codegen")
public final class WriteEventStream implements SdkPojo, Serializable,
        ToCopyableBuilder<WriteEventStream.Builder, WriteEventStream> {
    private static final SdkField<String> DESTINATION_STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WriteEventStream::destinationStreamArn)).setter(setter(Builder::destinationStreamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationStreamArn").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WriteEventStream::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_STREAM_ARN_FIELD,
            ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String destinationStreamArn;

    private final String roleArn;

    private WriteEventStream(BuilderImpl builder) {
        this.destinationStreamArn = builder.destinationStreamArn;
        this.roleArn = builder.roleArn;
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon Kinesis stream or Firehose delivery stream to which you want to
     * publish events. Firehose ARN: arn:aws:firehose:REGION:ACCOUNT_ID:deliverystream/STREAM_NAME Kinesis ARN:
     * arn:aws:kinesis:REGION:ACCOUNT_ID:stream/STREAM_NAME
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Kinesis stream or Firehose delivery stream to which you want
     *         to publish events. Firehose ARN: arn:aws:firehose:REGION:ACCOUNT_ID:deliverystream/STREAM_NAME Kinesis
     *         ARN: arn:aws:kinesis:REGION:ACCOUNT_ID:stream/STREAM_NAME
     */
    public String destinationStreamArn() {
        return destinationStreamArn;
    }

    /**
     * The IAM role that authorizes Amazon Pinpoint to publish events to the stream in your account.
     * 
     * @return The IAM role that authorizes Amazon Pinpoint to publish events to the stream in your account.
     */
    public String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationStreamArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteEventStream)) {
            return false;
        }
        WriteEventStream other = (WriteEventStream) obj;
        return Objects.equals(destinationStreamArn(), other.destinationStreamArn()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("WriteEventStream").add("DestinationStreamArn", destinationStreamArn()).add("RoleArn", roleArn())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationStreamArn":
            return Optional.ofNullable(clazz.cast(destinationStreamArn()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WriteEventStream, T> g) {
        return obj -> g.apply((WriteEventStream) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WriteEventStream> {
        /**
         * The Amazon Resource Name (ARN) of the Amazon Kinesis stream or Firehose delivery stream to which you want to
         * publish events. Firehose ARN: arn:aws:firehose:REGION:ACCOUNT_ID:deliverystream/STREAM_NAME Kinesis ARN:
         * arn:aws:kinesis:REGION:ACCOUNT_ID:stream/STREAM_NAME
         * 
         * @param destinationStreamArn
         *        The Amazon Resource Name (ARN) of the Amazon Kinesis stream or Firehose delivery stream to which you
         *        want to publish events. Firehose ARN: arn:aws:firehose:REGION:ACCOUNT_ID:deliverystream/STREAM_NAME
         *        Kinesis ARN: arn:aws:kinesis:REGION:ACCOUNT_ID:stream/STREAM_NAME
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationStreamArn(String destinationStreamArn);

        /**
         * The IAM role that authorizes Amazon Pinpoint to publish events to the stream in your account.
         * 
         * @param roleArn
         *        The IAM role that authorizes Amazon Pinpoint to publish events to the stream in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String destinationStreamArn;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteEventStream model) {
            destinationStreamArn(model.destinationStreamArn);
            roleArn(model.roleArn);
        }

        public final String getDestinationStreamArn() {
            return destinationStreamArn;
        }

        @Override
        public final Builder destinationStreamArn(String destinationStreamArn) {
            this.destinationStreamArn = destinationStreamArn;
            return this;
        }

        public final void setDestinationStreamArn(String destinationStreamArn) {
            this.destinationStreamArn = destinationStreamArn;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public WriteEventStream build() {
            return new WriteEventStream(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
