/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Voice Message.
 */
@Generated("software.amazon.awssdk:codegen")
public final class VoiceMessage implements SdkPojo, Serializable, ToCopyableBuilder<VoiceMessage.Builder, VoiceMessage> {
    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VoiceMessage::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VoiceMessage::languageCode)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> ORIGINATION_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VoiceMessage::originationNumber)).setter(setter(Builder::originationNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationNumber").build()).build();

    private static final SdkField<Map<String, List<String>>> SUBSTITUTIONS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .getter(getter(VoiceMessage::substitutions))
            .setter(setter(Builder::substitutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Substitutions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> VOICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VoiceMessage::voiceId)).setter(setter(Builder::voiceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD,
            LANGUAGE_CODE_FIELD, ORIGINATION_NUMBER_FIELD, SUBSTITUTIONS_FIELD, VOICE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String body;

    private final String languageCode;

    private final String originationNumber;

    private final Map<String, List<String>> substitutions;

    private final String voiceId;

    private VoiceMessage(BuilderImpl builder) {
        this.body = builder.body;
        this.languageCode = builder.languageCode;
        this.originationNumber = builder.originationNumber;
        this.substitutions = builder.substitutions;
        this.voiceId = builder.voiceId;
    }

    /**
     * The message body of the notification, the email body or the text message.
     * 
     * @return The message body of the notification, the email body or the text message.
     */
    public String body() {
        return body;
    }

    /**
     * Language of sent message
     * 
     * @return Language of sent message
     */
    public String languageCode() {
        return languageCode;
    }

    /**
     * Is the number from the pool or messaging service to send from.
     * 
     * @return Is the number from the pool or messaging service to send from.
     */
    public String originationNumber() {
        return originationNumber;
    }

    /**
     * Default message substitutions. Can be overridden by individual address substitutions.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Default message substitutions. Can be overridden by individual address substitutions.
     */
    public Map<String, List<String>> substitutions() {
        return substitutions;
    }

    /**
     * Voice ID of sent message.
     * 
     * @return Voice ID of sent message.
     */
    public String voiceId() {
        return voiceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(languageCode());
        hashCode = 31 * hashCode + Objects.hashCode(originationNumber());
        hashCode = 31 * hashCode + Objects.hashCode(substitutions());
        hashCode = 31 * hashCode + Objects.hashCode(voiceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoiceMessage)) {
            return false;
        }
        VoiceMessage other = (VoiceMessage) obj;
        return Objects.equals(body(), other.body()) && Objects.equals(languageCode(), other.languageCode())
                && Objects.equals(originationNumber(), other.originationNumber())
                && Objects.equals(substitutions(), other.substitutions()) && Objects.equals(voiceId(), other.voiceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VoiceMessage").add("Body", body()).add("LanguageCode", languageCode())
                .add("OriginationNumber", originationNumber()).add("Substitutions", substitutions()).add("VoiceId", voiceId())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCode()));
        case "OriginationNumber":
            return Optional.ofNullable(clazz.cast(originationNumber()));
        case "Substitutions":
            return Optional.ofNullable(clazz.cast(substitutions()));
        case "VoiceId":
            return Optional.ofNullable(clazz.cast(voiceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VoiceMessage, T> g) {
        return obj -> g.apply((VoiceMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VoiceMessage> {
        /**
         * The message body of the notification, the email body or the text message.
         * 
         * @param body
         *        The message body of the notification, the email body or the text message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * Language of sent message
         * 
         * @param languageCode
         *        Language of sent message
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageCode(String languageCode);

        /**
         * Is the number from the pool or messaging service to send from.
         * 
         * @param originationNumber
         *        Is the number from the pool or messaging service to send from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originationNumber(String originationNumber);

        /**
         * Default message substitutions. Can be overridden by individual address substitutions.
         * 
         * @param substitutions
         *        Default message substitutions. Can be overridden by individual address substitutions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder substitutions(Map<String, ? extends Collection<String>> substitutions);

        /**
         * Voice ID of sent message.
         * 
         * @param voiceId
         *        Voice ID of sent message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceId(String voiceId);
    }

    static final class BuilderImpl implements Builder {
        private String body;

        private String languageCode;

        private String originationNumber;

        private Map<String, List<String>> substitutions = DefaultSdkAutoConstructMap.getInstance();

        private String voiceId;

        private BuilderImpl() {
        }

        private BuilderImpl(VoiceMessage model) {
            body(model.body);
            languageCode(model.languageCode);
            originationNumber(model.originationNumber);
            substitutions(model.substitutions);
            voiceId(model.voiceId);
        }

        public final String getBody() {
            return body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getOriginationNumber() {
            return originationNumber;
        }

        @Override
        public final Builder originationNumber(String originationNumber) {
            this.originationNumber = originationNumber;
            return this;
        }

        public final void setOriginationNumber(String originationNumber) {
            this.originationNumber = originationNumber;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            return substitutions;
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        public final String getVoiceId() {
            return voiceId;
        }

        @Override
        public final Builder voiceId(String voiceId) {
            this.voiceId = voiceId;
            return this;
        }

        public final void setVoiceId(String voiceId) {
            this.voiceId = voiceId;
        }

        @Override
        public VoiceMessage build() {
            return new VoiceMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
