/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * An email composed of a subject, a text part and a html part.
 */
@Generated("software.amazon.awssdk:codegen")
public final class SimpleEmail implements SdkPojo, Serializable, ToCopyableBuilder<SimpleEmail.Builder, SimpleEmail> {
    private static final SdkField<SimpleEmailPart> HTML_PART_FIELD = SdkField.<SimpleEmailPart> builder(MarshallingType.SDK_POJO)
            .getter(getter(SimpleEmail::htmlPart)).setter(setter(Builder::htmlPart)).constructor(SimpleEmailPart::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HtmlPart").build()).build();

    private static final SdkField<SimpleEmailPart> SUBJECT_FIELD = SdkField.<SimpleEmailPart> builder(MarshallingType.SDK_POJO)
            .getter(getter(SimpleEmail::subject)).setter(setter(Builder::subject)).constructor(SimpleEmailPart::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()).build();

    private static final SdkField<SimpleEmailPart> TEXT_PART_FIELD = SdkField.<SimpleEmailPart> builder(MarshallingType.SDK_POJO)
            .getter(getter(SimpleEmail::textPart)).setter(setter(Builder::textPart)).constructor(SimpleEmailPart::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextPart").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTML_PART_FIELD,
            SUBJECT_FIELD, TEXT_PART_FIELD));

    private static final long serialVersionUID = 1L;

    private final SimpleEmailPart htmlPart;

    private final SimpleEmailPart subject;

    private final SimpleEmailPart textPart;

    private SimpleEmail(BuilderImpl builder) {
        this.htmlPart = builder.htmlPart;
        this.subject = builder.subject;
        this.textPart = builder.textPart;
    }

    /**
     * The content of the message, in HTML format. Use this for email clients that can process HTML. You can include
     * clickable links, formatted text, and much more in an HTML message.
     * 
     * @return The content of the message, in HTML format. Use this for email clients that can process HTML. You can
     *         include clickable links, formatted text, and much more in an HTML message.
     */
    public SimpleEmailPart htmlPart() {
        return htmlPart;
    }

    /**
     * The subject of the message: A short summary of the content, which will appear in the recipient's inbox.
     * 
     * @return The subject of the message: A short summary of the content, which will appear in the recipient's inbox.
     */
    public SimpleEmailPart subject() {
        return subject;
    }

    /**
     * The content of the message, in text format. Use this for text-based email clients, or clients on high-latency
     * networks (such as mobile devices).
     * 
     * @return The content of the message, in text format. Use this for text-based email clients, or clients on
     *         high-latency networks (such as mobile devices).
     */
    public SimpleEmailPart textPart() {
        return textPart;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(htmlPart());
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(textPart());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleEmail)) {
            return false;
        }
        SimpleEmail other = (SimpleEmail) obj;
        return Objects.equals(htmlPart(), other.htmlPart()) && Objects.equals(subject(), other.subject())
                && Objects.equals(textPart(), other.textPart());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SimpleEmail").add("HtmlPart", htmlPart()).add("Subject", subject()).add("TextPart", textPart())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HtmlPart":
            return Optional.ofNullable(clazz.cast(htmlPart()));
        case "Subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "TextPart":
            return Optional.ofNullable(clazz.cast(textPart()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SimpleEmail, T> g) {
        return obj -> g.apply((SimpleEmail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SimpleEmail> {
        /**
         * The content of the message, in HTML format. Use this for email clients that can process HTML. You can include
         * clickable links, formatted text, and much more in an HTML message.
         * 
         * @param htmlPart
         *        The content of the message, in HTML format. Use this for email clients that can process HTML. You can
         *        include clickable links, formatted text, and much more in an HTML message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder htmlPart(SimpleEmailPart htmlPart);

        /**
         * The content of the message, in HTML format. Use this for email clients that can process HTML. You can include
         * clickable links, formatted text, and much more in an HTML message. This is a convenience that creates an
         * instance of the {@link SimpleEmailPart.Builder} avoiding the need to create one manually via
         * {@link SimpleEmailPart#builder()}.
         *
         * When the {@link Consumer} completes, {@link SimpleEmailPart.Builder#build()} is called immediately and its
         * result is passed to {@link #htmlPart(SimpleEmailPart)}.
         * 
         * @param htmlPart
         *        a consumer that will call methods on {@link SimpleEmailPart.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #htmlPart(SimpleEmailPart)
         */
        default Builder htmlPart(Consumer<SimpleEmailPart.Builder> htmlPart) {
            return htmlPart(SimpleEmailPart.builder().applyMutation(htmlPart).build());
        }

        /**
         * The subject of the message: A short summary of the content, which will appear in the recipient's inbox.
         * 
         * @param subject
         *        The subject of the message: A short summary of the content, which will appear in the recipient's
         *        inbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(SimpleEmailPart subject);

        /**
         * The subject of the message: A short summary of the content, which will appear in the recipient's inbox. This
         * is a convenience that creates an instance of the {@link SimpleEmailPart.Builder} avoiding the need to create
         * one manually via {@link SimpleEmailPart#builder()}.
         *
         * When the {@link Consumer} completes, {@link SimpleEmailPart.Builder#build()} is called immediately and its
         * result is passed to {@link #subject(SimpleEmailPart)}.
         * 
         * @param subject
         *        a consumer that will call methods on {@link SimpleEmailPart.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subject(SimpleEmailPart)
         */
        default Builder subject(Consumer<SimpleEmailPart.Builder> subject) {
            return subject(SimpleEmailPart.builder().applyMutation(subject).build());
        }

        /**
         * The content of the message, in text format. Use this for text-based email clients, or clients on high-latency
         * networks (such as mobile devices).
         * 
         * @param textPart
         *        The content of the message, in text format. Use this for text-based email clients, or clients on
         *        high-latency networks (such as mobile devices).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textPart(SimpleEmailPart textPart);

        /**
         * The content of the message, in text format. Use this for text-based email clients, or clients on high-latency
         * networks (such as mobile devices). This is a convenience that creates an instance of the
         * {@link SimpleEmailPart.Builder} avoiding the need to create one manually via
         * {@link SimpleEmailPart#builder()}.
         *
         * When the {@link Consumer} completes, {@link SimpleEmailPart.Builder#build()} is called immediately and its
         * result is passed to {@link #textPart(SimpleEmailPart)}.
         * 
         * @param textPart
         *        a consumer that will call methods on {@link SimpleEmailPart.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textPart(SimpleEmailPart)
         */
        default Builder textPart(Consumer<SimpleEmailPart.Builder> textPart) {
            return textPart(SimpleEmailPart.builder().applyMutation(textPart).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SimpleEmailPart htmlPart;

        private SimpleEmailPart subject;

        private SimpleEmailPart textPart;

        private BuilderImpl() {
        }

        private BuilderImpl(SimpleEmail model) {
            htmlPart(model.htmlPart);
            subject(model.subject);
            textPart(model.textPart);
        }

        public final SimpleEmailPart.Builder getHtmlPart() {
            return htmlPart != null ? htmlPart.toBuilder() : null;
        }

        @Override
        public final Builder htmlPart(SimpleEmailPart htmlPart) {
            this.htmlPart = htmlPart;
            return this;
        }

        public final void setHtmlPart(SimpleEmailPart.BuilderImpl htmlPart) {
            this.htmlPart = htmlPart != null ? htmlPart.build() : null;
        }

        public final SimpleEmailPart.Builder getSubject() {
            return subject != null ? subject.toBuilder() : null;
        }

        @Override
        public final Builder subject(SimpleEmailPart subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(SimpleEmailPart.BuilderImpl subject) {
            this.subject = subject != null ? subject.build() : null;
        }

        public final SimpleEmailPart.Builder getTextPart() {
            return textPart != null ? textPart.toBuilder() : null;
        }

        @Override
        public final Builder textPart(SimpleEmailPart textPart) {
            this.textPart = textPart;
            return this;
        }

        public final void setTextPart(SimpleEmailPart.BuilderImpl textPart) {
            this.textPart = textPart != null ? textPart.build() : null;
        }

        @Override
        public SimpleEmail build() {
            return new SimpleEmail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
