/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Information about a session.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Session implements SdkPojo, Serializable, ToCopyableBuilder<Session.Builder, Session> {
    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Session::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Session::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> START_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Session::startTimestamp)).setter(setter(Builder::startTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()).build();

    private static final SdkField<String> STOP_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Session::stopTimestamp)).setter(setter(Builder::stopTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_FIELD, ID_FIELD,
            START_TIMESTAMP_FIELD, STOP_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer duration;

    private final String id;

    private final String startTimestamp;

    private final String stopTimestamp;

    private Session(BuilderImpl builder) {
        this.duration = builder.duration;
        this.id = builder.id;
        this.startTimestamp = builder.startTimestamp;
        this.stopTimestamp = builder.stopTimestamp;
    }

    /**
     * The duration of the session, in milliseconds.
     * 
     * @return The duration of the session, in milliseconds.
     */
    public Integer duration() {
        return duration;
    }

    /**
     * A unique identifier for the session.
     * 
     * @return A unique identifier for the session.
     */
    public String id() {
        return id;
    }

    /**
     * The date and time when the session began.
     * 
     * @return The date and time when the session began.
     */
    public String startTimestamp() {
        return startTimestamp;
    }

    /**
     * The date and time when the session ended.
     * 
     * @return The date and time when the session ended.
     */
    public String stopTimestamp() {
        return stopTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(stopTimestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Session)) {
            return false;
        }
        Session other = (Session) obj;
        return Objects.equals(duration(), other.duration()) && Objects.equals(id(), other.id())
                && Objects.equals(startTimestamp(), other.startTimestamp())
                && Objects.equals(stopTimestamp(), other.stopTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Session").add("Duration", duration()).add("Id", id()).add("StartTimestamp", startTimestamp())
                .add("StopTimestamp", stopTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "StartTimestamp":
            return Optional.ofNullable(clazz.cast(startTimestamp()));
        case "StopTimestamp":
            return Optional.ofNullable(clazz.cast(stopTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Session, T> g) {
        return obj -> g.apply((Session) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Session> {
        /**
         * The duration of the session, in milliseconds.
         * 
         * @param duration
         *        The duration of the session, in milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * A unique identifier for the session.
         * 
         * @param id
         *        A unique identifier for the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The date and time when the session began.
         * 
         * @param startTimestamp
         *        The date and time when the session began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimestamp(String startTimestamp);

        /**
         * The date and time when the session ended.
         * 
         * @param stopTimestamp
         *        The date and time when the session ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopTimestamp(String stopTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private Integer duration;

        private String id;

        private String startTimestamp;

        private String stopTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Session model) {
            duration(model.duration);
            id(model.id);
            startTimestamp(model.startTimestamp);
            stopTimestamp(model.stopTimestamp);
        }

        public final Integer getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getStartTimestamp() {
            return startTimestamp;
        }

        @Override
        public final Builder startTimestamp(String startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final void setStartTimestamp(String startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        public final String getStopTimestamp() {
            return stopTimestamp;
        }

        @Override
        public final Builder stopTimestamp(String stopTimestamp) {
            this.stopTimestamp = stopTimestamp;
            return this;
        }

        public final void setStopTimestamp(String stopTimestamp) {
            this.stopTimestamp = stopTimestamp;
        }

        @Override
        public Session build() {
            return new Session(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
