/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Segments in your account.
 */
@Generated("software.amazon.awssdk:codegen")
public final class SegmentsResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<SegmentsResponse.Builder, SegmentsResponse> {
    private static final SdkField<List<SegmentResponse>> ITEM_FIELD = SdkField
            .<List<SegmentResponse>> builder(MarshallingType.LIST)
            .getter(getter(SegmentsResponse::item))
            .setter(setter(Builder::item))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SegmentResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(SegmentResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SegmentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_FIELD, NEXT_TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<SegmentResponse> item;

    private final String nextToken;

    private SegmentsResponse(BuilderImpl builder) {
        this.item = builder.item;
        this.nextToken = builder.nextToken;
    }

    /**
     * The list of segments.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of segments.
     */
    public List<SegmentResponse> item() {
        return item;
    }

    /**
     * An identifier used to retrieve the next page of results. The token is null if no additional pages exist.
     * 
     * @return An identifier used to retrieve the next page of results. The token is null if no additional pages exist.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(item());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentsResponse)) {
            return false;
        }
        SegmentsResponse other = (SegmentsResponse) obj;
        return Objects.equals(item(), other.item()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SegmentsResponse").add("Item", item()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Item":
            return Optional.ofNullable(clazz.cast(item()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SegmentsResponse, T> g) {
        return obj -> g.apply((SegmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SegmentsResponse> {
        /**
         * The list of segments.
         * 
         * @param item
         *        The list of segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder item(Collection<SegmentResponse> item);

        /**
         * The list of segments.
         * 
         * @param item
         *        The list of segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder item(SegmentResponse... item);

        /**
         * The list of segments. This is a convenience that creates an instance of the {@link List
         * <SegmentResponse>.Builder} avoiding the need to create one manually via {@link List
         * <SegmentResponse>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SegmentResponse>.Builder#build()} is called immediately and
         * its result is passed to {@link #item(List<SegmentResponse>)}.
         * 
         * @param item
         *        a consumer that will call methods on {@link List<SegmentResponse>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #item(List<SegmentResponse>)
         */
        Builder item(Consumer<SegmentResponse.Builder>... item);

        /**
         * An identifier used to retrieve the next page of results. The token is null if no additional pages exist.
         * 
         * @param nextToken
         *        An identifier used to retrieve the next page of results. The token is null if no additional pages
         *        exist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<SegmentResponse> item = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentsResponse model) {
            item(model.item);
            nextToken(model.nextToken);
        }

        public final Collection<SegmentResponse.Builder> getItem() {
            return item != null ? item.stream().map(SegmentResponse::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder item(Collection<SegmentResponse> item) {
            this.item = ListOfSegmentResponseCopier.copy(item);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(SegmentResponse... item) {
            item(Arrays.asList(item));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(Consumer<SegmentResponse.Builder>... item) {
            item(Stream.of(item).map(c -> SegmentResponse.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItem(Collection<SegmentResponse.BuilderImpl> item) {
            this.item = ListOfSegmentResponseCopier.copyFromBuilder(item);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public SegmentsResponse build() {
            return new SegmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
